/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kuksa.appstore.ui;

import com.vaadin.data.Binder;
import com.vaadin.data.HasValue;
import com.vaadin.data.ValueProvider;
import com.vaadin.navigator.View;
import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.server.FontAwesome;
import com.vaadin.server.Resource;
import com.vaadin.server.Setter;
import com.vaadin.server.Sizeable;
import com.vaadin.shared.ui.dnd.DropEffect;
import com.vaadin.spring.annotation.SpringComponent;
import com.vaadin.spring.annotation.UIScope;
import com.vaadin.ui.Button;
import com.vaadin.ui.ComboBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.Grid;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.ItemCaptionGenerator;
import com.vaadin.ui.TextField;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.components.grid.GridRowDragger;
import com.vaadin.ui.dnd.event.DragEndListener;
import com.vaadin.ui.dnd.event.DragStartListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.kuksa.appstore.model.User;
import org.eclipse.kuksa.appstore.model.UserType;
import org.eclipse.kuksa.appstore.service.OemService;
import org.eclipse.kuksa.appstore.service.UserService;
import org.eclipse.kuksa.appstore.ui.UserEditor;

@SpringComponent
@UIScope
public class UserEditor
extends VerticalLayout
implements View {
    private UserService userService;
    private OemService oemService;
    public User user;
    public TextField username = new TextField("Username");
    public TextField password = new TextField("Password");
    public ComboBox<String> comboBoxUserType = new ComboBox("User Type");
    public ComboBox<String> comboBoxOem = new ComboBox("Select an Oem");
    public Button save = new Button("Save", (Resource)FontAwesome.SAVE);
    public Button delete = new Button("Delete", (Resource)FontAwesome.TRASH_O);
    VerticalLayout mainLayout = new VerticalLayout();
    HorizontalLayout vlayout = new HorizontalLayout();
    Binder<User> binder = new Binder(User.class);
    Grid<User> left = new Grid(User.class);
    Grid<User> right = new Grid(User.class);

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public void setOemService(OemService oemService) {
        this.oemService = oemService;
    }

    public UserEditor() {
        this.comboBoxOem.setEmptySelectionAllowed(true);
        this.comboBoxOem.setTextInputAllowed(true);
        this.comboBoxUserType.setEmptySelectionAllowed(false);
        this.comboBoxUserType.setTextInputAllowed(false);
        this.vlayout.addComponents(new Component[]{this.username, this.password, this.comboBoxUserType, this.comboBoxOem});
        this.mainLayout.addComponent((Component)this.vlayout);
        this.vlayout = new HorizontalLayout();
        this.vlayout.addComponents(new Component[]{this.left, this.right});
        this.mainLayout.addComponent((Component)this.vlayout);
        this.vlayout = new HorizontalLayout();
        this.vlayout.addComponents(new Component[]{this.save, this.delete});
        this.mainLayout.addComponent((Component)this.vlayout);
        this.addComponents(new Component[]{this.mainLayout});
        this.binder.forField((HasValue)this.comboBoxUserType).bind((ValueProvider & Serializable)User2 -> {
            if (User2.getUserType() != null) {
                return User2.getUserType().toString();
            }
            return null;
        }, (Setter & Serializable)(User2, usertype) -> {
            UserType newUserType = UserType.valueOf((String)usertype);
            User2.setUserType(newUserType);
        });
        this.binder.forField((HasValue)this.comboBoxOem).bind((ValueProvider & Serializable)User2 -> {
            if (User2.getOem() != null) {
                return User2.getOem().getId().toString();
            }
            return null;
        }, (Setter & Serializable)(User2, oem) -> {
            if (oem != null) {
                User2.setOem(this.oemService.findById(Long.valueOf(Long.parseLong(oem))));
            } else {
                User2.setOem(null);
            }
        });
        this.binder.bindInstanceFields((Object)this);
        this.setSpacing(true);
        this.save.setStyleName("primary");
        this.save.setClickShortcut(13, new int[0]);
        this.delete.setStyleName("danger");
        this.setVisible(false);
        this.comboBoxOem.setVisible(false);
        this.left.setVisible(false);
        this.right.setVisible(false);
        this.comboBoxUserType.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
            if (((String)event.getValue()).equals(UserType.GroupAdmin.toString())) {
                this.comboBoxOem.setVisible(true);
                this.left.setVisible(true);
                this.right.setVisible(true);
            } else {
                this.comboBoxOem.setVisible(false);
                this.left.setVisible(false);
                this.right.setVisible(false);
            }
        });
        1 icg = new /* Unavailable Anonymous Inner Class!! */;
        this.comboBoxOem.setItemCaptionGenerator((ItemCaptionGenerator)icg);
        this.left.setColumns(new String[]{"id", "username"});
        this.left.setCaption("Users");
        this.right.setColumns(new String[]{"id", "username"});
        this.right.setCaption("Members");
        this.left.setWidth(300.0f, Sizeable.Unit.PIXELS);
        this.right.setWidth(300.0f, Sizeable.Unit.PIXELS);
        GridRowDragger leftToRight = new GridRowDragger(this.left, this.right);
        GridRowDragger rightToLeft = new GridRowDragger(this.right, this.left);
        leftToRight.getGridDragSource().addDragStartListener((DragStartListener & Serializable)event -> rightToLeft.getGridDropTarget().setDropEffect(DropEffect.MOVE));
        leftToRight.getGridDragSource().addDragEndListener((DragEndListener & Serializable)event -> rightToLeft.getGridDropTarget().setDropEffect(DropEffect.MOVE));
        rightToLeft.getGridDragSource().addDragStartListener((DragStartListener & Serializable)event -> leftToRight.getGridDropTarget().setDropEffect(DropEffect.MOVE));
        rightToLeft.getGridDragSource().addDragEndListener((DragEndListener & Serializable)event -> leftToRight.getGridDropTarget().setDropEffect(DropEffect.MOVE));
    }

    public final void editUser(User u) {
        if (u == null) {
            this.setVisible(false);
            return;
        }
        boolean persisted = u.getId() != null;
        this.user = persisted ? this.userService.findById(Long.toString(u.getId())) : u;
        this.delete.setVisible(persisted);
        this.binder.setBean((Object)this.user);
        this.setVisible(true);
        this.save.focus();
        this.username.selectAll();
        this.comboBoxUserType.setItems((Object[])new String[]{UserType.Normal.toString(), UserType.SystemAdmin.toString(), UserType.GroupAdmin.toString()});
        List oemlist = this.oemService.getAllId();
        this.comboBoxOem.setItems((Collection)oemlist);
        this.fillGrids(this.user);
    }

    public void fillGrids(User user) {
        ArrayList rightList = new ArrayList();
        if (user.getMembers() != null) {
            rightList.addAll(user.getMembers());
        }
        ArrayList<Long> notInList = new ArrayList<Long>();
        if (user.getId() != null) {
            notInList.add(user.getId());
        }
        for (int i = 0; i < rightList.size(); ++i) {
            notInList.add(((User)rightList.get(i)).getId());
        }
        if (notInList.size() != 0) {
            this.left.setItems((Collection)this.userService.findByIdNotIn(notInList));
        } else {
            this.left.setItems((Collection)this.userService.findAll());
        }
        this.right.setItems(rightList);
    }

    public void setChangeHandler(ChangeHandler h) {
        this.save.addClickListener((Button.ClickListener & Serializable)e -> h.onChange());
        this.delete.addClickListener((Button.ClickListener & Serializable)e -> h.onChange());
    }

    public void enter(ViewChangeListener.ViewChangeEvent event) {
    }

    static /* synthetic */ OemService access$000(UserEditor x0) {
        return x0.oemService;
    }
}

