/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kuksa.appstore.ui.component;

import com.vaadin.event.MouseEvents;
import com.vaadin.server.FileResource;
import com.vaadin.server.Page;
import com.vaadin.server.Resource;
import com.vaadin.server.ThemeResource;
import com.vaadin.server.VaadinSession;
import com.vaadin.ui.Component;
import com.vaadin.ui.Image;
import com.vaadin.ui.Label;
import com.vaadin.ui.VerticalLayout;
import java.io.File;
import java.io.Serializable;
import org.eclipse.kuksa.appstore.model.App;
import org.eclipse.kuksa.appstore.utils.Utils;

public class AppViewBox {
    public static VerticalLayout createAppViewBox(App app) {
        VerticalLayout vinsidelayout = new VerticalLayout();
        String imageName = "app" + app.getId() + ".png";
        Image image = new Image();
        File new_file = new File(Utils.getImageFolderPath() + File.separator + imageName);
        if (new_file.exists()) {
            image.setSource((Resource)new FileResource(new_file));
        } else {
            image.setSource((Resource)new ThemeResource("img/noimage.png"));
        }
        image.setWidth("300");
        image.setHeight("200");
        image.addClickListener((MouseEvents.ClickListener & Serializable)e -> {
            VaadinSession.getCurrent().setAttribute("app", (Object)app.getId());
            Page.getCurrent().setUriFragment("!app");
        });
        Label namelabel = new Label(app.getName());
        namelabel.setWidth("300");
        namelabel.addStyleName("bold");
        Label versionlabel = new Label(app.getVersion() + "    /    " + app.getOwner());
        versionlabel.setWidth("300");
        vinsidelayout.addComponent((Component)image);
        vinsidelayout.addComponent((Component)namelabel);
        vinsidelayout.addComponent((Component)versionlabel);
        return vinsidelayout;
    }
}

