/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kuksa.appstore.utils;

import java.io.File;
import java.util.List;
import org.eclipse.kuksa.appstore.model.User;
import org.eclipse.kuksa.appstore.model.hawkbit.SoftwareModule;

public class Utils {
    private static final String IMAGE_FILE_PATH = System.getProperty("user.dir") + File.separator + "imgs" + File.separator + "app";
    public static final String UNINSTALLED_ALL = "UNINSTALLED_ALL";
    private static final String IMAGE_FOLDER_PATH = System.getProperty("user.dir") + File.separator + "imgs";

    public static String getImageFilePath() {
        return IMAGE_FILE_PATH;
    }

    public static String getImageFolderPath() {
        return IMAGE_FOLDER_PATH;
    }

    public static String getFileExtension(File file) {
        String name = file.getName();
        int lastIndexOf = name.lastIndexOf(".");
        if (lastIndexOf == -1) {
            return "";
        }
        return name.substring(lastIndexOf);
    }

    public static Integer getExistsSoftwareModule(List<SoftwareModule> listsoftwareModules) {
        for (SoftwareModule softwareModule : listsoftwareModules) {
            if (softwareModule.isDeleted()) continue;
            return softwareModule.getId();
        }
        return null;
    }

    public static String createFIQLEqual(String fieldName, String value) {
        return fieldName + "==" + value;
    }

    public static String createDistributionName(Long appId) {
        return "distribution" + appId;
    }

    public static String createSoftwareName(Long appId) {
        return "software" + appId;
    }

    public static boolean isAppAlreadyInstalled(SoftwareModule softwareModule, List<SoftwareModule> softwareModuleList) {
        for (SoftwareModule indexSoftwareModule : softwareModuleList) {
            if (!indexSoftwareModule.getId().equals(softwareModule.getId())) continue;
            return true;
        }
        return false;
    }

    public static List<SoftwareModule> UninstallApp(SoftwareModule softwareModule, List<SoftwareModule> softwareModuleList) {
        for (SoftwareModule indexSoftwareModule : softwareModuleList) {
            if (!indexSoftwareModule.getId().equals(softwareModule.getId())) continue;
            softwareModuleList.remove(indexSoftwareModule);
            return softwareModuleList;
        }
        return softwareModuleList;
    }

    public static boolean isUserAlreadyOwner(User user, List<User> ownerList) {
        for (User indexUser : ownerList) {
            if (!indexUser.getId().equals(user.getId())) continue;
            return true;
        }
        return false;
    }

    public static List<User> removeOwnerUser(User user, List<User> ownerList) {
        for (User indexUser : ownerList) {
            if (!indexUser.getId().equals(user.getId())) continue;
            ownerList.remove(indexUser);
            return ownerList;
        }
        return ownerList;
    }
}

