/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kuksa.influxdb.rest;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.kuksa.influxdb.rest.HttpQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
public class Controller {
    private static final Logger LOGGER = LoggerFactory.getLogger(Controller.class);
    private static final JsonNodeFactory FACTORY = JsonNodeFactory.instance;
    private final String dbName;
    private final URL url;

    public Controller(@Value(value="${influxDB.db.name}") String dbName, @Value(value="${influxDB.url}") String url, @Value(value="${influxDB.port}") int port) throws MalformedURLException {
        Objects.requireNonNull(dbName);
        Objects.requireNonNull(url);
        this.dbName = dbName;
        this.url = new URL(url + ':' + port);
    }

    @GetMapping(value={"/devices"})
    public ResponseEntity<List<String>> getDevices() {
        JsonNode response;
        try {
            response = this.queryInfluxDB("SHOW SERIES ON " + this.dbName);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(Collections.singletonList(e.getMessage()));
        }
        ArrayList<String> result = new ArrayList<String>();
        try {
            ArrayNode values = (ArrayNode)Controller.getFirstSeries((JsonNode)response).get("values");
            for (JsonNode value : values) {
                String device;
                ArrayNode valueArray = (ArrayNode)value;
                if (valueArray.size() <= 0 || !valueArray.get(0).isTextual() || StringUtils.isEmpty((Object)(device = valueArray.get(0).asText())) || device.contains(",")) continue;
                result.add(device);
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
        return ResponseEntity.ok(result);
    }

    @GetMapping(value={"/devices/{id}"})
    public ResponseEntity<List<JsonNode>> getMeasurements(@PathVariable String id, @RequestParam(required=false) String from, @RequestParam(required=false) String to, @RequestParam(required=false) String at) {
        try {
            List results = this.queryRoots(id, from, to, at);
            if (results == null) {
                results = Collections.emptyList();
            }
            return ResponseEntity.ok(results);
        }
        catch (NullPointerException n) {
            return ResponseEntity.ok(Collections.emptyList());
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(Collections.singletonList(JsonNodeFactory.instance.textNode(e.getMessage())));
        }
    }

    private static JsonNode getFirstSeries(JsonNode root) {
        return root.get("results").get(0).get("series").get(0);
    }

    private static boolean requiresLatestObject(String from, String to, String at) {
        return from == null && to == null && at == null;
    }

    private JsonNode buildLatestTree(JsonNode root) {
        ObjectNode result = FACTORY.objectNode();
        JsonNode series = Controller.getFirstSeries((JsonNode)root);
        ArrayNode columns = (ArrayNode)series.get("columns");
        String[][] columnSplits = new String[columns.size()][];
        for (int i = 0; i < columns.size(); ++i) {
            columnSplits[i] = columns.get(i).asText().toLowerCase().split("\\.");
        }
        ArrayNode values = (ArrayNode)series.get("values");
        block1: for (int i = 1; i < columnSplits.length; ++i) {
            for (JsonNode measurementRow : values) {
                ArrayNode measurementArray;
                JsonNode measurement;
                if (measurementRow == null || !measurementRow.isArray() || (measurement = (measurementArray = (ArrayNode)measurementRow).get(i)) == null || StringUtils.isEmpty((Object)measurement.asText()) || measurement.asText().equalsIgnoreCase("null")) continue;
                Controller.buildUpTree((ObjectNode)result, (String[])columnSplits[i], (String)measurement.asText());
                continue block1;
            }
        }
        return result;
    }

    private List<JsonNode> buildTrees(JsonNode root) {
        JsonNode series = Controller.getFirstSeries((JsonNode)root);
        ArrayNode columns = (ArrayNode)series.get("columns");
        String[][] columnSplits = new String[columns.size()][];
        for (int i = 0; i < columns.size(); ++i) {
            columnSplits[i] = columns.get(i).asText().toLowerCase().split("\\.");
        }
        ArrayList<JsonNode> result = new ArrayList<JsonNode>();
        ArrayNode values = (ArrayNode)series.get("values");
        for (JsonNode measurementRow : values) {
            ArrayNode measurementArray;
            if (measurementRow == null || !measurementRow.isArray() || (measurementArray = (ArrayNode)measurementRow).size() <= 0) continue;
            ObjectNode timeNode = FACTORY.objectNode();
            timeNode.set("time", (JsonNode)FACTORY.textNode(measurementArray.get(0).asText()));
            for (int i = 1; i < measurementRow.size(); ++i) {
                Controller.buildUpTree((ObjectNode)timeNode, (String[])columnSplits[i], (String)measurementRow.get(i).asText());
            }
            result.add((JsonNode)timeNode);
        }
        return result;
    }

    private static void buildUpTree(ObjectNode node, String[] hierarchy, String value) {
        for (int i = 0; i < hierarchy.length - 1; ++i) {
            String step = hierarchy[i];
            JsonNode child = node.get(step);
            if (child != null && child.isObject()) {
                node = (ObjectNode)child;
                continue;
            }
            ObjectNode next = FACTORY.objectNode();
            node.set(step, (JsonNode)next);
            if (child != null) {
                next.set("_value", child);
            }
            node = next;
        }
        node.set(hierarchy[hierarchy.length - 1], Controller.createNewNode((String)value));
    }

    private static JsonNode createNewNode(String s) {
        if (StringUtils.isEmpty((Object)s)) {
            return FACTORY.nullNode();
        }
        if (s.equalsIgnoreCase("true")) {
            return FACTORY.booleanNode(true);
        }
        if (s.equalsIgnoreCase("false")) {
            return FACTORY.booleanNode(false);
        }
        try {
            long value = Long.parseLong(s);
            return FACTORY.numberNode(value);
        }
        catch (NumberFormatException value) {
            try {
                double value2 = Double.parseDouble(s);
                return FACTORY.numberNode(value2);
            }
            catch (NumberFormatException numberFormatException) {
                return FACTORY.textNode(s);
            }
        }
    }

    private List<JsonNode> queryRoots(String id, String from, String to, String at) throws IOException {
        JsonNode query = this.querySeries(id, from, to, at);
        if (query == null) {
            return Collections.emptyList();
        }
        if (Controller.requiresLatestObject((String)from, (String)to, (String)at)) {
            return Collections.singletonList(this.buildLatestTree(query));
        }
        return this.buildTrees(query);
    }

    private JsonNode querySeries(String table, String from, String to, String at) throws IOException {
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT * FROM \"");
        builder.append(table);
        builder.append('\"');
        if (Controller.requiresLatestObject((String)from, (String)to, (String)at)) {
            ZonedDateTime time = LocalDateTime.now().atZone(ZoneId.systemDefault()).minusDays(1L);
            from = time.format(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss'Z'"));
        }
        builder.append(" WHERE");
        if (at != null) {
            builder.append(" time = '");
            builder.append(at);
            builder.append('\'');
        } else {
            if (from != null) {
                builder.append(" time >= '");
                builder.append(from);
                builder.append('\'');
                if (to != null) {
                    builder.append(" AND");
                }
            }
            if (to != null) {
                builder.append(" time <= '");
                builder.append(to);
                builder.append('\'');
            }
        }
        builder.append(" ORDER BY time DESC");
        return this.queryInfluxDB(builder.toString());
    }

    private JsonNode queryInfluxDB(String query) throws IOException {
        URL buildURL = Controller.generateQueryUrl((URL)this.url, (Map)this.createParameters(query));
        String json = HttpQuery.get((URL)buildURL);
        return new ObjectMapper().readTree(json);
    }

    private Map<String, String> createParameters(String query) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("db", this.dbName);
        parameters.put("q", query);
        return parameters;
    }

    private static URL generateQueryUrl(URL url, Map<String, String> parameters) throws MalformedURLException {
        StringBuilder builder = new StringBuilder();
        builder.append("/query?");
        Iterator<String> keyIterator = parameters.keySet().iterator();
        while (keyIterator.hasNext()) {
            String key = keyIterator.next();
            builder.append(key);
            builder.append('=');
            builder.append(parameters.get(key));
            if (!keyIterator.hasNext()) continue;
            builder.append('&');
        }
        return new URL(url, builder.toString());
    }
}

