/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.client.ui.network;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.SelectionChangeEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.kura.web.client.messages.Messages;
import org.eclipse.kura.web.client.ui.EntryClassUi;
import org.eclipse.kura.web.client.ui.network.NetworkInterfacesTableUi;
import org.eclipse.kura.web.client.ui.network.NetworkTabsUi;
import org.eclipse.kura.web.client.util.FailureHandler;
import org.eclipse.kura.web.shared.model.GwtNetIfConfigMode;
import org.eclipse.kura.web.shared.model.GwtNetInterfaceConfig;
import org.eclipse.kura.web.shared.model.GwtSession;
import org.eclipse.kura.web.shared.model.GwtXSRFToken;
import org.eclipse.kura.web.shared.service.GwtNetworkService;
import org.eclipse.kura.web.shared.service.GwtNetworkServiceAsync;
import org.eclipse.kura.web.shared.service.GwtSecurityTokenService;
import org.eclipse.kura.web.shared.service.GwtSecurityTokenServiceAsync;
import org.gwtbootstrap3.client.ui.Alert;
import org.gwtbootstrap3.client.ui.AnchorButton;
import org.gwtbootstrap3.client.ui.Modal;
import org.gwtbootstrap3.client.ui.html.Text;

public class NetworkButtonBarUi
extends Composite {
    private static final String IPV4_MODE_MANUAL_NAME = GwtNetIfConfigMode.netIPv4ConfigModeManual.name();
    private static NetworkButtonBarUiUiBinder uiBinder = (NetworkButtonBarUiUiBinder)GWT.create(NetworkButtonBarUiUiBinder.class);
    private static final Logger logger = Logger.getLogger(NetworkButtonBarUi.class.getSimpleName());
    private final GwtSecurityTokenServiceAsync gwtXSRFService = (GwtSecurityTokenServiceAsync)GWT.create(GwtSecurityTokenService.class);
    private final GwtNetworkServiceAsync gwtNetworkService = (GwtNetworkServiceAsync)GWT.create(GwtNetworkService.class);
    private static final Messages MSGS = (Messages)GWT.create(Messages.class);
    GwtSession session;
    NetworkInterfacesTableUi table;
    NetworkTabsUi tabs;
    @UiField
    AnchorButton apply;
    @UiField
    AnchorButton refresh;
    @UiField
    Modal incompleteFieldsModal;
    @UiField
    Alert incompleteFields;
    @UiField
    Text incompleteFieldsText;

    public NetworkButtonBarUi(GwtSession currentSession, NetworkTabsUi tabsPanel, NetworkInterfacesTableUi interfaces) {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.session = currentSession;
        this.table = interfaces;
        this.tabs = tabsPanel;
        this.initButtons();
        this.initModal();
    }

    private void initButtons() {
        this.initApplyButton();
        this.initRefreshButton();
        this.table.interfacesGrid.getSelectionModel().addSelectionChangeHandler(new SelectionChangeEvent.Handler(){

            public void onSelectionChange(SelectionChangeEvent event) {
                NetworkButtonBarUi.this.apply.setEnabled(true);
            }
        });
    }

    protected void initRefreshButton() {
        this.refresh.setText(MSGS.refresh());
        this.refresh.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                NetworkButtonBarUi.this.table.refresh();
                NetworkButtonBarUi.this.tabs.setDirty(false);
                NetworkButtonBarUi.this.tabs.refresh();
                NetworkButtonBarUi.this.tabs.adjustInterfaceTabs();
            }
        });
    }

    protected void initApplyButton() {
        this.apply.setText(MSGS.apply());
        this.apply.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (!NetworkButtonBarUi.this.tabs.visibleTabs.isEmpty() && NetworkButtonBarUi.this.tabs.isValid()) {
                    GwtNetInterfaceConfig prevNetIf = (GwtNetInterfaceConfig)NetworkButtonBarUi.this.table.selectionModel.getSelectedObject();
                    GwtNetInterfaceConfig updatedNetIf = NetworkButtonBarUi.this.tabs.getUpdatedInterface();
                    if (prevNetIf != null && prevNetIf.equals(updatedNetIf)) {
                        NetworkButtonBarUi.this.table.refresh();
                        NetworkButtonBarUi.this.apply.setEnabled(false);
                    } else {
                        String newNetwork = null;
                        String prevNetwork = null;
                        try {
                            newNetwork = NetworkButtonBarUi.this.calculateNetwork(updatedNetIf.getIpAddress(), updatedNetIf.getSubnetMask());
                            prevNetwork = NetworkButtonBarUi.this.calculateNetwork(Window.Location.getHost(), updatedNetIf.getSubnetMask());
                        }
                        catch (Exception exception) {}
                        NetworkButtonBarUi.this.scheduleRefresh(prevNetIf, updatedNetIf, newNetwork, prevNetwork);
                        EntryClassUi.showWaitModal();
                        NetworkButtonBarUi.this.updateNetConfiguration(updatedNetIf);
                    }
                } else {
                    logger.log(Level.FINER, String.valueOf(MSGS.information()) + ": " + MSGS.deviceConfigError());
                    NetworkButtonBarUi.this.incompleteFieldsModal.show();
                }
            }
        });
    }

    private void scheduleRefresh(GwtNetInterfaceConfig prevNetIf, final GwtNetInterfaceConfig updatedNetIf, String newNetwork, String prevNetwork) {
        if (this.isRefreshNeeded(prevNetIf, updatedNetIf, newNetwork, prevNetwork)) {
            Timer t = new Timer(){

                public void run() {
                    Window.Location.replace((String)("http://" + updatedNetIf.getIpAddress()));
                }
            };
            t.schedule(500);
        }
    }

    private void updateNetConfiguration(final GwtNetInterfaceConfig updatedNetIf) {
        this.gwtXSRFService.generateSecurityToken(new AsyncCallback<GwtXSRFToken>(){

            public void onFailure(Throwable ex) {
                EntryClassUi.hideWaitModal();
                FailureHandler.handle(ex, NetworkButtonBarUi.class.getSimpleName());
            }

            public void onSuccess(GwtXSRFToken token) {
                NetworkButtonBarUi.this.gwtNetworkService.updateNetInterfaceConfigurations(token, updatedNetIf, new AsyncCallback<Void>(){

                    public void onFailure(Throwable ex) {
                        EntryClassUi.hideWaitModal();
                        FailureHandler.handle(ex, NetworkButtonBarUi.class.getSimpleName());
                    }

                    public void onSuccess(Void result) {
                        EntryClassUi.hideWaitModal();
                        (this).NetworkButtonBarUi.this.tabs.setDirty(false);
                        (this).NetworkButtonBarUi.this.table.refresh();
                        (this).NetworkButtonBarUi.this.tabs.refresh();
                        (this).NetworkButtonBarUi.this.apply.setEnabled(false);
                    }
                });
            }
        });
    }

    private String calculateNetwork(String ipAddress, String netmask) {
        if (ipAddress == null || ipAddress.isEmpty() || netmask == null || netmask.isEmpty()) {
            return null;
        }
        String network = null;
        try {
            int ipAddressValue = 0;
            int netmaskValue = 0;
            String[] sa = this.splitIp(ipAddress);
            int i = 24;
            int t = 0;
            while (i >= 0) {
                ipAddressValue |= Integer.parseInt(sa[t]) << i;
                i -= 8;
                ++t;
            }
            sa = this.splitIp(netmask);
            i = 24;
            t = 0;
            while (i >= 0) {
                netmaskValue |= Integer.parseInt(sa[t]) << i;
                i -= 8;
                ++t;
            }
            network = this.dottedQuad(ipAddressValue & netmaskValue);
        }
        catch (Exception e) {
            logger.warning(e.getLocalizedMessage());
        }
        return network;
    }

    private String dottedQuad(int ip) {
        StringBuilder sb = new StringBuilder(15);
        int shift = 24;
        while (shift > 0) {
            sb.append(Integer.toString(ip >>> shift & 0xFF));
            sb.append('.');
            shift -= 8;
        }
        sb.append(Integer.toString(ip & 0xFF));
        return sb.toString();
    }

    private String[] splitIp(String ip) {
        String sIp = ip;
        String[] ret = new String[4];
        int ind = 0;
        int i = 0;
        while (i < 3) {
            ind = sIp.indexOf(46);
            if (ind >= 0) {
                ret[i] = sIp.substring(0, ind);
                sIp = sIp.substring(ind + 1);
                if (i == 2) {
                    ret[3] = sIp;
                }
            }
            ++i;
        }
        return ret;
    }

    private void initModal() {
        this.incompleteFieldsModal.setTitle(MSGS.warning());
        this.incompleteFieldsText.setText(MSGS.formWithErrorsOrIncomplete());
    }

    private boolean isRefreshNeeded(GwtNetInterfaceConfig prevNetIf, GwtNetInterfaceConfig updatedNetIf, String newNetwork, String prevNetwork) {
        return newNetwork != null && prevNetIf != null && updatedNetIf.getConfigMode().equals(IPV4_MODE_MANUAL_NAME) && newNetwork.equals(prevNetwork) && Window.Location.getHost().equals(prevNetIf.getIpAddress());
    }

    static interface NetworkButtonBarUiUiBinder
    extends UiBinder<Widget, NetworkButtonBarUi> {
    }
}

