/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.metatype.impl;

import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.equinox.metatype.EquinoxAttributeDefinition;
import org.eclipse.equinox.metatype.impl.ExtendableHelper;
import org.eclipse.equinox.metatype.impl.LocalizationElement;
import org.eclipse.equinox.metatype.impl.MetaTypeMsg;
import org.eclipse.equinox.metatype.impl.ValueTokenizer;
import org.eclipse.osgi.util.NLS;
import org.osgi.service.log.LogService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeDefinitionImpl
extends LocalizationElement
implements EquinoxAttributeDefinition,
Cloneable {
    String _name;
    String _id;
    String _description;
    int _cardinality = 0;
    int _dataType;
    Object _minValue = null;
    Object _maxValue = null;
    boolean _isRequired = true;
    String[] _defaults = null;
    Vector<String> _values = new Vector(7);
    Vector<String> _labels = new Vector(7);
    private final LogService logger;
    private final ExtendableHelper helper;

    public AttributeDefinitionImpl(String id, String name, String description, int type, int cardinality, Object min, Object max, boolean isRequired, String localization, LogService logger, Map<String, Map<String, String>> extensionAttributes) {
        this(id, name, description, type, cardinality, min, max, isRequired, localization, logger, new ExtendableHelper(extensionAttributes));
    }

    private AttributeDefinitionImpl(String id, String name, String description, int type, int cardinality, Object min, Object max, boolean isRequired, String localization, LogService logger, ExtendableHelper helper) {
        super(localization);
        this._id = id;
        this._name = name;
        this._description = description;
        this._dataType = type;
        this._cardinality = cardinality;
        this._minValue = min;
        this._maxValue = max;
        this._isRequired = isRequired;
        this.logger = logger;
        this.helper = helper;
    }

    public synchronized Object clone() {
        AttributeDefinitionImpl ad = new AttributeDefinitionImpl(this._id, this._name, this._description, this._dataType, this._cardinality, this._minValue, this._maxValue, this._isRequired, this.getLocalization(), this.logger, this.helper);
        if (this._defaults != null) {
            ad.setDefaultValue((String[])this._defaults.clone());
        }
        if (this._labels != null && this._values != null) {
            Vector labels = (Vector)this._labels.clone();
            Vector values = (Vector)this._values.clone();
            ad.setOption(labels, values, false);
        }
        return ad;
    }

    public String getName() {
        return this.getLocalized(this._name);
    }

    void setName(String name) {
        this._name = name;
    }

    public String getID() {
        return this._id;
    }

    void setID(String id) {
        this._id = id;
    }

    public String getDescription() {
        return this.getLocalized(this._description);
    }

    void setDescription(String description) {
        this._description = description;
    }

    public int getCardinality() {
        return this._cardinality;
    }

    void setCardinality(int cardinality) {
        this._cardinality = cardinality;
    }

    public int getType() {
        return this._dataType;
    }

    void setType(int type) {
        this._dataType = type;
    }

    boolean isRequired() {
        return this._isRequired;
    }

    void setRequired(boolean isRequired) {
        this._isRequired = isRequired;
    }

    public String[] getOptionLabels() {
        if (this._labels == null || this._labels.size() == 0) {
            return null;
        }
        String[] returnedLabels = new String[this._labels.size()];
        Enumeration<String> labelKeys = this._labels.elements();
        int i = 0;
        while (labelKeys.hasMoreElements()) {
            String labelKey = labelKeys.nextElement();
            returnedLabels[i] = this.getLocalized(labelKey);
            ++i;
        }
        return returnedLabels;
    }

    public String[] getOptionValues() {
        if (this._values == null || this._values.size() == 0) {
            return null;
        }
        return this._values.toArray(new String[this._values.size()]);
    }

    void setOption(Vector<String> labels, Vector<String> values, boolean needValidation) {
        if (labels == null || values == null) {
            this.logger.log(1, NLS.bind((String)MetaTypeMsg.NULL_OPTIONS, (Object)this.getID()));
            return;
        }
        if (labels.size() != values.size()) {
            this.logger.log(1, NLS.bind((String)MetaTypeMsg.INCONSISTENT_OPTIONS, (Object)this.getID()));
            return;
        }
        this._labels = labels;
        this._values = values;
        if (needValidation) {
            int index = 0;
            while (index < this._values.size()) {
                ValueTokenizer vt = new ValueTokenizer(this._values.get(index), this.logger);
                this._values.set(index, vt.getValuesAsString());
                String reason = vt.validate(this);
                if (reason != null && reason.length() > 0) {
                    this.logger.log(2, NLS.bind((String)MetaTypeMsg.INVALID_OPTIONS, (Object[])new Object[]{this._values.get(index), this.getID(), reason}));
                    this._labels.remove(index);
                    this._values.remove(index);
                    --index;
                }
                ++index;
            }
        }
    }

    public String[] getDefaultValue() {
        return this._defaults;
    }

    void setDefaultValue(String defaults_str, boolean needValidation) {
        ValueTokenizer vt = new ValueTokenizer(defaults_str, this.logger);
        String reason = vt.validate(this);
        if (reason != null && reason.length() > 0) {
            this.logger.log(2, NLS.bind((String)MetaTypeMsg.INVALID_DEFAULTS, (Object[])new Object[]{vt.getValuesAsString(), this.getID(), reason}));
            return;
        }
        String[] defaults = vt.getValuesAsArray();
        if (this._cardinality != 0 && defaults.length == 1 && defaults[0].length() == 0) {
            this.setDefaultValue(new String[0]);
        } else {
            this.setDefaultValue(vt.getValuesAsArray());
        }
    }

    private void setDefaultValue(String[] defaults) {
        this._defaults = defaults;
    }

    void setMinValue(Object minValue) {
        this._minValue = minValue;
    }

    void setMaxValue(Object maxValue) {
        this._maxValue = maxValue;
    }

    public String validate(String value) {
        ValueTokenizer vt = new ValueTokenizer(value, this.logger);
        return vt.validate(this);
    }

    @Override
    public Map<String, String> getExtensionAttributes(String schema) {
        return this.helper.getExtensionAttributes(schema);
    }

    @Override
    public Set<String> getExtensionUris() {
        return this.helper.getExtensionUris();
    }

    @Override
    public String getMax() {
        return this._maxValue == null ? null : String.valueOf(this._maxValue);
    }

    @Override
    public String getMin() {
        return this._minValue == null ? null : String.valueOf(this._minValue);
    }
}

