/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.semanticTokens;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.lsp4e.internal.StyleUtil;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.SemanticTokensLegend;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.TextStyle;

public class SemanticTokensDataStreamProcessor {
    private final Function<Position, Integer> offsetMapper;
    private final Function<String, @Nullable IToken> tokenTypeMapper;

    public SemanticTokensDataStreamProcessor(Function<String, @Nullable IToken> tokenTypeMapper, Function<Position, Integer> offsetMapper) {
        this.tokenTypeMapper = tokenTypeMapper;
        this.offsetMapper = offsetMapper;
    }

    public List<StyleRange> getStyleRanges(List<Integer> dataStream, SemanticTokensLegend semanticTokensLegend) {
        ArrayList<StyleRange> styleRanges = new ArrayList<StyleRange>(dataStream.size() / 5);
        int idx = 0;
        int prevLine = 0;
        int line = 0;
        int offset = 0;
        int length = 0;
        String tokenType = null;
        for (Integer data : dataStream) {
            switch (idx % 5) {
                case 0: {
                    line += data.intValue();
                    break;
                }
                case 1: {
                    if (line == prevLine) {
                        offset += data.intValue();
                        break;
                    }
                    offset = this.offsetMapper.apply(new Position(line, data.intValue()));
                    break;
                }
                case 2: {
                    length = data;
                    break;
                }
                case 3: {
                    tokenType = this.tokenType(data, semanticTokensLegend.getTokenTypes());
                    break;
                }
                case 4: {
                    prevLine = line;
                    List<String> tokenModifiers = this.tokenModifiers(data, semanticTokensLegend.getTokenModifiers());
                    StyleRange styleRange = this.getStyleRange(offset, length, this.textAttribute(tokenType));
                    if (tokenModifiers.stream().anyMatch(x -> x.equals("deprecated"))) {
                        if (styleRange == null) {
                            styleRange = new StyleRange();
                            styleRange.start = offset;
                            styleRange.length = length;
                        }
                        StyleUtil.DEPRECATE.applyStyles((TextStyle)styleRange);
                    }
                    if (styleRange == null) break;
                    styleRanges.add(styleRange);
                }
            }
            ++idx;
        }
        return styleRanges;
    }

    private @Nullable String tokenType(Integer data, List<String> legend) {
        try {
            return legend.get(data);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    private List<String> tokenModifiers(Integer data, List<String> legend) {
        if (data == 0) {
            return Collections.emptyList();
        }
        BitSet bitSet = BitSet.valueOf(new long[]{data.intValue()});
        ArrayList<String> tokenModifiers = new ArrayList<String>();
        int i = bitSet.nextSetBit(0);
        while (i >= 0) {
            try {
                tokenModifiers.add(legend.get(i));
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            i = bitSet.nextSetBit(i + 1);
        }
        return tokenModifiers;
    }

    private @Nullable TextAttribute textAttribute(@Nullable String tokenType) {
        Object data;
        IToken token;
        if (tokenType != null && (token = this.tokenTypeMapper.apply(tokenType)) != null && (data = token.getData()) instanceof TextAttribute) {
            TextAttribute textAttribute = (TextAttribute)data;
            return textAttribute;
        }
        return null;
    }

    private @Nullable StyleRange getStyleRange(int offset, int length, @Nullable TextAttribute attr) {
        if (attr != null) {
            int style = attr.getStyle();
            int fontStyle = style & 3;
            StyleRange styleRange = new StyleRange(offset, length, attr.getForeground(), attr.getBackground(), fontStyle);
            styleRange.strikeout = (style & 0x20000000) != 0;
            styleRange.underline = (style & 0x40000000) != 0;
            styleRange.font = attr.getFont();
            return styleRange;
        }
        return null;
    }
}

