/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.app.framework;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.escet.common.app.framework.AppProperties;
import org.eclipse.escet.common.app.framework.Application;
import org.eclipse.escet.common.app.framework.SWTDisplayThread;
import org.eclipse.escet.common.app.framework.console.Console;
import org.eclipse.escet.common.app.framework.exceptions.DependencyException;
import org.eclipse.escet.common.app.framework.io.AppStreams;
import org.eclipse.escet.common.app.framework.management.AppManager;
import org.eclipse.escet.common.app.framework.management.AppStatus;
import org.eclipse.escet.common.app.framework.options.Options;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.java.Strings;

public class AppEnvData {
    private final Application<?> application;
    private final AppStreams streams;
    private final OutputProvider<?> provider;
    private final Options options;
    private final AppProperties properties;
    private AtomicBoolean terminationRequested = new AtomicBoolean(false);
    private Console console;
    private AtomicBoolean guiAvailable = new AtomicBoolean(false);
    private AtomicReference<SWTDisplayThread> swtThread = new AtomicReference();

    public AppEnvData(Application<?> application) {
        this(application, new AppStreams(), new OutputProvider(), new Options(), new AppProperties());
    }

    public AppEnvData(Application<?> application, AppStreams streams, OutputProvider<?> provider, Options options, AppProperties properties) {
        this.application = application;
        this.streams = streams;
        this.provider = provider;
        this.options = options;
        this.properties = properties;
    }

    public Application<?> getApplication() {
        return this.application;
    }

    public AppStreams getStreams() {
        return this.streams;
    }

    public OutputProvider<?> getProvider() {
        return this.provider;
    }

    public Options getOptions() {
        return this.options;
    }

    public AppProperties getProperties() {
        return this.properties;
    }

    public boolean isTerminationRequested() {
        return this.terminationRequested.get();
    }

    public synchronized void terminate() {
        boolean previouslyRequested = this.terminationRequested.getAndSet(true);
        if (!previouslyRequested) {
            AppManager.update(this.application, AppStatus.TERMINATING);
        }
    }

    public Console getConsole() {
        return this.console;
    }

    public void setConsole(Console console) {
        this.console = console;
    }

    public SWTDisplayThread getSwtDisplayThread() {
        return this.swtThread.get();
    }

    public void setSwtDisplayThread(SWTDisplayThread thread) {
        this.swtThread.set(thread);
    }

    public void setGuiAvailable(boolean available) {
        this.guiAvailable.set(available);
    }

    public boolean isGuiAvailable() {
        return this.guiAvailable.get();
    }

    public void checkGuiAvailable(String functionality) {
        if (this.isGuiAvailable()) {
            return;
        }
        String msg = Strings.fmt((String)"A GUI is required to %s. Enable the GUI (\"--gui=on\" command line option), and make sure to connect a display (e.g. on Linux enable X11 server/forwarding).", (Object[])new Object[]{functionality});
        throw new DependencyException(msg);
    }
}

