/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.compiler;

import java.util.List;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Component;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Edge;
import org.eclipse.escet.cif.metamodel.cif.automata.EdgeEvent;
import org.eclipse.escet.cif.metamodel.cif.automata.EdgeReceive;
import org.eclipse.escet.cif.metamodel.cif.automata.EdgeSend;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TauExpression;
import org.eclipse.escet.cif.simulator.compiler.AutomatonNormalCodeGenerator;
import org.eclipse.escet.cif.simulator.compiler.AutomatonSimpleCodeGenerator;
import org.eclipse.escet.cif.simulator.compiler.CifCompilerContext;
import org.eclipse.escet.common.java.Pair;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class AutomatonCodeGenerator {
    private AutomatonCodeGenerator() {
    }

    public static void gencodeAutomata(CifCompilerContext ctxt) {
        for (Automaton aut : ctxt.getAutomata()) {
            AutomatonCodeGenerator.gencodeAutomaton(aut, ctxt);
        }
    }

    private static void gencodeAutomaton(Automaton aut, CifCompilerContext ctxt) {
        if (AutomatonCodeGenerator.isSimpleAut(aut)) {
            AutomatonSimpleCodeGenerator.gencodeAutomaton(aut, ctxt);
        } else {
            AutomatonNormalCodeGenerator.gencodeAutomaton(aut, ctxt);
        }
    }

    private static boolean isSimpleAut(Automaton aut) {
        for (Location loc : aut.getLocations()) {
            for (Edge edge : loc.getEdges()) {
                if (!edge.getGuards().isEmpty()) {
                    return false;
                }
                if (!edge.getUpdates().isEmpty()) {
                    return false;
                }
                if (edge.getEvents().isEmpty()) {
                    return false;
                }
                for (EdgeEvent edgeEvent : edge.getEvents()) {
                    if (edgeEvent instanceof EdgeSend) {
                        return false;
                    }
                    if (edgeEvent instanceof EdgeReceive) {
                        return false;
                    }
                    Expression eventRef = edgeEvent.getEvent();
                    if (!(eventRef instanceof TauExpression)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static void collectAutomata(ComplexComponent comp, List<Pair<String, Automaton>> automata) {
        if (comp instanceof Automaton) {
            automata.add((Pair<String, Automaton>)Pair.pair((Object)CifTextUtils.getAbsName((PositionObject)comp, (boolean)false), (Object)((Automaton)comp)));
        } else {
            for (Component child : ((Group)comp).getComponents()) {
                AutomatonCodeGenerator.collectAutomata((ComplexComponent)child, automata);
            }
        }
    }
}

