/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.datasynth.spec;

import com.github.javabdd.BDD;
import com.github.javabdd.BDDFactory;
import org.eclipse.escet.cif.common.CifScopeUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.datasynth.bdd.BddUtils;
import org.eclipse.escet.cif.datasynth.spec.SynthesisAutomaton;
import org.eclipse.escet.cif.datasynth.spec.SynthesisDiscVariable;
import org.eclipse.escet.cif.datasynth.spec.SynthesisInputVariable;
import org.eclipse.escet.cif.datasynth.spec.SynthesisLocPtrVariable;
import org.eclipse.escet.cif.datasynth.spec.SynthesisVariable;
import org.eclipse.escet.cif.metamodel.cif.automata.Assignment;
import org.eclipse.escet.cif.metamodel.cif.automata.Edge;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.IntExpression;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class SynthesisEdge {
    public final SynthesisAutomaton aut;
    public Edge edge;
    public Event event;
    public BDD origGuard;
    public BDD guard;
    public BDD guardError;
    public Assignment[] assignments;
    public BDD update;
    public BDD updateGuard;
    public BDD updateGuardErrorNot;
    public BDD updateGuardRestricted;
    public BDD error;
    public BDD errorNot;

    public SynthesisEdge(SynthesisAutomaton aut) {
        this.aut = aut;
    }

    public void initApply(boolean doForward) {
        this.errorNot = this.error.not();
        Assert.check((this.update != null ? 1 : 0) != 0);
        Assert.check((this.updateGuard == null ? 1 : 0) != 0);
        this.updateGuard = this.update.and(this.guard);
        this.update.free();
        this.update = null;
        this.guardError = this.guard.and(this.error);
        Assert.check((this.updateGuardErrorNot == null ? 1 : 0) != 0);
        if (doForward) {
            this.updateGuardErrorNot = this.updateGuard.and(this.errorNot);
        }
    }

    public void preApply(boolean forward, BDD restriction) {
        Assert.check((this.updateGuard != null ? 1 : 0) != 0);
        Assert.check((this.updateGuardRestricted == null ? 1 : 0) != 0);
        if (forward) {
            if (restriction == null) {
                this.updateGuardRestricted = this.updateGuard.id();
            } else {
                BDD restrictionNew = restriction.replace(this.aut.oldToNewVarsPairing);
                this.updateGuardRestricted = this.updateGuardErrorNot.and(restrictionNew);
                restrictionNew.free();
            }
        }
    }

    public void postApply(boolean forward) {
        Assert.check((this.updateGuard != null ? 1 : 0) != 0);
        if (forward) {
            Assert.check((this.updateGuardRestricted != null ? 1 : 0) != 0);
            this.updateGuardRestricted.free();
            this.updateGuardRestricted = null;
        } else {
            Assert.check((this.updateGuardRestricted == null ? 1 : 0) != 0);
        }
    }

    public void cleanupApply() {
        Assert.check((this.update == null ? 1 : 0) != 0);
        if (this.errorNot != null) {
            this.errorNot.free();
            this.errorNot = null;
        }
        if (this.updateGuard != null) {
            this.updateGuard.free();
            this.updateGuard = null;
        }
        if (this.guardError != null) {
            this.guardError.free();
            this.guardError = null;
        }
        if (this.updateGuardErrorNot != null) {
            this.updateGuardErrorNot.free();
            this.updateGuardErrorNot = null;
        }
        Assert.check((this.updateGuardRestricted == null ? 1 : 0) != 0);
    }

    public BDD apply(BDD pred, boolean bad, boolean forward, BDD restriction) {
        if (forward) {
            Assert.check((!bad ? 1 : 0) != 0);
            BDD rslt = this.updateGuardRestricted.applyEx(pred, BDDFactory.and, this.aut.varSetOld);
            pred.free();
            if (this.aut.env.isTerminationRequested()) {
                return rslt;
            }
            BDD rsltOld = rslt.replaceWith(this.aut.newToOldVarsPairing);
            return rsltOld;
        }
        BDD predNew = pred.replaceWith(this.aut.oldToNewVarsPairing);
        if (this.aut.env.isTerminationRequested()) {
            return predNew;
        }
        BDD rslt = this.updateGuard.applyEx(predNew, BDDFactory.and, this.aut.varSetNew);
        predNew.free();
        if (this.aut.env.isTerminationRequested()) {
            return rslt;
        }
        rslt = bad ? rslt.orWith(this.guardError.id()) : rslt.andWith(this.errorNot.id());
        if (restriction != null) {
            rslt = rslt.andWith(restriction.id());
        }
        return rslt;
    }

    public String toString() {
        return this.toString(0, "Edge: ");
    }

    public String toString(int indent, String prefix) {
        StringBuilder txt = new StringBuilder();
        txt.append(Strings.duplicate((String)" ", (int)(2 * indent)));
        txt.append(prefix);
        txt.append(Strings.fmt((String)"(event: %s)", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)this.event)}));
        String origGuardTxt = BddUtils.bddToStr(this.origGuard, this.aut);
        String guardTxt = BddUtils.bddToStr(this.guard, this.aut);
        String guardsTxt = this.origGuard.equals(this.guard) ? Strings.fmt((String)"%s", (Object[])new Object[]{guardTxt}) : Strings.fmt((String)"%s -> %s", (Object[])new Object[]{origGuardTxt, guardTxt});
        txt.append(Strings.fmt((String)" (guard: %s)", (Object[])new Object[]{guardsTxt}));
        if (this.assignments.length > 0) {
            txt.append(" (assignments: ");
            int i = 0;
            while (i < this.assignments.length) {
                if (i > 0) {
                    txt.append(", ");
                }
                Assignment asgn = this.assignments[i];
                txt.append(this.assignmentToString(asgn));
                ++i;
            }
            txt.append(")");
        }
        return txt.toString();
    }

    private Object assignmentToString(Assignment asgn) {
        Expression addr = asgn.getAddressable();
        Declaration addrVar = (Declaration)CifScopeUtils.getRefObjFromRef((Expression)addr);
        Expression rhs = asgn.getValue();
        SynthesisVariable[] synthesisVariableArray = this.aut.variables;
        int n = this.aut.variables.length;
        int n2 = 0;
        while (n2 < n) {
            SynthesisVariable var = synthesisVariableArray[n2];
            if (var != null) {
                if (var instanceof SynthesisDiscVariable) {
                    SynthesisDiscVariable synthDiscVar = (SynthesisDiscVariable)var;
                    if (synthDiscVar.var == addrVar) {
                        return Strings.fmt((String)"%s := %s", (Object[])new Object[]{synthDiscVar.name, CifTextUtils.exprToStr((Expression)rhs)});
                    }
                } else if (var instanceof SynthesisLocPtrVariable) {
                    SynthesisLocPtrVariable synthLpVar = (SynthesisLocPtrVariable)var;
                    if (synthLpVar.var == addrVar) {
                        int locIdx = ((IntExpression)rhs).getValue();
                        Location loc = (Location)synthLpVar.aut.getLocations().get(locIdx);
                        return Strings.fmt((String)"%s := %s", (Object[])new Object[]{synthLpVar.name, CifTextUtils.getAbsName((PositionObject)loc)});
                    }
                } else if (var instanceof SynthesisInputVariable) {
                    SynthesisInputVariable synthInputVar = (SynthesisInputVariable)var;
                    if (synthInputVar.var == addrVar) {
                        return Strings.fmt((String)"%s+ != %s", (Object[])new Object[]{synthInputVar.name, synthInputVar.name});
                    }
                } else {
                    String msg = "Unexpected synthesis variable for addressable: " + var;
                    throw new RuntimeException(msg);
                }
            }
            ++n2;
        }
        throw new RuntimeException("No synthesis variable found for addressable: " + addrVar);
    }
}

