/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2uppaal;

import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.common.CifEvalException;
import org.eclipse.escet.cif.common.CifEvalUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.common.CifValueUtils;
import org.eclipse.escet.cif.common.RangeCompat;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Invariant;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.automata.Assignment;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Edge;
import org.eclipse.escet.cif.metamodel.cif.automata.IfUpdate;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.declarations.AlgVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.ContVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumDecl;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.declarations.InputVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.VariableValue;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryOperator;
import org.eclipse.escet.cif.metamodel.cif.expressions.CastExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DictExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FunctionCallExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ListExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ProjectionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.RealExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SetExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SliceExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.StringExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SwitchExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TimeExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TupleExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.UnaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.UnaryOperator;
import org.eclipse.escet.cif.metamodel.cif.functions.Function;
import org.eclipse.escet.cif.metamodel.cif.types.BoolType;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.DictType;
import org.eclipse.escet.cif.metamodel.cif.types.DistType;
import org.eclipse.escet.cif.metamodel.cif.types.EnumType;
import org.eclipse.escet.cif.metamodel.cif.types.FuncType;
import org.eclipse.escet.cif.metamodel.cif.types.IntType;
import org.eclipse.escet.cif.metamodel.cif.types.ListType;
import org.eclipse.escet.cif.metamodel.cif.types.RealType;
import org.eclipse.escet.cif.metamodel.cif.types.SetType;
import org.eclipse.escet.cif.metamodel.cif.types.StringType;
import org.eclipse.escet.cif.metamodel.cif.types.TupleType;
import org.eclipse.escet.cif.metamodel.java.CifWalker;
import org.eclipse.escet.common.app.framework.exceptions.UnsupportedException;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class CifToUppaalPreChecker
extends CifWalker {
    private final List<String> problems = Lists.list();
    private int initLocCount;
    private int autCount;

    public void check(Specification spec) {
        this.walkSpecification(spec);
        Collections.sort(this.problems, Strings.SORTER);
        if (!this.problems.isEmpty()) {
            String msg = "CIF to UPPAAL transformation failed due to unsatisfied preconditions:\n - " + StringUtils.join(this.problems, (String)"\n - ");
            throw new UnsupportedException(msg);
        }
    }

    protected void preprocessSpecification(Specification spec) {
        this.autCount = 0;
    }

    protected void postprocessSpecification(Specification spec) {
        if (this.autCount == 0) {
            String msg = "Specifications without automata are currently not supported.";
            this.problems.add(msg);
        }
    }

    protected void postprocessInvariant(Invariant inv) {
        switch (inv.getInvKind()) {
            case EVENT_NEEDS: 
            case EVENT_DISABLES: {
                EObject parent = inv.eContainer();
                String parentTxt = parent instanceof Location ? CifTextUtils.getLocationText1((Location)((Location)parent)) : CifTextUtils.getComponentText1((ComplexComponent)((ComplexComponent)parent));
                String msg = Strings.fmt((String)"Unsupported %s: state/event exclusion invariants are currently not supported.", (Object[])new Object[]{parentTxt});
                this.problems.add(msg);
                break;
            }
        }
    }

    protected void preprocessEvent(Event event) {
        if (event.getType() != null) {
            String msg = Strings.fmt((String)"Unsupported event \"%s\": event is a channel (has a data type).", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)event)});
            this.problems.add(msg);
        }
    }

    protected void preprocessComplexComponent(ComplexComponent comp) {
        if (!comp.getInitials().isEmpty()) {
            String msg = Strings.fmt((String)"Unsupported %s: initialization predicates in components are currently not supported.", (Object[])new Object[]{CifTextUtils.getComponentText1((ComplexComponent)comp)});
            this.problems.add(msg);
        }
    }

    protected void preprocessAutomaton(Automaton aut) {
        ++this.autCount;
        this.initLocCount = 0;
    }

    protected void postprocessAutomaton(Automaton aut) {
        String msg;
        if (this.initLocCount == 0) {
            msg = Strings.fmt((String)"Unsupported automaton \"%s\": automata without an initial location are currently not supported.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)aut)});
            this.problems.add(msg);
        }
        if (this.initLocCount > 1) {
            msg = Strings.fmt((String)"Unsupported automaton \"%s\": automata with multiple (%d) initial locations are currently not supported.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)aut), this.initLocCount});
            this.problems.add(msg);
        }
    }

    protected void preprocessDiscVariable(DiscVariable var) {
        EObject parent = var.eContainer();
        if (!(parent instanceof ComplexComponent)) {
            return;
        }
        VariableValue values = var.getValue();
        if (values != null && values.getValues().size() != 1) {
            String msg = Strings.fmt((String)"Unsupported declaration \"%s\": discrete variables with multiple potential initial values are currently supported.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)var)});
            this.problems.add(msg);
        }
        if (values != null && values.getValues().size() == 1) {
            Expression value = (Expression)values.getValues().get(0);
            if (!CifValueUtils.hasSingleValue((Expression)value, (boolean)true, (boolean)true)) {
                String msg = Strings.fmt((String)"Unsupported declaration \"%s\": initial value \"%s\" of the discrete variable is too complex to evaluate statically.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)var), CifTextUtils.exprToStr((Expression)value)});
                this.problems.add(msg);
            } else {
                try {
                    CifEvalUtils.eval((Expression)value, (boolean)true);
                }
                catch (CifEvalException e) {
                    String msg = Strings.fmt((String)"Unsupported declaration \"%s\": evaluation of the initial value \"%s\" of the discrete variable failed.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)var), CifTextUtils.exprToStr((Expression)value)});
                    this.problems.add(msg);
                }
            }
        }
    }

    protected void preprocessEnumDecl(EnumDecl enumDecl) {
        String msg = Strings.fmt((String)"Unsupported declaration \"%s\": enumerations are currently not supported.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)enumDecl)});
        this.problems.add(msg);
    }

    protected void preprocessContVariable(ContVariable var) {
        String msg = Strings.fmt((String)"Unsupported declaration \"%s\": continuous variables are currently not supported.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)var)});
        this.problems.add(msg);
    }

    protected void preprocessAlgVariable(AlgVariable var) {
        String msg = Strings.fmt((String)"Unsupported declaration \"%s\": algebraic variables are currently not supported.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)var)});
        this.problems.add(msg);
    }

    protected void preprocessInputVariable(InputVariable var) {
        String msg = Strings.fmt((String)"Unsupported declaration \"%s\": input variables are currently not supported.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)var)});
        this.problems.add(msg);
    }

    protected void preprocessFunction(Function func) {
        String msg = Strings.fmt((String)"Unsupported declaration \"%s\": user-defined functions are currently not supported.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)func)});
        this.problems.add(msg);
    }

    protected void preprocessLocation(Location loc) {
        EList initials = loc.getInitials();
        boolean initial = false;
        try {
            initial = initials.isEmpty() ? false : CifEvalUtils.evalPreds((List)loc.getInitials(), (boolean)true, (boolean)true);
        }
        catch (UnsupportedException e) {
            String msg = Strings.fmt((String)"Initialization predicates \"%s\" of %s are too complex to evaluate statically.", (Object[])new Object[]{CifTextUtils.exprsToStr((List)initials), CifTextUtils.getLocationText2((Location)loc)});
            this.problems.add(msg);
            this.initLocCount = -1;
        }
        catch (CifEvalException e) {
            String msg = Strings.fmt((String)"Evaluation of the initialization predicates \"%s\" of %s failed.", (Object[])new Object[]{CifTextUtils.exprsToStr((List)initials), CifTextUtils.getLocationText2((Location)loc)});
            this.problems.add(msg);
            this.initLocCount = -1;
        }
        if (initial && this.initLocCount != -1) {
            ++this.initLocCount;
        }
    }

    protected void preprocessEdge(Edge edge) {
        if (edge.isUrgent()) {
            Location loc = (Location)edge.eContainer();
            String msg = Strings.fmt((String)"Unsupported %s: urgent edges are currently not supported.", (Object[])new Object[]{CifTextUtils.getLocationText1((Location)loc)});
            this.problems.add(msg);
        }
    }

    protected void preprocessAssignment(Assignment asgn) {
        if (asgn.getAddressable() instanceof TupleExpression || asgn.getAddressable() instanceof ProjectionExpression) {
            Assignment ancestor = asgn;
            while (!(ancestor instanceof Location)) {
                ancestor = ancestor.eContainer();
            }
            Assert.check((boolean)(ancestor instanceof Location));
            Location loc = (Location)ancestor;
            String problem = null;
            if (asgn.getAddressable() instanceof TupleExpression) {
                problem = "multi-assignments";
            } else if (asgn.getAddressable() instanceof ProjectionExpression) {
                problem = "partial variable assignments";
            }
            Assert.notNull((Object)problem);
            String msg = Strings.fmt((String)"Unsupported %s: edges with %s are currently not supported.", (Object[])new Object[]{CifTextUtils.getLocationText1((Location)loc), problem});
            this.problems.add(msg);
        }
    }

    protected void preprocessIfUpdate(IfUpdate update) {
        IfUpdate loc = update;
        while (!(loc instanceof Location)) {
            loc = loc.eContainer();
        }
        Assert.check((boolean)(loc instanceof Location));
        String msg = Strings.fmt((String)"Unsupported %s: edges with conditional updates ('if' updates) are currently not supported.", (Object[])new Object[]{CifTextUtils.getLocationText1((Location)((Location)loc))});
        this.problems.add(msg);
    }

    protected void preprocessEnumType(EnumType type) {
        String msg = Strings.fmt((String)"Unsupported type \"%s\": enumeration types are currently not supported.", (Object[])new Object[]{CifTextUtils.typeToStr((CifType)type)});
        this.problems.add(msg);
    }

    protected void preprocessRealType(RealType type) {
        String msg = Strings.fmt((String)"Unsupported type \"%s\": real types are currently not supported.", (Object[])new Object[]{CifTextUtils.typeToStr((CifType)type)});
        this.problems.add(msg);
    }

    protected void preprocessStringType(StringType type) {
        String msg = Strings.fmt((String)"Unsupported type \"%s\": string types are currently not supported.", (Object[])new Object[]{CifTextUtils.typeToStr((CifType)type)});
        this.problems.add(msg);
    }

    protected void preprocessListType(ListType type) {
        String msg = Strings.fmt((String)"Unsupported type \"%s\": list types are currently not supported.", (Object[])new Object[]{CifTextUtils.typeToStr((CifType)type)});
        this.problems.add(msg);
    }

    protected void preprocessSetType(SetType type) {
        String msg = Strings.fmt((String)"Unsupported type \"%s\": set types are currently not supported.", (Object[])new Object[]{CifTextUtils.typeToStr((CifType)type)});
        this.problems.add(msg);
    }

    protected void preprocessFuncType(FuncType type) {
        String msg = Strings.fmt((String)"Unsupported type \"%s\": function types are currently not supported.", (Object[])new Object[]{CifTextUtils.typeToStr((CifType)type)});
        this.problems.add(msg);
    }

    protected void preprocessDictType(DictType type) {
        String msg = Strings.fmt((String)"Unsupported type \"%s\": dictionary types are currently not supported.", (Object[])new Object[]{CifTextUtils.typeToStr((CifType)type)});
        this.problems.add(msg);
    }

    protected void preprocessTupleType(TupleType type) {
        String msg = Strings.fmt((String)"Unsupported type \"%s\": tuple types are currently not supported.", (Object[])new Object[]{CifTextUtils.typeToStr((CifType)type)});
        this.problems.add(msg);
    }

    protected void preprocessDistType(DistType type) {
        String msg = Strings.fmt((String)"Unsupported type \"%s\": distribution types are currently not supported.", (Object[])new Object[]{CifTextUtils.typeToStr((CifType)type)});
        this.problems.add(msg);
    }

    protected void preprocessRealExpression(RealExpression expr) {
        String msg = Strings.fmt((String)"Unsupported expression \"%s\": real number expressions are currently not supported.", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)expr)});
        this.problems.add(msg);
    }

    protected void preprocessStringExpression(StringExpression expr) {
        String msg = Strings.fmt((String)"Unsupported expression \"%s\": string literal expressions are currently not supported.", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)expr)});
        this.problems.add(msg);
    }

    protected void preprocessTimeExpression(TimeExpression expr) {
        String msg = Strings.fmt((String)"Unsupported expression \"%s\": the use of variable \"time\" is currently not supported.", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)expr)});
        this.problems.add(msg);
    }

    protected void preprocessCastExpression(CastExpression expr) {
        CifType rtype;
        CifType ctype = expr.getChild().getType();
        if (CifTypeUtils.checkTypeCompat((CifType)ctype, (CifType)(rtype = expr.getType()), (RangeCompat)RangeCompat.EQUAL)) {
            return;
        }
        String msg = Strings.fmt((String)"Unsupported expression \"%s\": cast expressions are currently not supported.", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)expr)});
        this.problems.add(msg);
    }

    protected void preprocessUnaryExpression(UnaryExpression expr) {
        UnaryOperator op = expr.getOperator();
        switch (op) {
            case INVERSE: {
                return;
            }
            case NEGATE: 
            case PLUS: {
                CifType ctype = CifTypeUtils.normalizeType((CifType)expr.getChild().getType());
                if (!(ctype instanceof IntType)) break;
                return;
            }
            case SAMPLE: {
                break;
            }
            default: {
                throw new RuntimeException("Unknown un op: " + op);
            }
        }
        String msg = Strings.fmt((String)"Unsupported expression \"%s\": unary operator \"%s\" is currently not supported, or is not supported for the operand that is used.", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)expr), CifTextUtils.operatorToStr((UnaryOperator)op)});
        this.problems.add(msg);
    }

    protected void preprocessBinaryExpression(BinaryExpression expr) {
        BinaryOperator op = expr.getOperator();
        switch (op) {
            case IMPLICATION: 
            case BI_CONDITIONAL: {
                return;
            }
            case DISJUNCTION: 
            case CONJUNCTION: {
                CifType ltype = CifTypeUtils.normalizeType((CifType)expr.getLeft().getType());
                CifType rtype = CifTypeUtils.normalizeType((CifType)expr.getRight().getType());
                if (!(ltype instanceof BoolType) || !(rtype instanceof BoolType)) break;
                return;
            }
            case LESS_THAN: 
            case LESS_EQUAL: 
            case GREATER_THAN: 
            case GREATER_EQUAL: 
            case EQUAL: 
            case UNEQUAL: 
            case MULTIPLICATION: 
            case SUBTRACTION: 
            case ADDITION: {
                CifType ltype = CifTypeUtils.normalizeType((CifType)expr.getLeft().getType());
                CifType rtype = CifTypeUtils.normalizeType((CifType)expr.getRight().getType());
                if (!(ltype instanceof IntType) || !(rtype instanceof IntType)) break;
                return;
            }
            case MODULUS: 
            case INTEGER_DIVISION: {
                return;
            }
            case SUBSET: 
            case ELEMENT_OF: 
            case DIVISION: {
                break;
            }
            default: {
                throw new RuntimeException("Unknown bin op: " + op);
            }
        }
        String msg = Strings.fmt((String)"Unsupported expression \"%s\": binary operator \"%s\" is currently not supported, or is not supported for the operands that are used.", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)expr), CifTextUtils.operatorToStr((BinaryOperator)op)});
        this.problems.add(msg);
    }

    protected void preprocessProjectionExpression(ProjectionExpression expr) {
        String msg = Strings.fmt((String)"Unsupported expression \"%s\": projection expressions are currently not supported.", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)expr)});
        this.problems.add(msg);
    }

    protected void preprocessSliceExpression(SliceExpression expr) {
        String msg = Strings.fmt((String)"Unsupported expression \"%s\": slice expressions are currently not supported.", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)expr)});
        this.problems.add(msg);
    }

    protected void preprocessFunctionCallExpression(FunctionCallExpression expr) {
        String msg = Strings.fmt((String)"Unsupported expression \"%s\": function calls are currently not supported.", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)expr)});
        this.problems.add(msg);
    }

    protected void preprocessListExpression(ListExpression expr) {
        String msg = Strings.fmt((String)"Unsupported expression \"%s\": list expressions are currently not supported.", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)expr)});
        this.problems.add(msg);
    }

    protected void preprocessSetExpression(SetExpression expr) {
        String msg = Strings.fmt((String)"Unsupported expression \"%s\": set expressions are currently not supported.", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)expr)});
        this.problems.add(msg);
    }

    protected void preprocessTupleExpression(TupleExpression expr) {
        String msg = Strings.fmt((String)"Unsupported expression \"%s\": tuple expressions are currently not supported.", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)expr)});
        this.problems.add(msg);
    }

    protected void preprocessDictExpression(DictExpression expr) {
        String msg = Strings.fmt((String)"Unsupported expression \"%s\": dictionary expressions are currently not supported.", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)expr)});
        this.problems.add(msg);
    }

    protected void preprocessSwitchExpression(SwitchExpression expr) {
        String msg = Strings.fmt((String)"Unsupported expression \"%s\": 'switch' expressions are currently not supported.", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)expr)});
        this.problems.add(msg);
    }
}

