/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.output.stateviz;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.eclipse.escet.cif.simulator.runtime.meta.RuntimeStateFilterer;
import org.eclipse.escet.cif.simulator.runtime.meta.RuntimeStateObjectMeta;
import org.eclipse.escet.cif.simulator.runtime.meta.StateObjectType;
import org.eclipse.escet.cif.simulator.runtime.model.RuntimeState;
import org.eclipse.escet.common.eclipse.ui.ControlEditor;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class StateVisualizer
extends ControlEditor {
    public String filtersTxt;
    private Table table;
    private List<RuntimeStateObjectMeta> metas;
    private Map<StateObjectType, Image> iconMap = Maps.map();

    protected Control createContents(Composite parent) {
        Image iconAut = StateVisualizer.loadIcon((Widget)parent, "aut");
        Image iconDiscVar = StateVisualizer.loadIcon((Widget)parent, "discvar");
        Image iconContVar = StateVisualizer.loadIcon((Widget)parent, "contvar");
        Image iconDeriv = StateVisualizer.loadIcon((Widget)parent, "deriv");
        Image iconAlgVar = StateVisualizer.loadIcon((Widget)parent, "algvar");
        this.iconMap.put(StateObjectType.AUTOMATON, iconAut);
        this.iconMap.put(StateObjectType.TIME, iconContVar);
        this.iconMap.put(StateObjectType.DISCRETE, iconDiscVar);
        this.iconMap.put(StateObjectType.CONTINUOUS, iconContVar);
        this.iconMap.put(StateObjectType.DERIVATIVE, iconDeriv);
        this.iconMap.put(StateObjectType.ALGEBRAIC, iconAlgVar);
        this.table = new Table(parent, 68352);
        FormData tableData = new FormData();
        tableData.left = new FormAttachment(0, 0);
        tableData.right = new FormAttachment(100, 0);
        tableData.top = new FormAttachment(0, 0);
        tableData.bottom = new FormAttachment(100, 0);
        this.table.setLayoutData((Object)tableData);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        TableColumn column1 = new TableColumn(this.table, 0);
        TableColumn column2 = new TableColumn(this.table, 0);
        column1.setText("Name");
        column2.setText("Value");
        column1.setResizable(false);
        column2.setResizable(false);
        return this.table;
    }

    public void initMeta(RuntimeState state) {
        this.metas = state.spec.stateObjectsMeta;
        this.metas = RuntimeStateFilterer.filter(this.metas, this.filtersTxt, "State visualizer", "shown in the state visualizer");
        this.filtersTxt = null;
    }

    public void initTable(RuntimeState state) {
        for (RuntimeStateObjectMeta meta : this.metas) {
            TableItem item = new TableItem(this.table, 0);
            item.setText(meta.name);
            item.setImage(this.iconMap.get((Object)meta.type));
        }
        int i = 0;
        while (i < this.table.getColumnCount()) {
            this.table.getColumn(i).pack();
            ++i;
        }
        int w = this.table.getColumn(0).getWidth();
        this.table.getColumn(0).setWidth(w += 8);
    }

    public void update(RuntimeState state) {
        int i = 0;
        while (i < this.metas.size()) {
            RuntimeStateObjectMeta meta = this.metas.get(i);
            String text = state.getStateObjValueText(meta);
            this.table.getItem(i).setText(1, text);
            ++i;
        }
        this.table.getColumn(1).pack();
    }

    private static Image loadIcon(Widget widget, String name) {
        name = Strings.fmt((String)"icon_%s.png", (Object[])new Object[]{name});
        InputStream stream = StateVisualizer.class.getResourceAsStream(name);
        Assert.notNull((Object)stream);
        try {
            Image image = new Image((Device)widget.getDisplay(), stream);
            return image;
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void dispose() {
        super.dispose();
        for (Image icon : this.iconMap.values()) {
            icon.dispose();
        }
        this.iconMap.clear();
    }
}

