/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.typechecker;

import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.print.Print;
import org.eclipse.escet.cif.metamodel.cif.print.PrintFile;
import org.eclipse.escet.cif.metamodel.cif.print.PrintFor;
import org.eclipse.escet.cif.metamodel.cif.print.PrintForKind;
import org.eclipse.escet.cif.metamodel.cif.types.BoolType;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.java.CifConstructors;
import org.eclipse.escet.cif.parser.ast.iodecls.print.APrint;
import org.eclipse.escet.cif.parser.ast.iodecls.print.APrintFile;
import org.eclipse.escet.cif.parser.ast.iodecls.print.APrintFor;
import org.eclipse.escet.cif.parser.ast.tokens.AName;
import org.eclipse.escet.cif.typechecker.CifEventRefTypeChecker;
import org.eclipse.escet.cif.typechecker.CifExprsTypeChecker;
import org.eclipse.escet.cif.typechecker.CifTypeChecker;
import org.eclipse.escet.cif.typechecker.ErrMsg;
import org.eclipse.escet.cif.typechecker.scopes.ParentScope;
import org.eclipse.escet.common.typechecker.SemanticException;

public class CifPrintTypeChecker {
    private final CifTypeChecker tchecker;

    public CifPrintTypeChecker(CifTypeChecker tchecker) {
        this.tchecker = tchecker;
    }

    public PrintFile checkPrintFile(APrintFile astPrintFile) {
        PrintFile printFile = CifConstructors.newPrintFile();
        printFile.setPath(astPrintFile.path.txt);
        printFile.setPosition(astPrintFile.position);
        return printFile;
    }

    public Print checkPrint(APrint astPrint, ParentScope<?> scope) {
        CifType nt;
        CifType t;
        Expression post;
        Expression pre;
        Print print = CifConstructors.newPrint();
        print.setPosition(astPrint.position);
        if (astPrint.txt.pre != null) {
            pre = CifExprsTypeChecker.transExpression(astPrint.txt.pre, CifExprsTypeChecker.NO_TYPE_HINT, scope, null, this.tchecker);
            print.setTxtPre(pre);
            if (CifTypeUtils.hasComponentLikeType((CifType)pre.getType())) {
                this.tchecker.addProblem(ErrMsg.PRINT_TXT_COMP_TYPE, astPrint.txt.pre.position, "pre", CifTextUtils.typeToStr((CifType)pre.getType()));
                throw new SemanticException();
            }
        }
        if (astPrint.txt.post != null) {
            post = CifExprsTypeChecker.transExpression(astPrint.txt.post, CifExprsTypeChecker.NO_TYPE_HINT, scope, null, this.tchecker);
            print.setTxtPost(post);
            if (CifTypeUtils.hasComponentLikeType((CifType)post.getType())) {
                this.tchecker.addProblem(ErrMsg.PRINT_TXT_COMP_TYPE, astPrint.txt.post.position, "post", CifTextUtils.typeToStr((CifType)post.getType()));
                throw new SemanticException();
            }
        }
        for (APrintFor astPrintFor : astPrint.fors) {
            PrintFor printFor = this.checkPrintFor(astPrintFor, scope);
            print.getFors().add((Object)printFor);
        }
        if (astPrint.when != null && astPrint.when.pre != null) {
            pre = CifExprsTypeChecker.transExpression(astPrint.when.pre, (CifType)CifExprsTypeChecker.BOOL_TYPE_HINT, scope, null, this.tchecker);
            print.setWhenPre(pre);
            t = pre.getType();
            nt = CifTypeUtils.normalizeType((CifType)t);
            if (!(nt instanceof BoolType)) {
                this.tchecker.addProblem(ErrMsg.PRINT_WHEN_NON_BOOL, pre.getPosition(), "pre", CifTextUtils.typeToStr((CifType)t));
            }
        }
        if (astPrint.when != null && astPrint.when.post != null) {
            post = CifExprsTypeChecker.transExpression(astPrint.when.post, (CifType)CifExprsTypeChecker.BOOL_TYPE_HINT, scope, null, this.tchecker);
            print.setWhenPost(post);
            t = post.getType();
            nt = CifTypeUtils.normalizeType((CifType)t);
            if (!(nt instanceof BoolType)) {
                this.tchecker.addProblem(ErrMsg.PRINT_WHEN_NON_BOOL, post.getPosition(), "post", CifTextUtils.typeToStr((CifType)t));
            }
        }
        if (astPrint.file != null) {
            PrintFile printFile = CifConstructors.newPrintFile();
            printFile.setPath(astPrint.file.path.txt);
            printFile.setPosition(astPrint.file.path.position);
            print.setFile(printFile);
        }
        return print;
    }

    public PrintFor checkPrintFor(APrintFor astPrintFor, ParentScope<?> scope) {
        PrintFor printFor = CifConstructors.newPrintFor();
        printFor.setPosition(astPrintFor.position);
        printFor.setKind(Enum.valueOf(PrintForKind.class, astPrintFor.kind.name()));
        if (astPrintFor.name != null) {
            AName name = new AName(astPrintFor.name, astPrintFor.position);
            Expression eventRef = CifEventRefTypeChecker.checkEventRef(name, scope, this.tchecker);
            printFor.setEvent(eventRef);
        }
        return printFor;
    }
}

