/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.typechecker.declwrap;

import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.metamodel.cif.declarations.TypeDecl;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.parser.ast.declarations.ATypeDef;
import org.eclipse.escet.cif.typechecker.CheckStatus;
import org.eclipse.escet.cif.typechecker.CifTypeChecker;
import org.eclipse.escet.cif.typechecker.CifTypesTypeChecker;
import org.eclipse.escet.cif.typechecker.ErrMsg;
import org.eclipse.escet.cif.typechecker.declwrap.DeclWrap;
import org.eclipse.escet.cif.typechecker.scopes.ParentScope;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;
import org.eclipse.escet.common.typechecker.SemanticException;

public class TypeDeclWrap
extends DeclWrap<TypeDecl> {
    private final ATypeDef astDecl;

    public TypeDeclWrap(CifTypeChecker tchecker, ParentScope<?> scope, ATypeDef astDecl, TypeDecl mmDecl) {
        super(tchecker, scope, mmDecl);
        this.astDecl = astDecl;
    }

    @Override
    public String getName() {
        return ((TypeDecl)this.mmDecl).getName();
    }

    @Override
    public String getAbsName() {
        return CifTextUtils.getAbsName((PositionObject)this.mmDecl);
    }

    @Override
    public void tcheckForUseImpl() {
        this.checkName();
        this.tchecker.addToCycle(this);
        try {
            CifType type = CifTypesTypeChecker.transCifType(this.astDecl.type, this.scope, this.tchecker);
            if (CifTypeUtils.hasComponentLikeType((CifType)type)) {
                this.tchecker.addProblem(ErrMsg.DECL_INVALID_TYPE, type.getPosition(), "Type declaration", this.getAbsName(), CifTextUtils.typeToStr((CifType)type));
                throw new SemanticException();
            }
            ((TypeDecl)this.mmDecl).setType(type);
        }
        finally {
            this.tchecker.removeFromCycle(this);
        }
        this.status = CheckStatus.FULL;
    }

    @Override
    public void tcheckFull() {
        this.tcheckForUse();
    }
}

