/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.setext.texteditorbase.commands;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.setext.texteditorbase.GenericTextEditor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class CommentHandlerBase
extends AbstractHandler {
    protected String getCommandName(ExecutionEvent event) {
        Command command = event.getCommand();
        try {
            return command.getName();
        }
        catch (NotDefinedException e) {
            throw new RuntimeException(e);
        }
    }

    protected GenericTextEditor<?, ?> getTextEditor(ExecutionEvent event) {
        IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
        Assert.notNull((Object)part);
        Assert.check((part.getAdapter(TextEditor.class) != null ? 1 : 0) != 0);
        GenericTextEditor editor = null;
        if (part instanceof GenericTextEditor) {
            editor = (GenericTextEditor)part;
        } else {
            Object obj = part.getAdapter(GenericTextEditor.class);
            editor = (GenericTextEditor)((Object)obj);
        }
        if (editor == null) {
            String name = CommentHandlerBase.getEditorName(event);
            String msg = Strings.fmt((String)"The active %stext editor is not supported by the \"%s\" command.", (Object[])new Object[]{name == null ? "" : Strings.fmt((String)"\"%s\" ", (Object[])new Object[]{name}), this.getCommandName(event)});
            String title = String.valueOf(this.getCommandName(event)) + " Command Error";
            MessageDialog.openError((Shell)part.getSite().getShell(), (String)title, (String)msg);
            return null;
        }
        return editor;
    }

    protected String getCommentChars(ExecutionEvent event, GenericTextEditor<?, ?> editor) {
        String chars = editor.singleLineCommentChars;
        if (chars == null) {
            IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
            Assert.notNull((Object)part);
            String name = CommentHandlerBase.getEditorName(event);
            String msg = Strings.fmt((String)"The active %stext editor does not support single line comments.", (Object[])new Object[]{name == null ? "" : Strings.fmt((String)"\"%s\" ", (Object[])new Object[]{name})});
            String title = String.valueOf(this.getCommandName(event)) + " Command Error";
            MessageDialog.openError((Shell)part.getSite().getShell(), (String)title, (String)msg);
            return null;
        }
        return chars;
    }

    protected IDocument getDocument(ExecutionEvent event, GenericTextEditor<?, ?> editor) {
        IEditorInput input = HandlerUtil.getActiveEditorInput((ExecutionEvent)event);
        Assert.notNull((Object)input);
        IDocument doc = editor.getDocumentProvider().getDocument((Object)input);
        Assert.notNull((Object)doc);
        return doc;
    }

    protected ITextSelection getSelection(GenericTextEditor<?, ?> editor) {
        ISelection selection = editor.getSelectionProvider().getSelection();
        Assert.check((boolean)(selection instanceof ITextSelection));
        return (ITextSelection)selection;
    }

    protected int getStartLine(ExecutionEvent event, ITextSelection selection) {
        int startLine = selection.getStartLine();
        if (startLine < 0) {
            IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
            String title = String.valueOf(this.getCommandName(event)) + " Command Error";
            MessageDialog.openError((Shell)part.getSite().getShell(), (String)title, (String)"Failed to obtain selection start line.");
        }
        return startLine;
    }

    protected int getEndLine(ExecutionEvent event, ITextSelection selection) {
        int endLine = selection.getEndLine();
        if (endLine < 0) {
            IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
            String title = String.valueOf(this.getCommandName(event)) + " Command Error";
            MessageDialog.openError((Shell)part.getSite().getShell(), (String)title, (String)"Failed to obtain selection end line.");
        }
        return endLine;
    }

    private static String getEditorName(ExecutionEvent event) {
        IWorkbenchSite site = HandlerUtil.getActiveSite((ExecutionEvent)event);
        if (site != null && site instanceof IWorkbenchPartSite) {
            return ((IWorkbenchPartSite)site).getRegisteredName();
        }
        return null;
    }
}

