/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.elk.alg.layered.ILayoutProcessor;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.properties.InternalProperties;
import org.eclipse.elk.alg.layered.properties.LayeredOptions;
import org.eclipse.elk.core.options.PortConstraints;
import org.eclipse.elk.core.options.PortSide;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public final class NorthSouthPortPreprocessor
implements ILayoutProcessor {
    private static final boolean USE_NEW_APPROACH = true;

    @Override
    public void process(LGraph layeredGraph, IElkProgressMonitor monitor) {
        monitor.begin("Odd port side processing", 1.0f);
        ArrayList northDummyNodes = Lists.newArrayList();
        ArrayList southDummyNodes = Lists.newArrayList();
        for (Layer layer : layeredGraph) {
            LNode[] nodeArray;
            int pointer = -1;
            LNode[] lNodeArray = nodeArray = layer.getNodes().toArray(new LNode[layer.getNodes().size()]);
            int n = nodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                LNode node = lNodeArray[n2];
                ++pointer;
                if (node.getType() == LNode.NodeType.NORMAL && ((PortConstraints)node.getProperty(LayeredOptions.PORT_CONSTRAINTS)).isSideFixed()) {
                    if (!((PortConstraints)node.getProperty(LayeredOptions.PORT_CONSTRAINTS)).isOrderFixed()) {
                        this.sortPortList(node);
                    }
                    node.setProperty(InternalProperties.IN_LAYER_LAYOUT_UNIT, (Object)node);
                    northDummyNodes.clear();
                    southDummyNodes.clear();
                    ArrayList barycenterAssociates = Lists.newArrayList();
                    LinkedList portList = Lists.newLinkedList();
                    Iterables.addAll((Collection)portList, node.getPorts(PortSide.NORTH));
                    this.createDummyNodes(layeredGraph, portList, northDummyNodes, southDummyNodes, barycenterAssociates);
                    int insertPoint = pointer;
                    LNode successor = node;
                    for (LNode dummy : northDummyNodes) {
                        dummy.setLayer(insertPoint, layer);
                        ++pointer;
                        dummy.setProperty(InternalProperties.IN_LAYER_LAYOUT_UNIT, (Object)node);
                        assert (dummy.getPorts().size() >= 1);
                        LPort dummyPort = dummy.getPorts().get(0);
                        LPort originPort = (LPort)((Object)dummyPort.getProperty(InternalProperties.ORIGIN));
                        if (((Boolean)originPort.getProperty(LayeredOptions.NORTH_OR_SOUTH_PORT)).booleanValue()) continue;
                        ((List)dummy.getProperty(InternalProperties.IN_LAYER_SUCCESSOR_CONSTRAINTS)).add(successor);
                    }
                    portList.clear();
                    for (LPort port : node.getPorts(PortSide.SOUTH)) {
                        portList.addFirst(port);
                    }
                    this.createDummyNodes(layeredGraph, portList, southDummyNodes, null, barycenterAssociates);
                    LNode predecessor = node;
                    for (LNode dummy : southDummyNodes) {
                        dummy.setLayer(++pointer, layer);
                        dummy.setProperty(InternalProperties.IN_LAYER_LAYOUT_UNIT, (Object)node);
                        assert (dummy.getPorts().size() >= 1);
                        LPort dummyPort = dummy.getPorts().get(0);
                        LPort originPort = (LPort)((Object)dummyPort.getProperty(InternalProperties.ORIGIN));
                        if (((Boolean)originPort.getProperty(LayeredOptions.NORTH_OR_SOUTH_PORT)).booleanValue()) continue;
                        ((List)predecessor.getProperty(InternalProperties.IN_LAYER_SUCCESSOR_CONSTRAINTS)).add(dummy);
                    }
                    if (!barycenterAssociates.isEmpty()) {
                        node.setProperty(InternalProperties.BARYCENTER_ASSOCIATES, barycenterAssociates);
                    }
                }
                ++n2;
            }
        }
        monitor.done();
    }

    private void sortPortList(LNode node) {
        int ports = node.getPorts().size();
        int inPorts = 0;
        int inOutPorts = ports;
        int outPorts = 2 * ports;
        for (LPort port : node.getPorts()) {
            switch (port.getSide()) {
                case EAST: 
                case WEST: {
                    port.id = -1;
                    break;
                }
                case NORTH: 
                case SOUTH: {
                    int incoming = port.getIncomingEdges().size();
                    int outgoing = port.getOutgoingEdges().size();
                    port.id = incoming > 0 && outgoing > 0 ? inOutPorts++ : (incoming > 0 ? inPorts++ : (outgoing > 0 ? outPorts++ : inPorts++));
                }
            }
        }
        Collections.sort(node.getPorts(), (port1, port2) -> {
            PortSide side2;
            PortSide side1 = port1.getSide();
            if (side1 != (side2 = port2.getSide())) {
                return side1.ordinal() - side2.ordinal();
            }
            if (port1.id == port2.id) {
                return 0;
            }
            if (side1 == PortSide.NORTH) {
                return port1.id - port2.id;
            }
            return port2.id - port1.id;
        });
    }

    private void createDummyNodes(LGraph layeredGraph, List<LPort> ports, List<LNode> dummyNodes, List<LNode> opposingSideDummyNodes, List<LNode> barycenterAssociates) {
        ArrayList<LPort> inPorts = new ArrayList<LPort>(ports.size());
        ArrayList<LPort> outPorts = new ArrayList<LPort>(ports.size());
        ArrayList<LPort> inOutPorts = new ArrayList<LPort>(ports.size());
        ArrayList<LEdge> sameSideSelfLoopEdges = new ArrayList<LEdge>(ports.size());
        ArrayList<LEdge> northSouthSelfLoopEdges = new ArrayList<LEdge>(ports.size());
        for (LPort port : ports) {
            for (LEdge edge : port.getOutgoingEdges()) {
                if (edge.getSource().getNode() != edge.getTarget().getNode()) continue;
                if (port.getSide() == edge.getTarget().getSide()) {
                    sameSideSelfLoopEdges.add(edge);
                    continue;
                }
                if (port.getSide() != PortSide.NORTH || edge.getTarget().getSide() != PortSide.SOUTH) continue;
                northSouthSelfLoopEdges.add(edge);
            }
        }
        for (LEdge edge : northSouthSelfLoopEdges) {
            this.createNorthSouthSelfLoopDummyNodes(layeredGraph, edge, dummyNodes, opposingSideDummyNodes, PortSide.EAST);
        }
        for (LEdge edge : sameSideSelfLoopEdges) {
            this.createSameSideSelfLoopDummyNode(layeredGraph, edge, dummyNodes);
        }
        for (LPort port : ports) {
            boolean out;
            boolean in = port.getIncomingEdges().size() > 0;
            boolean bl = out = port.getOutgoingEdges().size() > 0;
            if (in && out) {
                inOutPorts.add(port);
                continue;
            }
            if (in) {
                inPorts.add(port);
                continue;
            }
            if (!out) continue;
            outPorts.add(port);
        }
        for (LPort inPort : inPorts) {
            barycenterAssociates.add(this.createDummyNode(layeredGraph, inPort, null, dummyNodes));
        }
        for (LPort outPort : outPorts) {
            barycenterAssociates.add(this.createDummyNode(layeredGraph, null, outPort, dummyNodes));
        }
        for (LPort inOutPort : inOutPorts) {
            barycenterAssociates.add(this.createDummyNode(layeredGraph, inOutPort, inOutPort, dummyNodes));
        }
    }

    private LNode createDummyNode(LGraph layeredGraph, LPort inPort, LPort outPort, List<LNode> dummyNodes) {
        LEdge edge;
        int n;
        int n2;
        LEdge[] lEdgeArray;
        LEdge[] edgeArray;
        LNode dummy = new LNode(layeredGraph);
        dummy.setType(LNode.NodeType.NORTH_SOUTH_PORT);
        dummy.setProperty(LayeredOptions.PORT_CONSTRAINTS, PortConstraints.FIXED_POS);
        int crossingHint = 0;
        if (inPort != null) {
            assert (!inPort.getIncomingEdges().isEmpty() || !inPort.getOutgoingEdges().isEmpty());
            LPort dummyInputPort = new LPort();
            dummyInputPort.setProperty(InternalProperties.ORIGIN, (Object)inPort);
            dummy.setProperty(InternalProperties.ORIGIN, (Object)inPort.getNode());
            dummyInputPort.setSide(PortSide.WEST);
            dummyInputPort.setNode(dummy);
            lEdgeArray = edgeArray = inPort.getIncomingEdges().toArray(new LEdge[inPort.getIncomingEdges().size()]);
            n2 = edgeArray.length;
            n = 0;
            while (n < n2) {
                edge = lEdgeArray[n];
                edge.setTarget(dummyInputPort);
                ++n;
            }
            inPort.setProperty(InternalProperties.PORT_DUMMY, (Object)dummy);
            ++crossingHint;
        }
        if (outPort != null) {
            assert (!outPort.getIncomingEdges().isEmpty() || !outPort.getOutgoingEdges().isEmpty());
            LPort dummyOutputPort = new LPort();
            dummy.setProperty(InternalProperties.ORIGIN, (Object)outPort.getNode());
            dummyOutputPort.setProperty(InternalProperties.ORIGIN, (Object)outPort);
            dummyOutputPort.setSide(PortSide.EAST);
            dummyOutputPort.setNode(dummy);
            lEdgeArray = edgeArray = outPort.getOutgoingEdges().toArray(new LEdge[outPort.getOutgoingEdges().size()]);
            n2 = edgeArray.length;
            n = 0;
            while (n < n2) {
                edge = lEdgeArray[n];
                edge.setSource(dummyOutputPort);
                ++n;
            }
            outPort.setProperty(InternalProperties.PORT_DUMMY, (Object)dummy);
            ++crossingHint;
        }
        dummy.setProperty(InternalProperties.CROSSING_HINT, crossingHint);
        dummyNodes.add(dummy);
        return dummy;
    }

    private void createSameSideSelfLoopDummyNode(LGraph layeredGraph, LEdge selfLoop, List<LNode> dummyNodes) {
        LNode dummy = new LNode(layeredGraph);
        dummy.setType(LNode.NodeType.NORTH_SOUTH_PORT);
        dummy.setProperty(LayeredOptions.PORT_CONSTRAINTS, PortConstraints.FIXED_POS);
        dummy.setProperty(InternalProperties.ORIGIN, (Object)selfLoop);
        LPort dummyInputPort = new LPort();
        dummyInputPort.setProperty(InternalProperties.ORIGIN, (Object)selfLoop.getTarget());
        dummyInputPort.setSide(PortSide.WEST);
        dummyInputPort.setNode(dummy);
        LPort dummyOutputPort = new LPort();
        dummyOutputPort.setProperty(InternalProperties.ORIGIN, (Object)selfLoop.getSource());
        dummyOutputPort.setSide(PortSide.EAST);
        dummyOutputPort.setNode(dummy);
        selfLoop.getSource().setProperty(InternalProperties.PORT_DUMMY, (Object)dummy);
        selfLoop.getTarget().setProperty(InternalProperties.PORT_DUMMY, (Object)dummy);
        selfLoop.setSource(null);
        selfLoop.setTarget(null);
        dummyNodes.add(dummy);
        dummy.setProperty(InternalProperties.CROSSING_HINT, 2);
    }

    private void createNorthSouthSelfLoopDummyNodes(LGraph layeredGraph, LEdge selfLoop, List<LNode> northDummyNodes, List<LNode> southDummyNodes, PortSide portSide) {
        LNode northDummy = new LNode(layeredGraph);
        northDummy.setType(LNode.NodeType.NORTH_SOUTH_PORT);
        northDummy.setProperty(LayeredOptions.PORT_CONSTRAINTS, PortConstraints.FIXED_POS);
        northDummy.setProperty(InternalProperties.ORIGIN, (Object)selfLoop.getSource().getNode());
        LPort northDummyOutputPort = new LPort();
        northDummyOutputPort.setProperty(InternalProperties.ORIGIN, (Object)selfLoop.getSource());
        northDummyOutputPort.setSide(portSide);
        northDummyOutputPort.setNode(northDummy);
        selfLoop.getSource().setProperty(InternalProperties.PORT_DUMMY, (Object)northDummy);
        LNode southDummy = new LNode(layeredGraph);
        southDummy.setType(LNode.NodeType.NORTH_SOUTH_PORT);
        southDummy.setProperty(LayeredOptions.PORT_CONSTRAINTS, PortConstraints.FIXED_POS);
        southDummy.setProperty(InternalProperties.ORIGIN, (Object)selfLoop.getTarget().getNode());
        LPort southDummyInputPort = new LPort();
        southDummyInputPort.setProperty(InternalProperties.ORIGIN, (Object)selfLoop.getTarget());
        southDummyInputPort.setSide(portSide);
        southDummyInputPort.setNode(southDummy);
        selfLoop.getTarget().setProperty(InternalProperties.PORT_DUMMY, (Object)southDummy);
        selfLoop.setSource(northDummyOutputPort);
        selfLoop.setTarget(southDummyInputPort);
        northDummyNodes.add(0, northDummy);
        southDummyNodes.add(southDummy);
        northDummy.setProperty(InternalProperties.CROSSING_HINT, 1);
        southDummy.setProperty(InternalProperties.CROSSING_HINT, 1);
    }
}

