/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.setext.generator;

import org.eclipse.escet.common.app.framework.Application;
import org.eclipse.escet.common.app.framework.Paths;
import org.eclipse.escet.common.app.framework.io.AppStreams;
import org.eclipse.escet.common.app.framework.options.InputFileOption;
import org.eclipse.escet.common.app.framework.options.Option;
import org.eclipse.escet.common.app.framework.options.OptionCategory;
import org.eclipse.escet.common.app.framework.options.Options;
import org.eclipse.escet.common.app.framework.output.IOutputComponent;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.setext.generator.JavaHeaderOption;
import org.eclipse.escet.setext.generator.OutputBnfFileOption;
import org.eclipse.escet.setext.generator.OutputDebugFilesOption;
import org.eclipse.escet.setext.generator.OutputJavaFilesOption;
import org.eclipse.escet.setext.generator.SeTextGenerator;
import org.eclipse.escet.setext.io.SeTextReader;
import org.eclipse.escet.setext.parser.ast.Specification;
import org.eclipse.escet.setext.parser.ast.parser.StartSymbol;

public class SeTextGeneratorApp
extends Application<IOutputComponent> {
    public static void main(String[] args) {
        SeTextGeneratorApp app = new SeTextGeneratorApp();
        app.run(args);
    }

    public SeTextGeneratorApp() {
    }

    public SeTextGeneratorApp(AppStreams streams) {
        super(streams);
    }

    public String getAppName() {
        return "SeText scanner/parser generator";
    }

    public String getAppDescription() {
        return "Generates scanner(s) and LALR(1) parser(s) for an SeText specification.";
    }

    protected int runInternal() {
        long startTime = System.nanoTime();
        Specification spec = (Specification)((SeTextReader)new SeTextReader().init()).read();
        SeTextGenerator.generateScanner(spec);
        for (StartSymbol start : spec.getStartSymbols()) {
            SeTextGenerator.generateParser(spec, start);
        }
        if (spec.hooksClass != null) {
            String hooksFilePath = spec.hooksClass.getSimpleClassName();
            hooksFilePath = String.valueOf(hooksFilePath) + ".skeleton";
            hooksFilePath = Paths.resolve((String)hooksFilePath);
            SeTextGenerator.writeHooksSkeleton(spec, hooksFilePath);
        }
        double duration = (double)(System.nanoTime() - startTime) / 1000000.0;
        OutputProvider.out((String)"Generation completed in %.0f millisecs.", (Object[])new Object[]{duration});
        return 0;
    }

    protected OutputProvider<IOutputComponent> getProvider() {
        return new OutputProvider();
    }

    protected OptionCategory getAllOptions() {
        OptionCategory generalOpts = SeTextGeneratorApp.getGeneralOptionCategory();
        OptionCategory genOpts = new OptionCategory("Generation", "Generation options.", Lists.list(), Lists.list((Object[])new Option[]{Options.getInstance(InputFileOption.class), Options.getInstance(OutputJavaFilesOption.class), Options.getInstance(OutputDebugFilesOption.class), Options.getInstance(OutputBnfFileOption.class), Options.getInstance(JavaHeaderOption.class)}));
        OptionCategory options = new OptionCategory("SeText Scanner/Parser Generator Options", "All options for the SeText scanner/parser generator.", Lists.list((Object[])new OptionCategory[]{generalOpts, genOpts}), Lists.list());
        return options;
    }
}

