/*
 * Copyright (c) 2021, 2024 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 */
package org.eclipse.lsat.common.ludus.backend.graph.weighted;

/**
 * @author Bram van der Sanden
 */
public class WDoubleEdge {
    Integer w1;

    Integer w2;

    WVertex src;

    WVertex tgt;

    public WDoubleEdge(WVertex source, WVertex target, Integer w1, Integer w2) {
        this.w1 = w1;
        this.w2 = w2;
        this.src = source;
        this.tgt = target;
    }

    public Integer getWeight1() {
        return w1;
    }

    public Integer getWeight2() {
        return w2;
    }

    public WVertex getSource() {
        return src;
    }

    public WVertex getTarget() {
        return tgt;
    }
}
