/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.typechecker;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.cif2cif.ElimComponentDefInst;
import org.eclipse.escet.cif.common.CifScopeUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.parser.ast.ASpecification;
import org.eclipse.escet.cif.typechecker.CifTypeCheckerProblemReporter;
import org.eclipse.escet.cif.typechecker.ErrMsg;
import org.eclipse.escet.cif.typechecker.IoDeclTypeChecker;
import org.eclipse.escet.cif.typechecker.PositionInfoPresenceChecker;
import org.eclipse.escet.cif.typechecker.SourceFile;
import org.eclipse.escet.cif.typechecker.SourceFiles;
import org.eclipse.escet.cif.typechecker.SymbolTableEntry;
import org.eclipse.escet.cif.typechecker.postchk.AssignmentPostChecker;
import org.eclipse.escet.cif.typechecker.postchk.CifAnnotationsPostChecker;
import org.eclipse.escet.cif.typechecker.postchk.CifPostCheckEnv;
import org.eclipse.escet.cif.typechecker.postchk.CifPrintPostChecker;
import org.eclipse.escet.cif.typechecker.postchk.CifSvgPostChecker;
import org.eclipse.escet.cif.typechecker.postchk.CifTypeCheckerPostCheckEnv;
import org.eclipse.escet.cif.typechecker.postchk.CyclePostChecker;
import org.eclipse.escet.cif.typechecker.postchk.EventsPostChecker;
import org.eclipse.escet.cif.typechecker.postchk.SingleEventUsePerAutPostChecker;
import org.eclipse.escet.cif.typechecker.postchk.UniqueStateInvariantsPostChecker;
import org.eclipse.escet.cif.typechecker.scopes.CompInstScope;
import org.eclipse.escet.cif.typechecker.scopes.ParentScope;
import org.eclipse.escet.cif.typechecker.scopes.SpecScope;
import org.eclipse.escet.cif.typechecker.scopes.SymbolScopeBuilder;
import org.eclipse.escet.cif.typechecker.scopes.SymbolScopeMerger;
import org.eclipse.escet.common.emf.EMFHelper;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.TextPosition;
import org.eclipse.escet.common.position.common.PositionUtils;
import org.eclipse.escet.common.position.metamodel.position.Position;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;
import org.eclipse.escet.common.typechecker.EcoreTypeChecker;
import org.eclipse.escet.common.typechecker.SemanticException;

public class CifTypeChecker
extends EcoreTypeChecker<ASpecification, Specification>
implements CifTypeCheckerProblemReporter {
    public static final boolean DEBUG = false;
    public final IoDeclTypeChecker ioDeclChecker = new IoDeclTypeChecker(this);
    public final SourceFiles sourceFiles = new SourceFiles();
    private SpecScope symbolTable = null;
    private final List<SymbolTableEntry> cycle = Lists.list();

    public void addToCycle(SymbolTableEntry entry) {
        if (!this.cycle.contains(entry)) {
            this.cycle.add(entry);
            return;
        }
        int idx = this.cycle.indexOf(entry);
        Assert.check((idx >= 0 ? 1 : 0) != 0);
        int i = idx;
        while (i < this.cycle.size()) {
            SymbolTableEntry startEntry = this.cycle.get(i);
            StringBuilder txt = new StringBuilder();
            int j = i;
            while (j < this.cycle.size()) {
                if (txt.length() > 0) {
                    txt.append(" -> ");
                }
                txt.append(CifTextUtils.getAbsName((PositionObject)this.cycle.get(j).getObject()));
                ++j;
            }
            j = idx;
            while (j <= i) {
                if (txt.length() > 0) {
                    txt.append(" -> ");
                }
                txt.append(CifTextUtils.getAbsName((PositionObject)this.cycle.get(j).getObject()));
                ++j;
            }
            this.addProblem(ErrMsg.DEF_USE_CYCLE, startEntry.getPosition(), CifTextUtils.getAbsName((PositionObject)startEntry.getObject()), txt.toString());
            ++i;
        }
        throw new SemanticException();
    }

    public void removeFromCycle(SymbolTableEntry entry) {
        SymbolTableEntry top = this.cycle.remove(this.cycle.size() - 1);
        if (top != entry) {
            throw new IllegalStateException("top of cycle != entry");
        }
    }

    protected Specification transRoot(ASpecification rootObj) {
        List<SourceFile> sourcesToProcess;
        this.symbolTable = null;
        SourceFile mainFile = new SourceFile(this.getSourceFilePath(), true, null, null);
        this.sourceFiles.add(mainFile);
        ParentScope scope = null;
        while (!(sourcesToProcess = this.sourceFiles.drainQueue()).isEmpty()) {
            for (SourceFile sourceFile : sourcesToProcess) {
                ASpecification astSpec = sourceFile.main ? rootObj : null;
                SpecScope fileScope = SymbolScopeBuilder.build(this, sourceFile, mainFile, astSpec);
                scope = scope == null ? fileScope : SymbolScopeMerger.mergeSpecs((SpecScope)scope, mainFile, fileScope, sourceFile);
            }
        }
        if (scope == null) {
            throw new AssertionError();
        }
        scope.tcheckFull();
        Assert.check((boolean)this.cycle.isEmpty());
        if (this.hasError()) {
            throw new SemanticException();
        }
        this.symbolTable = scope;
        List cycle = Lists.list();
        scope.detectCompDefInstCycles(cycle);
        scope.findUnusedDecls();
        if (!this.hasError()) {
            Specification specNoCompDef = (Specification)scope.getObject();
            if (CifScopeUtils.hasCompDefInst((Group)specNoCompDef)) {
                specNoCompDef = (Specification)EMFHelper.deepclone((EObject)specNoCompDef);
                new ElimComponentDefInst().transform(specNoCompDef);
            }
            CifTypeCheckerPostCheckEnv env = new CifTypeCheckerPostCheckEnv(this);
            CyclePostChecker.check(specNoCompDef, env);
            if (!this.hasError()) {
                new CifSvgPostChecker(env).check(specNoCompDef);
            }
            CifPrintPostChecker.check(specNoCompDef, env);
            SingleEventUsePerAutPostChecker.check(specNoCompDef, env);
            new AssignmentPostChecker().check((ComplexComponent)specNoCompDef, (CifPostCheckEnv)env);
            new UniqueStateInvariantsPostChecker().check((ComplexComponent)specNoCompDef, env);
            new EventsPostChecker().check(specNoCompDef, env);
            new CifAnnotationsPostChecker(env).check(specNoCompDef);
        }
        new PositionInfoPresenceChecker().check((Specification)scope.getObject());
        return (Specification)scope.getObject();
    }

    protected String getEcoreFileExtension() {
        return "cifx";
    }

    public SpecScope getSymbolTable() {
        return this.symbolTable;
    }

    public String resolveImport(String path) {
        SourceFile mainFile = this.sourceFiles.get(this.getSourceFilePath());
        Assert.notNull((Object)mainFile);
        return mainFile.resolve(path);
    }

    @Override
    public void addProblem(ErrMsg message, Position position, String ... args) {
        this.addProblem(message, PositionUtils.toTextPosition((Position)position), args);
    }

    public void addProblem(ErrMsg message, TextPosition position, String ... args) {
        String sourcePath = position.location;
        SourceFile sourceFile = this.sourceFiles.get(sourcePath);
        if (sourceFile == null) {
            throw new RuntimeException("No SourceFile found: " + sourcePath);
        }
        TextPosition reportPos = sourceFile.main ? position : sourceFile.problemPos;
        String formattedMsg = message.format(args);
        if (!sourceFile.main) {
            SourceFile mainFile = this.sourceFiles.get(this.getSourceFilePath());
            String relPath = sourceFile.getRelativePathFrom(mainFile);
            formattedMsg = Strings.fmt((String)"File \"%s\": %s", (Object[])new Object[]{relPath, formattedMsg});
        }
        this.addProblem(formattedMsg, message.getSeverity(), reportPos);
    }

    public SymbolTableEntry getEntryForObject(PositionObject obj) {
        SpecScope specScope = this.getSymbolTable();
        Assert.notNull((Object)specScope);
        if (obj instanceof Specification) {
            return specScope;
        }
        List path = CifScopeUtils.getScopePath((PositionObject)obj);
        path.add(0, obj);
        SymbolTableEntry entry = specScope;
        Assert.check((boolean)(Lists.last((List)path) instanceof Specification));
        int i = path.size() - 2;
        while (i >= 0) {
            PositionObject pathElem = (PositionObject)path.get(i);
            if (entry instanceof CompInstScope) {
                CompInstScope ciscope = (CompInstScope)entry;
                entry = ciscope.getCompDefScope();
            }
            SymbolTableEntry child = ((ParentScope)entry).getEntry(CifTextUtils.getName((PositionObject)pathElem));
            entry = child;
            --i;
        }
        Assert.check((entry != specScope ? 1 : 0) != 0);
        return entry;
    }
}

