/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.util;

import com.google.common.annotations.Beta;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import org.eclipse.lsp4j.Position;

@Beta
public class PositionReader
extends BufferedReader {
    private int line;
    private int column;
    private int markedLine;
    private int markedColumn;

    public PositionReader(String in) {
        super(new StringReader(in));
    }

    public Position getPosition() {
        return new Position(this.line, this.column);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            int c = super.read();
            if (c == 10 || c == 13 && this.peek() != 10) {
                ++this.line;
                this.column = 0;
            } else if (c != 13 && c != -1) {
                ++this.column;
            }
            return c;
        }
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    private int peek() throws IOException {
        this.mark(2);
        int c = super.read();
        this.reset();
        return c;
    }

    @Override
    public long skip(long n) throws IOException {
        long read = 0L;
        while (read < n) {
            if (this.read() == -1) {
                return read;
            }
            ++read;
        }
        return read;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mark(int readAheadLimit) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            super.mark(readAheadLimit);
            this.markedLine = this.line;
            this.markedColumn = this.column;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            super.reset();
            this.line = this.markedLine;
            this.column = this.markedColumn;
        }
    }
}

