/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.plcgen.generators;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.metamodel.cif.declarations.AlgVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.InputVariable;
import org.eclipse.escet.cif.metamodel.cif.expressions.DiscVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.java.CifConstructors;
import org.eclipse.escet.cif.plcgen.PlcGenSettings;
import org.eclipse.escet.cif.plcgen.conversion.PlcFunctionAppls;
import org.eclipse.escet.cif.plcgen.conversion.PouBuilder;
import org.eclipse.escet.cif.plcgen.conversion.expressions.CifDataProvider;
import org.eclipse.escet.cif.plcgen.conversion.expressions.ExprGenerator;
import org.eclipse.escet.cif.plcgen.conversion.expressions.ExprValueResult;
import org.eclipse.escet.cif.plcgen.generators.CifProcessor;
import org.eclipse.escet.cif.plcgen.generators.DocumentingSupport;
import org.eclipse.escet.cif.plcgen.generators.NameGenerator;
import org.eclipse.escet.cif.plcgen.generators.PlcCodeStorage;
import org.eclipse.escet.cif.plcgen.generators.PlcVariablePurpose;
import org.eclipse.escet.cif.plcgen.generators.TypeGenerator;
import org.eclipse.escet.cif.plcgen.generators.io.IoAddress;
import org.eclipse.escet.cif.plcgen.generators.io.IoDirection;
import org.eclipse.escet.cif.plcgen.generators.io.IoEntry;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcBasicVariable;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcDataVariable;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcPou;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcPouType;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcBoolLiteral;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcExpression;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcFuncAppl;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcNamedValue;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcVarExpression;
import org.eclipse.escet.cif.plcgen.model.functions.PlcPouDescription;
import org.eclipse.escet.cif.plcgen.model.statements.PlcAssignmentStatement;
import org.eclipse.escet.cif.plcgen.model.statements.PlcCommentLine;
import org.eclipse.escet.cif.plcgen.model.statements.PlcStatement;
import org.eclipse.escet.cif.plcgen.model.types.PlcElementaryType;
import org.eclipse.escet.cif.plcgen.model.types.PlcType;
import org.eclipse.escet.cif.plcgen.options.InputOutputCodeForm;
import org.eclipse.escet.cif.plcgen.targets.PlcTarget;
import org.eclipse.escet.common.emf.EMFHelper;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.CsvParser;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.PathPair;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.exceptions.InputOutputException;
import org.eclipse.escet.common.java.exceptions.InvalidInputException;
import org.eclipse.escet.common.java.output.WarnOutput;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class InputOutputGenerator {
    private static final int PLC_IO_ADDRESS_COLUMN = 0;
    private static final int PLC_TYPE_COLUMN = 1;
    private static final int ABS_CIF_NAME_COLUMN = 2;
    private static final int IO_NAME_COLUMN = 3;
    private static final Set<PlcElementaryType> FEASIBLE_IO_VAR_TYPES = Sets.set((Object[])new PlcElementaryType[]{PlcElementaryType.BOOL_TYPE, PlcElementaryType.INT_TYPE, PlcElementaryType.DINT_TYPE, PlcElementaryType.LINT_TYPE, PlcElementaryType.REAL_TYPE, PlcElementaryType.LREAL_TYPE});
    private final PlcTarget target;
    private final NameGenerator nameGenerator;
    private final TypeGenerator typeGenerator;
    private final PathPair ioTablePaths;
    private final InputOutputCodeForm inputOutputCodeForm;
    private final WarnOutput warnOutput;
    private List<List<String>> csvLines = null;

    public InputOutputGenerator(PlcTarget target, NameGenerator nameGenerator, TypeGenerator typeGenerator, PlcGenSettings settings) {
        this.target = target;
        this.nameGenerator = nameGenerator;
        this.typeGenerator = typeGenerator;
        this.ioTablePaths = settings.ioTablePaths;
        this.warnOutput = settings.warnOutput;
        this.inputOutputCodeForm = settings.inputOutputCodeForm;
    }

    public Set<String> getCustomIoNames() {
        Set result = Sets.set();
        for (List<String> line : this.getCsvLines()) {
            String ioName;
            if (line.size() <= 3 || !this.target.checkIoVariableName(ioName = line.get(3))) continue;
            result.add(ioName);
            result.add(this.target.getUsageVariableText(PlcVariablePurpose.INPUT_VAR, ioName));
            result.add(this.target.getUsageVariableText(PlcVariablePurpose.OUTPUT_VAR, ioName));
        }
        return result;
    }

    public void process(CifProcessor.CifObjectFinder cifObjectFinder) {
        List<IoEntry> entries = this.convertIoTableEntries(cifObjectFinder);
        this.generateIoCode(entries);
    }

    private List<List<String>> getCsvLines() {
        if (this.csvLines != null) {
            return this.csvLines;
        }
        this.csvLines = Lists.list();
        try {
            Throwable throwable = null;
            Object var2_6 = null;
            try (BufferedReader ioTableText = new BufferedReader(new FileReader(this.ioTablePaths.systemPath));){
                List line;
                CsvParser parser = new CsvParser((Reader)ioTableText);
                while ((line = parser.getRow()) != null) {
                    this.csvLines.add(line);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException ex) {
            this.warnOutput.line("I/O table file \"%s\" not found. The PLC code will not perform any I/O with the environment.", new Object[]{this.ioTablePaths.userPath});
        }
        catch (IOException ex) {
            throw new InputOutputException("Failed to read I/O table file \"" + this.ioTablePaths.userPath + "\".", (Throwable)ex);
        }
        catch (CsvParser.CsvParseError ex) {
            throw new InputOutputException("Invalid I/O table file \"" + this.ioTablePaths.userPath + "\".", (Throwable)ex);
        }
        return this.csvLines;
    }

    private List<IoEntry> convertIoTableEntries(CifProcessor.CifObjectFinder cifObjectFinder) {
        Set connectedInputCifObjects = Sets.set();
        Set connectedPlcAddresses = Sets.set();
        List entries = Lists.list();
        int lineNumber = 0;
        for (List<String> line : this.getCsvLines()) {
            String message;
            PositionObject cifObj;
            String tableLinePositionText = Strings.fmt((String)"at line %d of I/O table file \"%s\"", (Object[])new Object[]{++lineNumber, this.ioTablePaths.userPath});
            int numColumns = line.size();
            if (numColumns < 3 || numColumns > 4) {
                String message2 = Strings.fmt((String)"Incorrect number of fields (expected 3 or 4 fields, found %d) %s.", (Object[])new Object[]{numColumns, tableLinePositionText});
                throw new InvalidInputException(message2);
            }
            String plcTableTypeText = line.get(1).trim();
            PlcType plcTableType = this.checkIoType(plcTableTypeText, tableLinePositionText);
            String absCifName = line.get(2).trim();
            try {
                cifObj = cifObjectFinder.findCifObjectByAbsName(absCifName);
            }
            catch (IllegalArgumentException ex) {
                String message3 = Strings.fmt((String)"The 'CIF name' field containing \"%s\" does not refer to an object in the CIF specification (third field %s).", (Object[])new Object[]{absCifName, tableLinePositionText});
                throw new InvalidInputException(message3, (Throwable)ex);
            }
            PlcType plcTypeFromCif = this.decideTypeFromCif(absCifName, cifObj, tableLinePositionText);
            IoDirection directionFromCif = this.decideIoDirectionFromCif(cifObj);
            if (directionFromCif == IoDirection.IO_READ) {
                if (connectedInputCifObjects.contains(cifObj)) {
                    String message4 = Strings.fmt((String)"The CIF variable for entry %s is already in use for receiving a value from an input, as specified by an earlier I/O table entry.", (Object[])new Object[]{tableLinePositionText});
                    throw new InvalidInputException(message4);
                }
                connectedInputCifObjects.add(cifObj);
            }
            plcTableType = this.decidePlcType(plcTableType, absCifName, plcTypeFromCif, tableLinePositionText);
            String plcAddressText = line.get(0).trim();
            if (plcAddressText.isEmpty()) {
                String message5 = Strings.fmt((String)"The 'address' field is empty (first field %s).", (Object[])new Object[]{tableLinePositionText});
                throw new InvalidInputException(message5);
            }
            IoAddress plcAddress = this.target.parseIoAddress(plcAddressText);
            if (plcAddress == null) {
                message = Strings.fmt((String)"The 'address' field does not have a correct form (first field %s).", (Object[])new Object[]{tableLinePositionText});
                throw new InvalidInputException(message);
            }
            if (directionFromCif == IoDirection.IO_WRITE) {
                if (connectedPlcAddresses.contains(plcAddress)) {
                    message = Strings.fmt((String)"The PLC address for the entry %s is already in use for outputting a value, as specified by an earlier I/O table entry.", (Object[])new Object[]{tableLinePositionText});
                    throw new InvalidInputException(message);
                }
                connectedPlcAddresses.add(plcAddress);
            }
            String ioName = numColumns > 3 ? line.get(3) : null;
            ioName = ioName == null || ioName.isBlank() ? null : ioName;
            this.target.verifyIoTableEntry(plcAddress, plcTableType, directionFromCif, ioName, tableLinePositionText);
            IoEntry entry = new IoEntry(plcAddress, plcTableType, cifObj, directionFromCif, ioName);
            entries.add(entry);
        }
        return entries;
    }

    private PlcType checkIoType(String plcTableTypeText, String tableLinePositionText) {
        PlcType plcTableType;
        if (!plcTableTypeText.isEmpty()) {
            plcTableType = this.getIoVarType(plcTableTypeText);
            if (plcTableType == null) {
                String message = Strings.fmt((String)"Type \"%s\" contained in the 'PLC type' field is not a usable type for input/output (second field %s).", (Object[])new Object[]{plcTableTypeText, tableLinePositionText});
                throw new InvalidInputException(message);
            }
        } else {
            plcTableType = null;
        }
        return plcTableType;
    }

    private PlcType decideTypeFromCif(String absName, PositionObject cifObj, String tableLinePositionText) {
        PlcType plcType;
        if (cifObj instanceof DiscVariable) {
            DiscVariable dv = (DiscVariable)cifObj;
            plcType = this.typeGenerator.convertType(dv.getType());
        } else if (cifObj instanceof InputVariable) {
            InputVariable iv = (InputVariable)cifObj;
            plcType = this.typeGenerator.convertType(iv.getType());
        } else if (cifObj instanceof AlgVariable) {
            AlgVariable av = (AlgVariable)cifObj;
            plcType = this.typeGenerator.convertType(av.getType());
        } else {
            String message = Strings.fmt((String)"The 'CIF name' field containing \"%s\" does not indicate an algebraic, discrete or input variable (third field %s).", (Object[])new Object[]{absName, tableLinePositionText});
            throw new InvalidInputException(message);
        }
        if (!FEASIBLE_IO_VAR_TYPES.contains(plcType)) {
            String message = Strings.fmt((String)"The type of the CIF variable in the 'CIF name' field containing \"%s\" %s is not a boolean, integer or real type.", (Object[])new Object[]{absName, tableLinePositionText});
            throw new InvalidInputException(message);
        }
        return plcType;
    }

    private IoDirection decideIoDirectionFromCif(PositionObject posObject) {
        if (posObject instanceof DiscVariable || posObject instanceof AlgVariable) {
            return IoDirection.IO_WRITE;
        }
        if (posObject instanceof InputVariable) {
            return IoDirection.IO_READ;
        }
        throw new AssertionError((Object)("Unexpected CIF object \"" + String.valueOf(posObject) + "\"."));
    }

    private PlcType decidePlcType(PlcType plcTableType, String absCifName, PlcType plcTypeFromCif, String tableLinePositionText) {
        Assert.notNull((Object)plcTypeFromCif);
        if (plcTableType != null) {
            if (PlcElementaryType.isIntType(plcTableType) && !PlcElementaryType.isIntType(plcTypeFromCif) || PlcElementaryType.isRealType(plcTableType) && !PlcElementaryType.isRealType(plcTypeFromCif) || plcTableType == PlcElementaryType.BOOL_TYPE && plcTypeFromCif != PlcElementaryType.BOOL_TYPE) {
                String message = Strings.fmt((String)"The type stated in the 'PLC type' field (\"%s\") does not correspond with the PLC type (\"%s\") of the connected CIF variable from the 'CIF name' field containing \"%s\", for the entry %s.", (Object[])new Object[]{this.getNameOfPlcIoType(plcTableType), this.getNameOfPlcIoType(plcTypeFromCif), absCifName, tableLinePositionText});
                throw new InvalidInputException(message);
            }
        } else {
            plcTableType = plcTypeFromCif;
        }
        return plcTableType;
    }

    private PlcType getIoVarType(String typeName) {
        for (PlcElementaryType varType : FEASIBLE_IO_VAR_TYPES) {
            if (!typeName.equalsIgnoreCase(varType.name)) continue;
            return varType;
        }
        return null;
    }

    private String getNameOfPlcIoType(PlcType type) {
        if (type instanceof PlcElementaryType) {
            PlcElementaryType eType = (PlcElementaryType)type;
            return eType.name;
        }
        throw new AssertionError((Object)("Unexpected type \"" + String.valueOf(type) + "\" found."));
    }

    private void generateIoCode(List<IoEntry> entries) {
        boolean hasOutput;
        PlcFunctionAppls funcAppls = new PlcFunctionAppls(this.target);
        PlcCodeStorage codeStorage = this.target.getCodeStorage();
        ExprGenerator exprGen = codeStorage.getExprGenerator();
        Assert.check((IoDirection.values().length == 2 ? 1 : 0) != 0);
        boolean hasInput = entries.stream().anyMatch(entry -> entry.ioDirection == IoDirection.IO_READ);
        if (hasInput) {
            PlcGeneratedStatsVarsPous statsVarsPous;
            if (this.inputOutputCodeForm.inputCodeInMain) {
                statsVarsPous = this.processInputs(entries, exprGen, funcAppls);
            } else {
                String inputPouName = this.nameGenerator.generateGlobalName("processInputs", false);
                statsVarsPous = this.constructIoPou(entries, inputPouName, exprGen, funcAppls, (e, x, f) -> this.processInputs(e, x, f));
            }
            codeStorage.addInputVariables(statsVarsPous.ioVars);
            codeStorage.addInputFuncCode(statsVarsPous.statements);
            codeStorage.addPous(statsVarsPous.pous);
        }
        if (hasOutput = entries.stream().anyMatch(entry -> entry.ioDirection == IoDirection.IO_WRITE)) {
            PlcGeneratedStatsVarsPous statsVarsPous;
            if (this.inputOutputCodeForm.outputCodeInMain) {
                statsVarsPous = this.processOutputs(entries, exprGen, funcAppls);
            } else {
                String inputPouName = this.nameGenerator.generateGlobalName("processOutputs", false);
                statsVarsPous = this.constructIoPou(entries, inputPouName, exprGen, funcAppls, (e, x, f) -> this.processOutputs(e, x, f));
            }
            codeStorage.addOutputVariables(statsVarsPous.ioVars);
            codeStorage.addOutputFuncCode(statsVarsPous.statements);
            codeStorage.addPous(statsVarsPous.pous);
        }
    }

    private PlcGeneratedStatsVarsPous constructIoPou(List<IoEntry> entries, String pouName, ExprGenerator globalExprGen, PlcFunctionAppls funcAppls, IoEntriesConverter converter) {
        CifDataProvider cifDataProvider = this.target.getVarStorage().getCifDataProvider();
        PouBuilder pouBuilder = new PouBuilder(this.target, this.nameGenerator, this.typeGenerator, cifDataProvider);
        pouBuilder.createPou(pouName, PlcPouType.FUNCTION, PlcElementaryType.BOOL_TYPE);
        PlcDataVariable param = new PlcDataVariable("dummyParam", PlcElementaryType.BOOL_TYPE);
        pouBuilder.addInputParameter(param);
        PlcGeneratedStatsVarsPous convertedEntries = converter.convert(entries, pouBuilder.exprGen, funcAppls);
        Assert.check((boolean)convertedEntries.pous.isEmpty());
        pouBuilder.addStatements(convertedEntries.statements);
        pouBuilder.addReturnStatement(new PlcVarExpression((PlcBasicVariable)param, new PlcVarExpression.PlcProjection[0]));
        PlcPou pou = pouBuilder.finishPou();
        PlcBasicVariable dummyResultVar = globalExprGen.getScratchVariable("dummyResult", PlcElementaryType.BOOL_TYPE);
        PlcPouDescription funcDesc = new PlcPouDescription(pou);
        PlcNamedValue argument = new PlcNamedValue(param.varName, new PlcBoolLiteral(true));
        PlcFuncAppl rhs = new PlcFuncAppl(funcDesc, List.of(argument));
        PlcAssignmentStatement assignment = new PlcAssignmentStatement(dummyResultVar, (PlcExpression)rhs);
        globalExprGen.releaseScratchVariable(dummyResultVar);
        return new PlcGeneratedStatsVarsPous(List.of(assignment), convertedEntries.ioVars, List.of(pou));
    }

    private PlcGeneratedStatsVarsPous processInputs(List<IoEntry> entries, ExprGenerator exprGen, PlcFunctionAppls funcAppls) {
        List inputStats = Lists.list();
        List inputVars = Lists.list();
        CifDataProvider cifDataProvider = exprGen.getScopeCifDataProvider();
        for (IoEntry entry : entries) {
            if (entry.ioDirection != IoDirection.IO_READ) continue;
            String ioVarName = this.createIoVariableName("in_", entry);
            String targetText = this.target.getUsageVariableText(PlcVariablePurpose.INPUT_VAR, ioVarName);
            PlcDataVariable ioVar = new PlcDataVariable(targetText, ioVarName, entry.varType, entry.plcAddress.getAddress(), null);
            inputVars.add(ioVar);
            String commentText = Strings.fmt((String)"Read PLC input and write it to %s.", (Object[])new Object[]{DocumentingSupport.getDescription(entry.cifObject)});
            inputStats.add(new PlcCommentLine(commentText));
            Assert.check((boolean)(entry.cifObject instanceof InputVariable));
            PlcVarExpression leftSide = cifDataProvider.getAddressableForInputVar((InputVariable)entry.cifObject);
            PlcExpression rightSide = new PlcVarExpression((PlcBasicVariable)ioVar, new PlcVarExpression.PlcProjection[0]);
            if (!leftSide.type.equals(rightSide.type)) {
                rightSide = funcAppls.castFunctionAppl(rightSide, (PlcElementaryType)leftSide.type);
            }
            inputStats.add(new PlcAssignmentStatement(leftSide, rightSide));
        }
        return new PlcGeneratedStatsVarsPous(inputStats, inputVars, List.of());
    }

    private PlcGeneratedStatsVarsPous processOutputs(List<IoEntry> entries, ExprGenerator exprGen, PlcFunctionAppls funcAppls) {
        List outputStats = Lists.list();
        List outputVars = Lists.list();
        for (IoEntry entry : entries) {
            DiscVariableExpression cifRightSide;
            if (entry.ioDirection != IoDirection.IO_WRITE) continue;
            String ioVarName = this.createIoVariableName("out_", entry);
            String targetText = this.target.getUsageVariableText(PlcVariablePurpose.OUTPUT_VAR, ioVarName);
            PlcDataVariable ioVar = new PlcDataVariable(targetText, ioVarName, entry.varType, entry.plcAddress.getAddress(), null);
            outputVars.add(ioVar);
            String commentText = Strings.fmt((String)"Write %s to PLC output.", (Object[])new Object[]{DocumentingSupport.getDescription(entry.cifObject)});
            outputStats.add(new PlcCommentLine(commentText));
            PlcVarExpression leftSide = new PlcVarExpression((PlcBasicVariable)ioVar, new PlcVarExpression.PlcProjection[0]);
            if (entry.cifObject instanceof DiscVariable) {
                DiscVariable discVar = (DiscVariable)entry.cifObject;
                cifRightSide = CifConstructors.newDiscVariableExpression(null, (CifType)((CifType)EMFHelper.deepclone((EObject)discVar.getType())), (DiscVariable)discVar);
            } else if (entry.cifObject instanceof AlgVariable) {
                AlgVariable algVar = (AlgVariable)entry.cifObject;
                cifRightSide = CifConstructors.newAlgVariableExpression(null, (CifType)((CifType)EMFHelper.deepclone((EObject)algVar.getType())), (AlgVariable)algVar);
            } else {
                throw new AssertionError((Object)("Unexpected state variable found: " + String.valueOf(entry.cifObject)));
            }
            ExprValueResult exprResult = exprGen.convertValue((Expression)cifRightSide);
            outputStats.addAll(exprResult.code);
            exprResult.releaseCodeVariables();
            PlcExpression rightSide = exprResult.value;
            if (!leftSide.type.equals(rightSide.type)) {
                rightSide = funcAppls.castFunctionAppl(rightSide, (PlcElementaryType)leftSide.type);
            }
            outputStats.add(new PlcAssignmentStatement(leftSide, rightSide));
            exprResult.releaseValueVariables();
        }
        return new PlcGeneratedStatsVarsPous(outputStats, outputVars, List.of());
    }

    private String createIoVariableName(String varPrefix, IoEntry entry) {
        if (entry.ioName != null) {
            return entry.ioName;
        }
        String ioVarName = CifTextUtils.getAbsName((PositionObject)entry.cifObject, (boolean)false);
        return varPrefix + this.nameGenerator.generateGlobalNames(Set.of(varPrefix), ioVarName, false);
    }

    private static interface IoEntriesConverter {
        public PlcGeneratedStatsVarsPous convert(List<IoEntry> var1, ExprGenerator var2, PlcFunctionAppls var3);
    }

    public record PlcGeneratedStatsVarsPous(List<PlcStatement> statements, List<PlcDataVariable> ioVars, List<PlcPou> pous) {
    }
}

