/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.eventbased.equivalence;

import java.util.List;
import org.eclipse.escet.cif.eventbased.automata.Event;
import org.eclipse.escet.cif.eventbased.equivalence.BlockLocation;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;

public class Block {
    boolean needsReview = false;
    public final List<List<Integer>> inEvents;
    public final Block parent;
    public final Event splitEvent;
    public final int depth;
    public Integer[] outEvents;
    public List<BlockLocation> locs;

    public Block(int numEvents, int numLocs, Integer[] outgoing, Block parent, Event splitEvent) {
        this.outEvents = outgoing;
        this.parent = parent;
        this.splitEvent = splitEvent;
        Assert.implies((splitEvent != null ? 1 : 0) != 0, (parent != null ? 1 : 0) != 0);
        this.depth = parent == null ? 0 : parent.depth + 1;
        this.inEvents = Lists.listc((int)numEvents);
        int i = 0;
        while (i < numEvents) {
            List inc = Lists.list();
            this.inEvents.add(inc);
            ++i;
        }
        this.locs = numLocs >= 0 ? Lists.listc((int)numLocs) : Lists.list();
    }

    private String strList(List<Integer> inblocks) {
        Object s = "";
        for (Integer i : inblocks) {
            if (!((String)s).isEmpty()) {
                s = (String)s + ", ";
            }
            s = (String)s + (i == null ? "<null>" : String.valueOf(i));
        }
        return "[" + (String)s + "]";
    }

    public boolean allAutomataPresent(int numAuts) {
        if (numAuts == 1) {
            return true;
        }
        int toCheck = 0;
        boolean[] seen = new boolean[numAuts];
        for (BlockLocation loc : this.locs) {
            seen[loc.autNumber] = true;
            if (loc.autNumber != toCheck) continue;
            do {
                if (++toCheck != numAuts) continue;
                return true;
            } while (seen[toCheck]);
        }
        return false;
    }

    public String toString() {
        Object inText = "";
        int i = 0;
        while (i < this.inEvents.size()) {
            if (i > 0) {
                inText = (String)inText + ", ";
            }
            inText = (String)inText + "evt " + String.valueOf(i) + ": " + this.strList(this.inEvents.get(i));
            ++i;
        }
        String s = Strings.fmt((String)"Block(%d locations, review %srequired)", (Object[])new Object[]{this.locs.size(), this.needsReview ? "" : "not "});
        Object outText = "";
        int i2 = 0;
        while (i2 < this.outEvents.length) {
            if (i2 > 0) {
                outText = (String)outText + ", ";
            }
            outText = (String)outText + Strings.fmt((String)"evt %d: part %s", (Object[])new Object[]{i2, this.outEvents[i2] == null ? "<undecided>" : String.valueOf(this.outEvents[i2])});
            ++i2;
        }
        return "inEvents: {" + (String)inText + "}\n" + s + "\noutEvents: {" + (String)outText + "}";
    }
}

