/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.bdd.conversion;

import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.common.CifAddressableUtils;
import org.eclipse.escet.cif.common.CifEquationUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.metamodel.cif.Component;
import org.eclipse.escet.cif.metamodel.cif.Equation;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.Invariant;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.SupKind;
import org.eclipse.escet.cif.metamodel.cif.automata.Assignment;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Edge;
import org.eclipse.escet.cif.metamodel.cif.automata.ElifUpdate;
import org.eclipse.escet.cif.metamodel.cif.automata.IfUpdate;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.automata.Update;
import org.eclipse.escet.cif.metamodel.cif.declarations.AlgVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Constant;
import org.eclipse.escet.cif.metamodel.cif.declarations.ContVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.VariableValue;
import org.eclipse.escet.cif.metamodel.cif.expressions.AlgVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BoolExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.CastExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ComponentExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ConstantExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ContVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DictExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DictPair;
import org.eclipse.escet.cif.metamodel.cif.expressions.DiscVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ElifExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.EnumLiteralExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.EventExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FieldExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FunctionCallExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FunctionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.IfExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.InputVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.IntExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ListExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.LocationExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ProjectionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.RealExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ReceivedExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SelfExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SetExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SliceExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.StdLibFunctionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.StringExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SwitchCase;
import org.eclipse.escet.cif.metamodel.cif.expressions.SwitchExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TauExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TimeExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TupleExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.UnaryExpression;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.output.WarnOutput;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class PlantsRefsReqsChecker {
    private final WarnOutput warnOutput;
    private final Map<Automaton, Set<Declaration>> assignedVariablesPerAut = Maps.map();

    public PlantsRefsReqsChecker(WarnOutput warnOutput) {
        this.warnOutput = warnOutput;
    }

    public void checkPlantRefToRequirement(Specification spec) {
        for (Invariant inv : spec.getInvariants()) {
            this.check(inv);
        }
        for (Component comp : spec.getComponents()) {
            if (comp instanceof Group) {
                this.check((Group)comp);
                continue;
            }
            Assert.check((boolean)(comp instanceof Automaton));
            this.check((Automaton)comp);
        }
    }

    private void check(Group group) {
        for (Invariant inv : group.getInvariants()) {
            this.check(inv);
        }
        for (Component comp : group.getComponents()) {
            if (comp instanceof Group) {
                this.check((Group)comp);
                continue;
            }
            Assert.check((boolean)(comp instanceof Automaton));
            this.check((Automaton)comp);
        }
    }

    private void check(Automaton aut) {
        if (aut.getKind() == SupKind.PLANT) {
            for (Declaration decl : aut.getDeclarations()) {
                VariableValue variableValue;
                if (!(decl instanceof DiscVariable) || (variableValue = ((DiscVariable)decl).getValue()) == null) continue;
                for (Expression value : variableValue.getValues()) {
                    if (!this.referencesReq(value)) continue;
                    this.warnOutput.line("An initial value of plant discrete variable \"%s\" references requirement state.", new Object[]{CifTextUtils.getAbsName((PositionObject)decl)});
                }
            }
            for (Declaration decl : aut.getDeclarations()) {
                if (!(decl instanceof ContVariable)) continue;
                ContVariable contVariable = (ContVariable)decl;
                Set assignedVariables = this.assignedVariablesPerAut.get(aut);
                if (assignedVariables == null) {
                    assignedVariables = Sets.set();
                    CifAddressableUtils.collectAddrVars((Automaton)aut, (Set)assignedVariables);
                    this.assignedVariablesPerAut.put(aut, assignedVariables);
                }
                if (!assignedVariables.contains(contVariable)) continue;
                if (contVariable.getValue() != null && this.referencesReq(contVariable.getValue())) {
                    this.warnOutput.line("The initial value of plant continuous variable \"%s\" references requirement state.", new Object[]{CifTextUtils.getAbsName((PositionObject)decl)});
                }
                if (contVariable.getDerivative() == null || !this.referencesReq(contVariable.getDerivative())) continue;
                this.warnOutput.line("The derivative of plant continuous variable \"%s\" references requirement state.", new Object[]{CifTextUtils.getAbsName((PositionObject)decl)});
            }
            for (Location loc : aut.getLocations()) {
                for (Expression initPred : loc.getInitials()) {
                    if (!this.referencesReq(initPred)) continue;
                    this.warnOutput.line("Plant initialization predicate \"%s\" in %s references requirement state.", new Object[]{CifTextUtils.exprToStr((Expression)initPred), CifTextUtils.getLocationText2((Location)loc)});
                }
                for (Expression markPred : loc.getMarkeds()) {
                    if (!this.referencesReq(markPred)) continue;
                    this.warnOutput.line("Plant marker predicate \"%s\" in %s references requirement state.", new Object[]{CifTextUtils.exprToStr((Expression)markPred), CifTextUtils.getLocationText2((Location)loc)});
                }
                for (Equation equation : loc.getEquations()) {
                    if (!this.referencesReq(equation.getValue())) continue;
                    this.warnOutput.line("Plant equation \"%s\" in %s references requirement state.", new Object[]{CifTextUtils.equationToStr((Equation)equation), CifTextUtils.getLocationText2((Location)loc)});
                }
                for (Edge edge : loc.getEdges()) {
                    for (Expression guard : edge.getGuards()) {
                        if (!this.referencesReq(guard)) continue;
                        this.warnOutput.line("Plant edge guard \"%s\" in %s references requirement state.", new Object[]{CifTextUtils.exprToStr((Expression)guard), CifTextUtils.getLocationText2((Location)loc)});
                    }
                    for (Update update : edge.getUpdates()) {
                        if (!this.referencesReq(update)) continue;
                        this.warnOutput.line("Plant edge update \"%s\" in %s references requirement state.", new Object[]{CifTextUtils.updateToStr((Update)update), CifTextUtils.getLocationText2((Location)loc)});
                    }
                }
            }
        }
        if (aut.getKind() == SupKind.REQUIREMENT) {
            for (Location loc : aut.getLocations()) {
                for (Invariant inv : loc.getInvariants()) {
                    if (inv.getSupKind() != SupKind.PLANT) continue;
                    this.warnOutput.line("Plant invariant \"%s\" in %s implicitly depends on requirement state.", new Object[]{CifTextUtils.invToStr((Invariant)inv, (boolean)false), CifTextUtils.getLocationText2((Location)loc)});
                }
            }
        }
        for (Invariant inv : aut.getInvariants()) {
            this.check(inv);
        }
        for (Location loc : aut.getLocations()) {
            for (Invariant inv : loc.getInvariants()) {
                this.check(inv);
            }
        }
    }

    private void check(Invariant inv) {
        if (inv.getSupKind() != SupKind.PLANT) {
            return;
        }
        Expression pred = inv.getPredicate();
        if (this.referencesReq(pred)) {
            this.warnOutput.line("Plant invariant \"%s\" in %s references requirement state.", new Object[]{CifTextUtils.exprToStr((Expression)pred), CifTextUtils.getLocationOrComponentText2((EObject)inv.eContainer())});
        }
    }

    private boolean referencesReq(Update update) {
        if (update instanceof Assignment) {
            Expression value = ((Assignment)update).getValue();
            return this.referencesReq(value);
        }
        if (update instanceof IfUpdate) {
            IfUpdate ifUpdate = (IfUpdate)update;
            for (Expression guard : ifUpdate.getGuards()) {
                if (!this.referencesReq(guard)) continue;
                return true;
            }
            for (Update then : ifUpdate.getThens()) {
                if (!this.referencesReq(then)) continue;
                return true;
            }
            for (ElifUpdate elif : ifUpdate.getElifs()) {
                for (Expression guard : elif.getGuards()) {
                    if (!this.referencesReq(guard)) continue;
                    return true;
                }
                for (Update then : elif.getThens()) {
                    if (!this.referencesReq(then)) continue;
                    return true;
                }
            }
            for (Update elseUpdate : ifUpdate.getElses()) {
                if (!this.referencesReq(elseUpdate)) continue;
                return true;
            }
            return false;
        }
        throw new RuntimeException("Unexpected update: " + String.valueOf(update));
    }

    private boolean referencesReq(Expression expr) {
        if (expr instanceof BoolExpression) {
            return false;
        }
        if (expr instanceof IntExpression) {
            return false;
        }
        if (expr instanceof RealExpression) {
            return false;
        }
        if (expr instanceof StringExpression) {
            return false;
        }
        if (expr instanceof TimeExpression) {
            return false;
        }
        if (expr instanceof CastExpression) {
            Expression child = ((CastExpression)expr).getChild();
            return this.referencesReq(child);
        }
        if (expr instanceof UnaryExpression) {
            Expression child = ((UnaryExpression)expr).getChild();
            return this.referencesReq(child);
        }
        if (expr instanceof BinaryExpression) {
            BinaryExpression bexpr = (BinaryExpression)expr;
            Expression left = bexpr.getLeft();
            Expression right = bexpr.getRight();
            return this.referencesReq(left) || this.referencesReq(right);
        }
        if (expr instanceof IfExpression) {
            IfExpression iexpr = (IfExpression)expr;
            for (Expression guard : iexpr.getGuards()) {
                if (!this.referencesReq(guard)) continue;
                return true;
            }
            if (this.referencesReq(iexpr.getThen())) {
                return true;
            }
            for (ElifExpression elif : iexpr.getElifs()) {
                for (Expression guard : elif.getGuards()) {
                    if (!this.referencesReq(guard)) continue;
                    return true;
                }
                if (!this.referencesReq(elif.getThen())) continue;
                return true;
            }
            return this.referencesReq(iexpr.getElse());
        }
        if (expr instanceof SwitchExpression) {
            SwitchExpression sexpr = (SwitchExpression)expr;
            if (this.referencesReq(sexpr.getValue())) {
                return true;
            }
            for (SwitchCase cse : sexpr.getCases()) {
                if (cse.getKey() != null && this.referencesReq(cse.getKey())) {
                    return true;
                }
                if (!this.referencesReq(cse.getValue())) continue;
                return true;
            }
            return false;
        }
        if (expr instanceof ProjectionExpression) {
            ProjectionExpression pexpr = (ProjectionExpression)expr;
            Expression child = pexpr.getChild();
            Expression index = pexpr.getIndex();
            return this.referencesReq(child) || this.referencesReq(index);
        }
        if (expr instanceof SliceExpression) {
            SliceExpression sexpr = (SliceExpression)expr;
            if (this.referencesReq(sexpr.getChild())) {
                return true;
            }
            if (sexpr.getBegin() != null && this.referencesReq(sexpr.getBegin())) {
                return true;
            }
            return sexpr.getEnd() != null && this.referencesReq(sexpr.getEnd());
        }
        if (expr instanceof FunctionCallExpression) {
            for (Expression arg : ((FunctionCallExpression)expr).getArguments()) {
                if (!this.referencesReq(arg)) continue;
                return true;
            }
            return this.referencesReq(((FunctionCallExpression)expr).getFunction());
        }
        if (expr instanceof ListExpression) {
            ListExpression lexpr = (ListExpression)expr;
            for (Expression elem : lexpr.getElements()) {
                if (!this.referencesReq(elem)) continue;
                return true;
            }
            return false;
        }
        if (expr instanceof SetExpression) {
            SetExpression sexpr = (SetExpression)expr;
            for (Expression elem : sexpr.getElements()) {
                if (!this.referencesReq(elem)) continue;
                return true;
            }
            return false;
        }
        if (expr instanceof TupleExpression) {
            TupleExpression texpr = (TupleExpression)expr;
            for (Expression field : texpr.getFields()) {
                if (!this.referencesReq(field)) continue;
                return true;
            }
            return false;
        }
        if (expr instanceof DictExpression) {
            DictExpression dexpr = (DictExpression)expr;
            for (DictPair pair : dexpr.getPairs()) {
                if (!this.referencesReq(pair.getKey()) && !this.referencesReq(pair.getValue())) continue;
                return true;
            }
            return false;
        }
        if (expr instanceof ConstantExpression) {
            Constant constant = ((ConstantExpression)expr).getConstant();
            return this.referencesReq(constant.getValue());
        }
        if (expr instanceof EnumLiteralExpression) {
            return false;
        }
        if (expr instanceof FieldExpression) {
            return false;
        }
        if (expr instanceof StdLibFunctionExpression) {
            return false;
        }
        if (expr instanceof FunctionExpression) {
            return false;
        }
        if (expr instanceof DiscVariableExpression) {
            DiscVariable var = ((DiscVariableExpression)expr).getVariable();
            EObject parent = var.eContainer();
            if (parent instanceof Automaton && ((Automaton)parent).getKind() == SupKind.REQUIREMENT) {
                return true;
            }
            VariableValue varValue = var.getValue();
            if (varValue == null) {
                return false;
            }
            for (Expression value : varValue.getValues()) {
                if (!this.referencesReq(value)) continue;
                return true;
            }
            return false;
        }
        if (expr instanceof AlgVariableExpression) {
            AlgVariable var = ((AlgVariableExpression)expr).getVariable();
            Expression value = CifEquationUtils.getSingleValueForAlgVar((AlgVariable)var);
            return this.referencesReq(value);
        }
        if (expr instanceof ContVariableExpression) {
            ContVariable var = ((ContVariableExpression)expr).getVariable();
            EObject parent = var.eContainer();
            if (parent instanceof Automaton && ((Automaton)parent).getKind() == SupKind.REQUIREMENT) {
                Automaton aut = (Automaton)parent;
                Set assignedVariables = this.assignedVariablesPerAut.get(aut);
                if (assignedVariables == null) {
                    assignedVariables = Sets.set();
                    CifAddressableUtils.collectAddrVars((Automaton)aut, (Set)assignedVariables);
                    this.assignedVariablesPerAut.put(aut, assignedVariables);
                }
                if (assignedVariables.contains(var)) {
                    return true;
                }
            }
            if (var.getValue() != null && this.referencesReq(var.getValue())) {
                return true;
            }
            Expression derivative = CifEquationUtils.getSingleDerivativeForContVar((ContVariable)var);
            return this.referencesReq(derivative);
        }
        if (expr instanceof InputVariableExpression) {
            return false;
        }
        if (expr instanceof LocationExpression) {
            Location loc = ((LocationExpression)expr).getLocation();
            Automaton aut = (Automaton)loc.eContainer();
            return aut.getKind() == SupKind.REQUIREMENT;
        }
        if (expr instanceof ComponentExpression) {
            Component component = ((ComponentExpression)expr).getComponent();
            if (component instanceof Group) {
                return false;
            }
            Assert.check((boolean)(component instanceof Automaton));
            Automaton aut = (Automaton)component;
            return aut.getKind() == SupKind.REQUIREMENT;
        }
        if (expr instanceof SelfExpression) {
            EObject parent = expr.eContainer();
            while (!(parent instanceof Automaton)) {
                parent = parent.eContainer();
            }
            Automaton aut = (Automaton)parent;
            return aut.getKind() == SupKind.REQUIREMENT;
        }
        if (expr instanceof ReceivedExpression) {
            return false;
        }
        if (expr instanceof TauExpression) {
            return false;
        }
        if (expr instanceof EventExpression) {
            return false;
        }
        throw new RuntimeException("Unexpected expr: " + String.valueOf(expr));
    }
}

