/******************************************************************************
 * Copyright (c) 2024 Contributors to the Eclipse Foundation
 *
 * See the NOTICE file(s) distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This program and the accompanying materials are made available under the terms
 * of the MIT License which is available at https://opensource.org/licenses/MIT
 *
 *  SPDX-License-Identifier: MIT
 *****************************************************************************/

/* Chi language for highlight.js 11.9.0. */
(() => {
    var e = (() => {
        "use strict";
        return e => {
            return {
                name: "Chi",
                keywords: {
                    keyword: [
                        // Keywords: top-level.
                        "const", "enum", "xper", "func", "model", "proc", "type",

                        // Keywords: iterative statements.
                        "for", "while", "break", "continue",

                        // Keywords: sub-process statements.
                        "return", "run", "start",

                        // Keywords: other keywords.
                        "select", "alt", "unwind", "close", "if", "elif", "else",
                        "delay", "time", "end", "finish", "pass", "exit",
                        "write", "writeln",

                        // Types.
                        "bool", "chan", "dict", "dist", "file", "inst", "int",
                        "list", "matrix", "real", "set", "string", "timer",
                        "tuple", "void",

                        // Constants.
                        "false", "true",
                    ],
                    built_in: [
                        // 'simple' conversions.
                        "abs", "sign", "max", "min", "ceil", "floor", "round",

                        // Power and logarithmic functions.
                        "cbrt", "sqrt", "exp", "ln", "log",

                        // Trigonometry.
                        "acosh", "acos", "asinh", "asin", "atanh", "atan",
                        "cosh", "cos", "sinh", "sin", "tanh", "tan",

                        // Distributions.
                        "bernoulli", "beta", "binomial", "constant", "lognormal",
                        "exponential", "erlang", "gamma",
                        "geometric", "normal", "poisson", "random", "triangle",
                        "uniform", "weibull",

                        // Container functions.
                        "dictkeys", "dictvalues",
                        "empty", "size", "pop",
                        "enumerate", "range", "del", "insert", "sort",

                        // Other stuff.
                        "finished", "ready", "open",
                        "channel", "read", "eol", "eof", "newlines",
                    ],
                    operator: [
                        "and", "div", "in", "mod", "not", "or", "sub", "sample",
                    ]
                },
                contains: [
                    // Numbers.
                    {
                        scope: "number",
                        match: /\b(0|[1-9][0-9]*)(([.][0-9]+)?[eE][-+]?[0-9]+)\b/,
                    },
                    {
                        scope: "number",
                        match: /\b(0|[1-9][0-9]*)([.][0-9]+)\b/,
                    },
                    {
                        scope: "number",
                        match: /\b(0|[1-9][0-9]*)\b/,
                    },

                    // Comments.
                    {
                        scope: "comment",
                        begin: '#',
                        end: '$',
                    },

                    // Strings, with escapes and format patterns.
                    {
                        scope: "string",
                        begin: '"',
                        end: '"',
                        contains: [
                            {
                                scope: "char.escape",
                                match: /\\[nt\\"]/,
                            },
                            {
                                scope: "regex",
                                match: /%([0-9]+[$])?[-+ 0,]*[0-9]*([.][0-9]+)?[bBdxXeEfgGsS]/,
                            },
                            {
                                scope: "char.escape",
                                match: '%%',
                            }
                        ]
                    },

                    // Escaped keywords should be identifiers.
                    {
                        scope: "escaped-keyword",
                        match: /[$]\b[A-Za-z_][A-Za-z0-9_]*\b/,
                    }
                ]
            }
        }
    })();
    hljs.registerLanguage("chi", e)
})();
