/*
 * Decompiled with CFR 0.152.
 */
package machine;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ResourceType implements Enumerator
{
    REGULAR(0, "REGULAR", "REGULAR"),
    EVENT(1, "EVENT", "EVENT"),
    PASSIVE(2, "PASSIVE", "PASSIVE");

    public static final int REGULAR_VALUE = 0;
    public static final int EVENT_VALUE = 1;
    public static final int PASSIVE_VALUE = 2;
    private static final ResourceType[] VALUES_ARRAY;
    public static final List<ResourceType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ResourceType[]{REGULAR, EVENT, PASSIVE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ResourceType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ResourceType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ResourceType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ResourceType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ResourceType get(int value) {
        switch (value) {
            case 0: {
                return REGULAR;
            }
            case 1: {
                return EVENT;
            }
            case 2: {
                return PASSIVE;
            }
        }
        return null;
    }

    private ResourceType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

