/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.internal.faulttolerance.java;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4mp.jdt.core.java.diagnostics.IJavaDiagnosticsParticipant;
import org.eclipse.lsp4mp.jdt.core.java.diagnostics.JavaDiagnosticsContext;
import org.eclipse.lsp4mp.jdt.core.utils.AnnotationUtils;
import org.eclipse.lsp4mp.jdt.core.utils.JDTTypeUtils;
import org.eclipse.lsp4mp.jdt.internal.faulttolerance.java.MicroProfileFaultToleranceErrorCode;

public class MicroProfileFaultToleranceDiagnosticsParticipant
implements IJavaDiagnosticsParticipant {
    @Override
    public boolean isAdaptedForDiagnostics(JavaDiagnosticsContext context, IProgressMonitor monitor) throws CoreException {
        IJavaProject javaProject = context.getJavaProject();
        return JDTTypeUtils.findType(javaProject, "org.eclipse.microprofile.faulttolerance.Fallback") != null;
    }

    @Override
    public List<Diagnostic> collectDiagnostics(JavaDiagnosticsContext context, IProgressMonitor monitor) throws CoreException {
        ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
        MicroProfileFaultToleranceDiagnosticsParticipant.validateClass(diagnostics, context, monitor);
        return diagnostics;
    }

    private static void validateClass(List<Diagnostic> diagnostics, JavaDiagnosticsContext context, IProgressMonitor monitor) {
        CompilationUnit ast = context.getASTRoot();
        ast.accept((ASTVisitor)new FaultToleranceAnnotationValidator(diagnostics, context));
    }

    private static class FaultToleranceAnnotationValidator
    extends ASTVisitor {
        private final Map<TypeDeclaration, Set<String>> methodsCache = new HashMap<TypeDeclaration, Set<String>>();
        private List<Diagnostic> diagnostics;
        private JavaDiagnosticsContext context;
        private static Logger LOGGER = Logger.getLogger(FaultToleranceAnnotationValidator.class.getName());

        public FaultToleranceAnnotationValidator(List<Diagnostic> diagnostics, JavaDiagnosticsContext context) {
            this.diagnostics = diagnostics;
            this.context = context;
        }

        public boolean visit(MethodDeclaration node) {
            try {
                this.validateMethod(node, this.diagnostics, this.context);
            }
            catch (JavaModelException javaModelException) {
                LOGGER.log(Level.WARNING, "An exception occured when attempting to validate the fallback method");
            }
            super.visit(node);
            return true;
        }

        private void validateMethod(MethodDeclaration node, List<Diagnostic> diagnostics, JavaDiagnosticsContext context) throws JavaModelException {
            List modifiers = node.modifiers();
            for (Object modifier : modifiers) {
                Expression fallbackMethodExpr;
                NormalAnnotation annotation;
                if (!(modifier instanceof NormalAnnotation) || !AnnotationUtils.isMatchAnnotation((Annotation)(annotation = (NormalAnnotation)modifier), "org.eclipse.microprofile.faulttolerance.Fallback") || (fallbackMethodExpr = AnnotationUtils.getAnnotationMemberValueExpression((Annotation)annotation, "fallbackMethod")) == null) continue;
                String fallbackMethodName = fallbackMethodExpr.toString();
                fallbackMethodName = fallbackMethodName.substring(1, fallbackMethodName.length() - 1);
                if (this.getExistingMethods(node).contains(fallbackMethodName)) continue;
                IOpenable openable = context.getTypeRoot().getOpenable();
                Diagnostic d = context.createDiagnostic(context.getUri(), "The referenced fallback method '" + fallbackMethodName + "' does not exist", context.getUtils().toRange(openable, fallbackMethodExpr.getStartPosition(), fallbackMethodExpr.getLength()), "microprofile-faulttolerance", MicroProfileFaultToleranceErrorCode.FALLBACK_METHOD_DOES_NOT_EXIST);
                d.setSeverity(DiagnosticSeverity.Error);
                diagnostics.add(d);
            }
        }

        private Set<String> getExistingMethods(MethodDeclaration node) {
            TypeDeclaration type = this.getOwnerType((ASTNode)node);
            if (type == null) {
                return Collections.emptySet();
            }
            return this.getExistingMethods(type);
        }

        private TypeDeclaration getOwnerType(ASTNode node) {
            while (node != null) {
                if (node instanceof TypeDeclaration) {
                    return (TypeDeclaration)node;
                }
                node = node.getParent();
            }
            return null;
        }

        private Set<String> getExistingMethods(TypeDeclaration type) {
            Set<String> methods = this.methodsCache.get(type);
            if (methods == null) {
                methods = Stream.of(type.getMethods()).map(m -> m.getName().getIdentifier()).collect(Collectors.toUnmodifiableSet());
                this.methodsCache.put(type, methods);
            }
            return methods;
        }
    }
}

