/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.snapshot.views.inspector;

import java.util.ArrayList;
import java.util.List;
import java.util.function.IntConsumer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mat.ui.MemoryAnalyserPlugin;
import org.eclipse.mat.ui.Messages;
import org.eclipse.mat.ui.snapshot.views.inspector.LazyFields;
import org.eclipse.mat.util.MessageUtil;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.MessageBox;

public class FieldsContentProvider
implements IStructuredContentProvider,
IDoubleClickListener {
    private Viewer viewer;
    private int limit;
    private LazyFields<?> fields;

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.fields = (LazyFields)newInput;
        this.limit = 25;
        this.viewer = viewer;
        if (this.viewer instanceof StructuredViewer) {
            ((StructuredViewer)this.viewer).addDoubleClickListener((IDoubleClickListener)this);
        }
    }

    public Object[] getElements(Object inputElement) {
        boolean isAll = this.fields.getSize() <= this.limit;
        Object[] result = new Object[(isAll ? 0 : 1) + Math.min(this.fields.getSize(), this.limit)];
        List<?> elements = this.fields.getElements(this.limit);
        int index = 0;
        while (index < result.length && index < elements.size()) {
            result[index] = elements.get(index);
            ++index;
        }
        if (!isAll) {
            result[result.length - 1] = new MoreNode(this.limit, this.fields.getSize(), this::setLimit, this.viewer.getControl());
        }
        return result;
    }

    private void setLimit(int newLimit) {
        this.limit = newLimit;
        this.viewer.refresh();
    }

    public void dispose() {
    }

    public void doubleClick(DoubleClickEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        if (!(selection.getFirstElement() instanceof MoreNode)) {
            return;
        }
        this.limit += 25;
        this.viewer.refresh();
    }

    static class CustomExpandAction
    extends ExpandAction {
        CustomExpandAction(int limit, int size, IntConsumer limitUpdater, Control control) {
            super(Messages.FieldsContentProvider_CustomExpand, limit, size, limitUpdater, control);
        }

        @Override
        protected long nextLimit() {
            InputDialog inputDialog = new InputDialog(this.getControl().getShell(), Messages.FieldsContentProvider_ExpandToLimit, Messages.FieldsContentProvider_EnterNumber, null, (IInputValidator)new IntegerInputValidator());
            if (inputDialog.open() == 1) {
                return -1L;
            }
            return this.getCurrentLimit() + (long)Integer.parseInt(inputDialog.getValue());
        }
    }

    static abstract class ExpandAction
    extends Action {
        private long limit;
        private long size;
        private IntConsumer limitUpdater;
        private Control control;

        ExpandAction(String text, int limit, int size, IntConsumer limitUpdater, Control control) {
            super(text);
            this.limit = limit;
            this.size = size;
            this.limitUpdater = limitUpdater;
            this.control = control;
            this.setImageDescriptor(MemoryAnalyserPlugin.getImageDescriptor("$nl$/icons/plus.gif"));
        }

        public final void run() {
            long delta;
            long toBeExpanded;
            long nextLimit = this.nextLimit();
            if (nextLimit < this.limit) {
                return;
            }
            if (nextLimit > Integer.MAX_VALUE) {
                nextLimit = Integer.MAX_VALUE;
            }
            if ((toBeExpanded = Math.min(this.size - this.limit, delta = nextLimit - this.limit)) > 5000L) {
                MessageBox box = new MessageBox(this.control.getShell(), 292);
                box.setMessage(MessageUtil.format((String)Messages.FieldsContentProvider_BlockingWarning, (Object[])new Object[]{toBeExpanded}));
                if (box.open() != 32) {
                    return;
                }
            }
            this.limitUpdater.accept((int)nextLimit);
        }

        protected final long getCurrentLimit() {
            return this.limit;
        }

        protected final Control getControl() {
            return this.control;
        }

        protected abstract long nextLimit();
    }

    static class ExpandAllAction
    extends ExpandAction {
        ExpandAllAction(int limit, int size, IntConsumer limitUpdater, Control control) {
            super(Messages.FieldsContentProvider_ExpandAll, limit, size, limitUpdater, control);
        }

        @Override
        protected long nextLimit() {
            return Integer.MAX_VALUE;
        }
    }

    static class IntegerInputValidator
    implements IInputValidator {
        IntegerInputValidator() {
        }

        public String isValid(String newText) {
            if (newText == null || newText.length() == 0) {
                return " ";
            }
            try {
                if (Integer.parseInt(newText) > 0) {
                    return null;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return Messages.FieldsContentProvider_notValidNumber;
        }
    }

    static class MoreNode {
        int size;
        int limit;
        Control control;
        IntConsumer limitUpdater;

        MoreNode(int limit, int size, IntConsumer limitUpdater, Control control) {
            this.limit = limit;
            this.size = size;
            this.limitUpdater = limitUpdater;
            this.control = control;
        }

        public String toString() {
            return MessageUtil.format((String)Messages.FieldsContentProvider_Displayed, (Object[])new Object[]{this.limit, this.size});
        }

        public Iterable<Action> getActions() {
            ArrayList<Action> actions = new ArrayList<Action>();
            if (this.size - this.limit >= 25) {
                actions.add(new Next25ExpandAction(this.limit, this.size, this.limitUpdater, this.control));
            }
            actions.add(new CustomExpandAction(this.limit, this.size, this.limitUpdater, this.control));
            actions.add(new ExpandAllAction(this.limit, this.size, this.limitUpdater, this.control));
            return actions;
        }
    }

    static class Next25ExpandAction
    extends ExpandAction {
        Next25ExpandAction(int limit, int size, IntConsumer limitUpdater, Control control) {
            super(Messages.FieldsContentProvider_Next25, limit, size, limitUpdater, control);
        }

        @Override
        protected long nextLimit() {
            return this.getCurrentLimit() + 25L;
        }
    }
}

