/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.collect;

import java.io.Serializable;
import java.util.ArrayList;

public final class ArrayIntBig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ArrayList<int[]> pages = new ArrayList();
    private int[] page;
    private int length = 0;

    public final void add(int element) {
        int index;
        if ((index = this.length++ & 0x3FF) == 0) {
            this.page = new int[1024];
            this.pages.add(this.page);
        }
        this.page[index] = element;
    }

    public final void addAll(int[] elements) {
        int bite;
        int free = this.length & 0x3FF;
        int n = bite = free == 0 ? 0 : Math.min(elements.length, 1024 - free);
        if (bite > 0) {
            System.arraycopy(elements, 0, this.pages.get(this.length >> 10), this.length & 0x3FF, bite);
            this.length += bite;
        }
        int copied = bite;
        while (copied < elements.length) {
            this.page = new int[1024];
            this.pages.add(this.page);
            bite = Math.min(elements.length - copied, 1024);
            System.arraycopy(elements, copied, this.page, 0, bite);
            copied += bite;
            this.length += bite;
        }
    }

    public final int get(int index) throws IndexOutOfBoundsException {
        if (index >= this.length) {
            throw new IndexOutOfBoundsException();
        }
        return this.pages.get(index >> 10)[index & 0x3FF];
    }

    public final int length() {
        return this.length;
    }

    public boolean isEmpty() {
        return this.length == 0;
    }

    public final long consumption() {
        return (long)this.pages.size() << 12;
    }

    public final int[] toArray() {
        int[] elements = new int[this.length];
        int copied = 0;
        while (copied < this.length) {
            int bite = Math.min(this.length - copied, 1024);
            System.arraycopy(this.pages.get(copied >> 10), 0, elements, copied, bite);
            copied += bite;
        }
        return elements;
    }
}

