/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.snapshot.views;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.NumberFormat;
import java.io.File;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.SnapshotInfo;
import org.eclipse.mat.snapshot.UnreachableObjectsHistogram;
import org.eclipse.mat.ui.accessibility.AccessibleCompositeAdapter;
import org.eclipse.mat.ui.internal.views.NotesView;
import org.eclipse.mat.ui.snapshot.editor.ISnapshotEditorInput;
import org.eclipse.mat.ui.snapshot.views.Messages;
import org.eclipse.mat.ui.util.Copy;
import org.eclipse.mat.util.MessageUtil;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public abstract class SnapshotOutlinePage
extends Page
implements IContentOutlinePage {
    protected TreeViewer treeViewer;

    public void createControl(Composite parent) {
        this.treeViewer = new TreeViewer(parent, 66306);
        this.createColumns();
        AccessibleCompositeAdapter.access(this.treeViewer.getTree());
        this.treeViewer.getTree().setLinesVisible(true);
        this.treeViewer.getTree().setHeaderVisible(true);
        this.treeViewer.setContentProvider((IContentProvider)new OutlineContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new OutlineLabelProvider());
        Action copyAction = new Action(){

            public void run() {
                Copy.copyToClipboard((Control)SnapshotOutlinePage.this.treeViewer.getTree());
            }
        };
        this.getSite().getActionBars().setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)copyAction);
        this.getSite().getActionBars().updateActionBars();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.mat.ui.help.workbench_heapdumpdetails");
        this.updateSnapshotInput();
    }

    protected void createColumns() {
        TreeColumn column = new TreeColumn(this.treeViewer.getTree(), 16384);
        column.setText(Messages.col_property);
        column.setWidth(160);
        column = new TreeColumn(this.treeViewer.getTree(), 16384);
        column.setText(Messages.col_file);
        column.setWidth(80);
    }

    protected void updateSnapshotInput() {
        ArrayList<Object> elements = new ArrayList<Object>();
        SnapshotInfo info = this.getSnapshot();
        if (info != null) {
            int p;
            SnapshotInfo bInfo = this.getBaseline();
            if (bInfo == null) {
                bInfo = new SnapshotInfo(null, null, null, 0, null, 0, 0, 0, 0, 0L);
            }
            String filename = (p = info.getPath().lastIndexOf(File.separatorChar)) >= 0 ? info.getPath().substring(p + 1) : info.getPath();
            String bFilename = null;
            if (bInfo.getPath() != null) {
                p = bInfo.getPath().lastIndexOf(File.separatorChar);
                bFilename = p >= 0 ? bInfo.getPath().substring(p + 1) : bInfo.getPath();
            }
            elements.add(new Label(Messages.resource, filename, bFilename));
            Category category = new Category(Messages.general_info);
            elements.add(category);
            category.addChild(new Label(Messages.format, info.getProperty("$heapFormat"), bInfo.getProperty("$heapFormat")));
            category.addChild(new Label(Messages.jvm_version, info.getJvmInfo(), bInfo.getJvmInfo()));
            category.addChild(new Label(Messages.time, info.getCreationDate(), bInfo.getCreationDate()));
            category.addChild(new Label(Messages.date, info.getCreationDate(), bInfo.getCreationDate()));
            category.addChild(new Label(Messages.identifier_size, info.getIdentifierSize(), bInfo.getIdentifierSize()));
            if (info.getIdentifierSize() == 8 || bInfo.getIdentifierSize() == 8) {
                Boolean useCompressedOops = (Boolean)info.getProperty("$useCompressedOops");
                Boolean buseCompressedOops = (Boolean)bInfo.getProperty("$useCompressedOops");
                if (useCompressedOops != null || buseCompressedOops != null) {
                    category.addChild(new Label(Messages.use_compressed_oops, useCompressedOops != null ? useCompressedOops.toString() : "", buseCompressedOops != null ? buseCompressedOops.toString() : ""));
                }
            }
            category.addChild(new Label(Messages.file_path, info.getPath(), bInfo.getPath()));
            Double fileLength = (double)new File(info.getPath()).length() / 1048576.0;
            Double bFileLength = bInfo.getPath() != null ? Double.valueOf((double)new File(bInfo.getPath()).length() / 1048576.0) : null;
            category.addChild(new Label(Messages.file_length, fileLength, bFileLength));
            if (info.getProperty("$runtimeId") != null || bInfo.getProperty("$runtimeId") != null) {
                category.addChild(new Label(Messages.identifier, info.getProperty("$runtimeId"), bInfo.getProperty("$runtimeId")));
            }
            Serializable discard_ratio = info.getProperty("discard_ratio");
            Serializable bDiscard_ratio = bInfo.getProperty("discard_ratio");
            if (discard_ratio instanceof Integer && (Integer)discard_ratio != 0 || bDiscard_ratio instanceof Integer && (Integer)bDiscard_ratio != 0) {
                category.addChild(new Label(org.eclipse.mat.ui.Messages.UIPreferencePage_DiscardPercentage, discard_ratio, bDiscard_ratio));
                Serializable discard_pattern = info.getProperty("discard_pattern");
                Serializable bDiscard_pattern = bInfo.getProperty("discard_pattern");
                category.addChild(new Label(org.eclipse.mat.ui.Messages.UIPreferencePage_DiscardPattern, discard_pattern, bDiscard_pattern));
                Serializable discard_offset = info.getProperty("discard_offset");
                Serializable bDiscard_offset = bInfo.getProperty("discard_offset");
                category.addChild(new Label(org.eclipse.mat.ui.Messages.UIPreferencePage_DiscardOffset, discard_offset, bDiscard_offset));
                Serializable discard_seed = info.getProperty("discard_seed");
                Serializable bDiscard_seed = bInfo.getProperty("discard_seed");
                category.addChild(new Label(org.eclipse.mat.ui.Messages.UIPreferencePage_DiscardSeed, discard_seed, bDiscard_seed));
            }
            String note = this.getNotes(info);
            String noteb = this.getNotes(bInfo);
            if (note != null || noteb != null) {
                category.addChild(new Label(Messages.notes, note, noteb));
            }
            category = new Category(Messages.statistic_info);
            elements.add(category);
            category.addChild(new Label(Messages.heap, info.getUsedHeapSize(), bInfo.getUsedHeapSize()));
            category.addChild(new Label(Messages.number_of_objects, info.getNumberOfObjects(), bInfo.getNumberOfObjects()));
            category.addChild(new Label(Messages.number_of_classes, info.getNumberOfClasses(), bInfo.getNumberOfClasses()));
            category.addChild(new Label(Messages.number_of_classloaders, info.getNumberOfClassLoaders(), bInfo.getNumberOfClassLoaders()));
            category.addChild(new Label(Messages.number_of_gc_roots, info.getNumberOfGCRoots(), bInfo.getNumberOfGCRoots()));
            long[] u = this.unreachableObjects(info);
            long[] bU = this.unreachableObjects(bInfo);
            long unreachableObjects = u[0];
            long bUnreachableObjects = bU[0];
            if (unreachableObjects > 0L || bUnreachableObjects > 0L) {
                category.addChild(new Label(Messages.unreachable_heap, u[1], bU[1]));
                category.addChild(new Label(Messages.number_of_unreachable_objects, unreachableObjects, bUnreachableObjects));
            }
        } else if (this.getSnapshotPath() != null) {
            IPath path = this.getSnapshotPath();
            File osFile = path.toFile();
            elements.add(new Label(Messages.resource, path.lastSegment(), null));
            Category category = new Category(Messages.general_info);
            elements.add(category);
            category.addChild(new Label(Messages.format, null, null));
            category.addChild(new Label(Messages.jvm_version, null, null));
            category.addChild(new Label(Messages.time, new Date(osFile.lastModified()), null));
            category.addChild(new Label(Messages.date, new Date(osFile.lastModified()), null));
            category.addChild(new Label(Messages.identifier_size, null, null));
            category.addChild(new Label(Messages.file_path, path.toOSString(), null));
            Double fileLength = (double)osFile.length() / 1048576.0;
            category.addChild(new Label(Messages.file_length, fileLength, null));
            String note = this.getNotes(osFile);
            if (note != null) {
                category.addChild(new Label(Messages.notes, note, null));
            }
        }
        this.treeViewer.getTree().setRedraw(false);
        this.treeViewer.setInput(elements);
        this.treeViewer.expandAll();
        this.treeViewer.getTree().setRedraw(true);
    }

    private String getNotes(SnapshotInfo info) {
        if (info != null) {
            String notes;
            String path = info.getPath();
            String pfx = info.getPrefix();
            if (path == null) {
                return null;
            }
            if (pfx != null && info.getProperty("$runtimeId") != null) {
                return this.getNotes(new File(String.valueOf(pfx) + "index"));
            }
            if (pfx != null && (notes = this.getNotes(new File(pfx))) != null) {
                return notes;
            }
            return this.getNotes(new File(path));
        }
        return null;
    }

    private String getNotes(File snapshotFile) {
        String notes;
        try {
            notes = NotesView.readNotes(snapshotFile);
        }
        catch (UncheckedIOException e) {
            return null;
        }
        if (notes != null) {
            return notes.split("\n", 2)[0];
        }
        return null;
    }

    private long[] unreachableObjects(SnapshotInfo info) {
        long discardedObjects = 0L;
        long discardedHeap = 0L;
        Serializable unreachable = info.getProperty(UnreachableObjectsHistogram.class.getName());
        if (unreachable instanceof UnreachableObjectsHistogram) {
            UnreachableObjectsHistogram ur = (UnreachableObjectsHistogram)unreachable;
            for (UnreachableObjectsHistogram.Record r : ur.getRecords()) {
                discardedObjects += (long)r.getObjectCount();
                discardedHeap += r.getShallowHeapSize();
            }
        }
        return new long[]{discardedObjects, discardedHeap};
    }

    protected abstract IPath getSnapshotPath();

    protected abstract SnapshotInfo getSnapshot();

    protected abstract SnapshotInfo getBaseline();

    public Control getControl() {
        return this.treeViewer.getControl();
    }

    public void setFocus() {
        this.treeViewer.getControl().setFocus();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.treeViewer.addSelectionChangedListener(listener);
    }

    public ISelection getSelection() {
        return this.treeViewer.getSelection();
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.treeViewer.removeSelectionChangedListener(listener);
    }

    public void setSelection(ISelection selection) {
        this.treeViewer.setSelection(selection);
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
        pageSite.setSelectionProvider((ISelectionProvider)this);
    }

    static class Category {
        String categoryId;
        protected List<Label> children = new ArrayList<Label>();

        public Category(String categoryId) {
            this.categoryId = categoryId;
        }

        public String getCategoryId() {
            return this.categoryId;
        }

        public void addChild(Label label) {
            this.children.add(label);
        }
    }

    public static class HeapEditorOutlinePage
    extends SnapshotOutlinePage
    implements ISnapshotEditorInput.IChangeListener {
        private ISnapshotEditorInput snapshotInput;

        public HeapEditorOutlinePage(ISnapshotEditorInput input) {
            this.snapshotInput = input;
            this.snapshotInput.addChangeListener(this);
        }

        @Override
        protected void createColumns() {
            super.createColumns();
            TreeColumn column = new TreeColumn(this.treeViewer.getTree(), 16384);
            column.setText(Messages.baseline);
            column.setWidth(80);
        }

        @Override
        public void onSnapshotLoaded(ISnapshot snapshot) {
            this.updateSnapshotInput();
        }

        @Override
        public void onBaselineLoaded(ISnapshot snapshot) {
            this.updateSnapshotInput();
        }

        @Override
        protected SnapshotInfo getBaseline() {
            return this.snapshotInput.hasBaseline() ? this.snapshotInput.getBaseline().getSnapshotInfo() : null;
        }

        @Override
        protected SnapshotInfo getSnapshot() {
            if (this.snapshotInput == null) {
                return null;
            }
            return this.snapshotInput.hasSnapshot() ? this.snapshotInput.getSnapshot().getSnapshotInfo() : null;
        }

        @Override
        protected IPath getSnapshotPath() {
            if (this.snapshotInput == null) {
                return null;
            }
            return this.snapshotInput.getPath();
        }

        public void dispose() {
            if (this.snapshotInput != null) {
                this.snapshotInput.removeChangeListener(this);
                this.snapshotInput = null;
            }
            super.dispose();
        }
    }

    static class Label {
        String text;
        Object snapshotValue;
        Object baselineValue;

        public Label(String typeId, Object snapshotValue, Object baselineValue) {
            this.text = typeId;
            this.snapshotValue = snapshotValue;
            this.baselineValue = baselineValue;
        }

        public String getText() {
            return this.text;
        }

        public Object getBaselineValue() {
            return this.baselineValue;
        }

        public Object getSnapshotValue() {
            return this.snapshotValue;
        }
    }

    static class OutlineContentProvider
    implements ITreeContentProvider {
        List<Object> elements;

        OutlineContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.elements = (List)newInput;
        }

        public Object[] getElements(Object inputElement) {
            return this.elements.toArray();
        }

        public Object[] getChildren(Object parentElement) {
            return parentElement instanceof Category ? ((Category)parentElement).children.toArray() : null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof Category;
        }

        public void dispose() {
        }
    }

    static class OutlineLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        OutlineLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof Category) {
                return columnIndex == 0 ? ((Category)element).getCategoryId() : null;
            }
            if (element instanceof Label) {
                Object obj;
                Label label = (Label)element;
                if (columnIndex == 0) {
                    return label.getText();
                }
                Object object = obj = columnIndex == 1 ? label.getSnapshotValue() : label.getBaselineValue();
                if (obj == null) {
                    return null;
                }
                if (Messages.identifier_size.equals(label.getText())) {
                    int identifierSize = (Integer)obj;
                    return MessageUtil.format((String)Messages.identifier_format, (Object[])new Object[]{identifierSize});
                }
                if (obj instanceof Long || obj instanceof Integer) {
                    return ((Number)obj).longValue() == 0L ? null : NumberFormat.getInstance().format(obj);
                }
                if (obj instanceof Double) {
                    DecimalFormat format = new DecimalFormat("#,##0.0");
                    NumberFormat nf = NumberFormat.getNumberInstance();
                    if (nf instanceof DecimalFormat) {
                        DecimalFormat df = (DecimalFormat)nf;
                        df.setMinimumFractionDigits(1);
                        df.setMaximumFractionDigits(1);
                        format = df;
                    }
                    return MessageUtil.format((String)MessageUtil.format((String)Messages.size_format, (Object[])new Object[]{format.format(obj)}), (Object[])new Object[0]);
                }
                if (obj instanceof Date) {
                    return Messages.date.equals(label.getText()) ? DateFormat.getDateInstance().format(obj) : DateFormat.getTimeInstance().format(obj);
                }
                return String.valueOf(obj);
            }
            return null;
        }
    }
}

