/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.snapshot.registry;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.snapshot.extension.Subject;
import org.eclipse.mat.snapshot.extension.Subjects;
import org.eclipse.mat.util.MessageUtil;
import org.eclipse.mat.util.RegistryReader;

public abstract class SubjectRegistry<D>
extends RegistryReader<D> {
    private Map<String, D> resolvers = new HashMap<String, D>();

    public final D createDelegate(IConfigurationElement configElement) throws CoreException {
        D resolver = this.doCreateDelegate(configElement);
        String[] subjects = this.extractSubjects(resolver);
        if (subjects != null && subjects.length > 0) {
            int ii = 0;
            while (ii < subjects.length) {
                D oldResolver = this.resolvers.get(subjects[ii]);
                if (oldResolver != null) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, MessageUtil.format((String)Messages.SubjectRegistry_DuplicateResolver, (Object[])new Object[]{subjects[ii], oldResolver.getClass().getName(), resolver.getClass().getName()}));
                }
                this.resolvers.put(subjects[ii], resolver);
                ++ii;
            }
        } else {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, MessageUtil.format((String)Messages.SubjectRegistry_ErrorMsg_MissingSubjectAnnotation, (Object[])new Object[]{resolver.getClass().getName()}));
        }
        return resolver;
    }

    protected String[] extractSubjects(D instance) {
        String[] stringArray;
        Subjects subjects = instance.getClass().getAnnotation(Subjects.class);
        if (subjects != null) {
            return subjects.value();
        }
        Subject subject = instance.getClass().getAnnotation(Subject.class);
        if (subject != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = subject.value();
        } else {
            stringArray = null;
        }
        return stringArray;
    }

    protected final void removeDelegate(D delegate) {
        Iterator<D> iter = this.resolvers.values().iterator();
        while (iter.hasNext()) {
            D d = iter.next();
            if (d != delegate) continue;
            iter.remove();
        }
    }

    protected abstract D doCreateDelegate(IConfigurationElement var1) throws CoreException;

    public final D lookup(String key) {
        return this.resolvers.get(key);
    }

    public final Collection<String> getKeys() {
        return this.resolvers.keySet();
    }
}

