/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.fs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import org.eclipse.birt.core.fs.IFile;

public class LocalFile
implements IFile {
    private final File file;

    public LocalFile(File localFile) {
        this.file = localFile;
    }

    public LocalFile(URI uri) {
        this.file = uri.isAbsolute() ? new File(uri) : new File(uri.toString());
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public String getPath() {
        return this.file.getPath();
    }

    @Override
    public boolean exists() {
        return this.file.exists();
    }

    @Override
    public boolean delete() {
        return this.deleteFile(this.file);
    }

    private boolean deleteFile(File f) {
        if (f.isDirectory()) {
            File[] fileArray = f.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                this.deleteFile(child);
                ++n2;
            }
        }
        return f.delete();
    }

    @Override
    public boolean mkdirs() {
        return this.file.mkdirs();
    }

    @Override
    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    @Override
    public IFile[] listFiles() {
        if (!this.file.exists() || !this.file.isDirectory()) {
            return new IFile[0];
        }
        File[] files = this.file.listFiles();
        IFile[] result = new IFile[files.length];
        int i = 0;
        while (i < files.length) {
            result[i] = new LocalFile(files[i]);
            ++i;
        }
        return result;
    }

    @Override
    public OutputStream createOutputStream() throws IOException {
        return new FileOutputStream(this.file);
    }

    @Override
    public InputStream createInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    @Override
    public URL toURL() throws IOException {
        return this.file.toURI().toURL();
    }

    @Override
    public boolean isAbsolute() {
        return this.file.isAbsolute();
    }

    @Override
    public IFile getParent() {
        return new LocalFile(this.file.getParentFile());
    }
}

