/*
 * Decompiled with CFR 0.152.
 */
package traceability.presentation.table;

import com.google.common.primitives.Ints;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerRow;
import org.eclipse.nebula.widgets.xviewer.IXViewerFactory;
import org.eclipse.nebula.widgets.xviewer.XViewer;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import traceability.LogEntry;
import traceability.Trace;
import traceability.TraceabilityFactory;
import traceability.presentation.TraceUtils;
import traceability.presentation.TraceabilityEditor;
import traceability.presentation.TraceabilityEditorPlugin;
import traceability.presentation.Tracing;
import traceability.presentation.table.GroupItem;
import traceability.presentation.table.TraceabilityMouseListener;
import traceability.presentation.table.TraceabilityToolTipSupport;
import traceability.presentation.table.TraceabilityViewerContentProvider;
import traceability.presentation.table.TraceabilityViewerFactory;
import traceability.presentation.table.TraceabilityViewerLabelProvider;
import traceability.presentation.table.TracebilityColumn;
import traceability.presentation.table.images.TraceabilityImageCache;

public class TraceabilityViewer
extends XViewer {
    private TreeItem hoverItem;
    Object hoverElement;
    XViewerColumn hoverCol;
    public Set<Object> initialExpanded = new HashSet<Object>();
    public Button treeButton;
    public Button allButton;
    public Button errButton;
    public Button equalButton;
    public Button unequalButton;
    public Button newButton;
    public String filterText = "";
    public String searchText = "";
    public List<Object> searchRows = new ArrayList<Object>();
    public int searchRowsIndex = -1;
    public boolean regex;
    public boolean searchregex;
    private IViewerProvider activeView;
    public Button plusButton;
    public Button minusButton;
    private TraceabilityMouseListener traceabilityMouseListener;
    TraceabilityEditor traceabilityEditor;
    public Tracing tracing = new Tracing();

    public TraceabilityViewer(IViewerProvider activeView, final Composite composite, int style, TraceabilityViewerFactory fact) {
        super(composite, style, (IXViewerFactory)fact);
        this.activeView = activeView;
        this.traceabilityEditor = (TraceabilityEditor)this.activeView;
        this.getTree().addListener(41, new Listener(){

            public void handleEvent(Event event) {
                event.height = 35;
            }
        });
        this.getTree().addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                Point point = new Point(e.x, e.y);
                TreeItem item = TraceabilityViewer.this.getItemUnderMouseClick(point);
                TreeColumn col = TraceabilityViewer.this.getColumnUnderMouseClick(point);
                if (item != null && col != null) {
                    if (TraceabilityViewer.this.hoverItem != null && !TraceabilityViewer.this.hoverItem.isDisposed() && TraceabilityViewer.this.hoverElement != null && item.getData() != TraceabilityViewer.this.hoverElement) {
                        TraceabilityViewer.this.hoverElement = null;
                        TraceabilityViewer.this.updateItem((Widget)TraceabilityViewer.this.hoverItem, TraceabilityViewer.this.hoverItem.getData());
                    }
                    TraceabilityViewer.this.hoverElement = item.getData();
                    TraceabilityViewer.this.hoverItem = item;
                    TraceabilityViewer.this.hoverCol = (XViewerColumn)col.getData();
                    Rectangle bounds = item.getTextBounds(TraceabilityViewer.this.getColumnNumberUnderMouseClick(point).intValue());
                    if (TraceabilityViewer.this.getCellData(TraceabilityViewer.this.hoverCol, TraceabilityViewer.this.hoverElement) != null && bounds.contains(point) && TraceabilityViewer.this.traceabilityMouseListener.shiftBeingHeld(e)) {
                        composite.getShell().setCursor(new Cursor((Device)composite.getDisplay(), 21));
                    } else {
                        composite.getShell().setCursor(new Cursor((Device)composite.getDisplay(), 0));
                    }
                    TraceabilityViewer.this.updateItem((Widget)TraceabilityViewer.this.hoverItem, TraceabilityViewer.this.hoverItem.getData());
                }
            }
        });
        this.getTree().addMouseTrackListener(new MouseTrackListener(){

            public void mouseHover(MouseEvent e) {
            }

            public void mouseExit(MouseEvent e) {
                if (TraceabilityViewer.this.hoverItem != null && !TraceabilityViewer.this.hoverItem.isDisposed() && TraceabilityViewer.this.hoverElement != null) {
                    TraceabilityViewer.this.hoverElement = null;
                    TraceabilityViewer.this.updateItem((Widget)TraceabilityViewer.this.hoverItem, TraceabilityViewer.this.hoverItem.getData());
                    TraceabilityViewer.this.hoverItem = null;
                    composite.getShell().setCursor(new Cursor((Device)composite.getDisplay(), 0));
                }
            }

            public void mouseEnter(MouseEvent e) {
            }
        });
        TraceabilityToolTipSupport.enableFor((ColumnViewer)this);
    }

    public Object getPreviousElement(Object element) {
        TreeItem item = (TreeItem)this.findItem(element);
        if (item == null) {
            return null;
        }
        ViewerRow above = this.getViewerRowFromItem((Widget)item).getNeighbor(1, false);
        if (above != null) {
            return above.getItem().getData();
        }
        return null;
    }

    public boolean handleLeftShiftClick(TreeColumn treeColumn, TreeItem treeItem) {
        if (treeItem.getData() instanceof Object) {
            Object element = TraceabilityViewer.getRedirectedElement(treeItem.getData());
            TraceabilityViewerLabelProvider viewer = (TraceabilityViewerLabelProvider)this.getLabelProvider();
            XViewerColumn xCol = (XViewerColumn)treeColumn.getData();
            try {
                viewer.getColumnText(element, xCol, -1);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Object toOpen = this.getCellData(xCol, element);
            if (toOpen instanceof LogEntry) {
                LogEntry logEntry = (LogEntry)toOpen;
                for (EObject eObject : logEntry.getParticipants()) {
                    toOpen = eObject;
                }
            }
            this.traceabilityEditor.openElement(element, xCol, toOpen);
        }
        return false;
    }

    <T> T findType(Class<T> cls, Object element) {
        return this.tracing.findType(cls, TraceabilityViewer.getRedirectedElement(element));
    }

    public boolean isHovered(Object element, XViewerColumn xCol) {
        return this.hoverElement == element && xCol.equals((Object)this.hoverCol);
    }

    protected void internalInitializeTree(Control widget) {
        super.internalInitializeTree(widget);
    }

    public Object getCellData(XViewerColumn viewerColumn, Object element) {
        element = TraceabilityViewer.getRedirectedElement(element);
        viewerColumn = this.traceabilityEditor.getRedirectedColumn(element, viewerColumn);
        return this.traceabilityEditor.getCellData(viewerColumn, element);
    }

    public static Object getRedirectedElement(Object element) {
        if (element instanceof GroupItem) {
            GroupItem groupItem = (GroupItem)element;
            element = groupItem.element;
        }
        return element;
    }

    public void updateMenuActionsForHeader() {
        IContributionItem[] iContributionItemArray = this.getMenuManager().getItems();
        int n = iContributionItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem item = iContributionItemArray[n2];
            if (item instanceof ActionContributionItem) {
                ActionContributionItem actionContributionItem = (ActionContributionItem)item;
                String text = actionContributionItem.getAction().getText();
                if ("Unique Values".equals(text) || "View Selected Cell Data".equals(text) || "Add Computed Column".equals(text) || "Sum Selected for Column".equals(text) || "Filter By Column".equals(text) || "Filter by Value".equals(text) || "Clear All Filters".equals(text)) {
                    this.getMenuManager().remove(item);
                }
                if (text.startsWith("Copy Selected Column") && !text.startsWith("Copy Selected Column of Selected Rows")) {
                    actionContributionItem.getAction().setText(text.replace("Copy Selected Column", "Copy Selected Column of Selected Rows"));
                }
            }
            ++n2;
        }
        this.getMenuManager().add((IAction)new Action("Expand All"){

            public void run() {
                TraceabilityViewer.this.expandAll();
            }
        });
        this.getMenuManager().add((IAction)new Action("Collapse All"){

            public void run() {
                TraceabilityViewer.this.collapseAll();
            }
        });
    }

    public void updateMenuActionsForTable() {
        this.updateMenuActionsForHeader();
        TreeColumn treeCol = this.getRightClickSelectedColumn();
        final XViewerColumn xCol = (XViewerColumn)treeCol.getData();
        TreeItem treeItem = this.getRightClickSelectedItem();
        if (treeItem == null || !this.tracing.diffOfElement.isEmpty()) {
            return;
        }
        Object element = TraceabilityViewer.getRedirectedElement(treeItem.getData());
        EObject eObject = this.traceabilityEditor.getColumnSpecificElement(xCol, element);
        Trace trace = this.tracing.getAnyTrace(eObject);
        EObject fnarrowDown = this.traceabilityEditor.getNarrowDown(xCol, element);
        final TraceabilityEditor ed = (TraceabilityEditor)this.activeView;
        Action action = this.traceabilityEditor.manageComment(xCol, eObject, trace, fnarrowDown);
        if (action != null) {
            this.getMenuManager().add((IAction)action);
        }
        if (this.traceabilityEditor.getCols().contains(xCol)) {
            TraceabilityViewerLabelProvider viewer = (TraceabilityViewerLabelProvider)this.getLabelProvider();
            final String label = viewer.getColumnText(element, xCol, -1);
            final Object cellData = this.getCellData(xCol, element);
            if (label != null && label.length() > 1 && cellData instanceof EObject) {
                this.getMenuManager().add((IAction)new Action("Select \"" + TraceUtils.withoutTags(label) + "\" for tracing"){

                    public void run() {
                        ed.newTraceSource = (EObject)cellData;
                        ed.newTraceSourceLabel = label;
                        ed.newTraceSourceColumn = xCol;
                    }
                });
            }
            if (ed.newTraceSource != null && label != null && label.length() > 1 && cellData instanceof EObject && cellData != ed.newTraceSource && ed.newTraceSourceColumn != xCol) {
                this.getMenuManager().add((IAction)new Action("Create trace between \"" + ed.newTraceSourceLabel + "\" and \"" + label + "\""){

                    public void run() {
                        Trace tc = TraceabilityFactory.eINSTANCE.createTrace();
                        tc.setDescription("Hand-crafted trace");
                        ((Resource)ed.newTraceSource.eResource().getResourceSet().getResources().get(0)).getContents().add((Object)tc);
                        if (TraceabilityViewer.this.traceabilityEditor.getCols().indexOf(xCol) > TraceabilityViewer.this.traceabilityEditor.getCols().indexOf(ed.newTraceSourceColumn)) {
                            tc.getSource().add((Object)ed.newTraceSource);
                            tc.getTarget().add((Object)((EObject)cellData));
                        } else {
                            tc.getSource().add((Object)((EObject)cellData));
                            tc.getTarget().add((Object)ed.newTraceSource);
                        }
                        try {
                            tc.eResource().save(null);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        ((TraceabilityEditor)TraceabilityViewer.this.activeView).updateTables();
                    }
                });
            }
        }
    }

    public void updateRows() {
        long started = new Date().getTime();
        if (this.unequalButton != null) {
            this.unequalButton.setSelection(this.traceabilityEditor.traceabilityFilters_NEQ);
            this.equalButton.setSelection(this.traceabilityEditor.traceabilityFilters_EQ);
            this.minusButton.setSelection(this.traceabilityEditor.traceabilityFilters_MINUS);
            this.plusButton.setSelection(this.traceabilityEditor.traceabilityFilters_PLUS);
        }
        this.errButton.setSelection(this.traceabilityEditor.traceabilityFilters_ERR);
        this.allButton.setSelection(this.traceabilityEditor.traceabilityFilters_ALL);
        this.treeButton.setSelection(this.traceabilityEditor.traceabilityFilters_TREE);
        TraceabilityViewerContentProvider traceabilityViewerContentProvider = (TraceabilityViewerContentProvider)this.getContentProvider();
        traceabilityViewerContentProvider.parents = null;
        traceabilityViewerContentProvider.parentOf.clear();
        traceabilityViewerContentProvider.groupOf.clear();
        traceabilityViewerContentProvider.allElements.clear();
        if (this.activeView.getViewer() != this) {
            this.setInput(null);
        }
        this.refresh();
        long ended = new Date().getTime();
        if (this.getInput() != null) {
            System.out.println("refresh took " + (ended - started));
        }
    }

    public void setFilterText(String filterText, boolean regex) {
        this.filterText = filterText;
        this.regex = regex;
        this.updateRows();
    }

    public void setSearchText(String filterText, boolean regex) {
        this.searchText = filterText;
        this.searchregex = regex;
        this.searchRowsIndex = -1;
        this.update(this.searchRows.toArray(), null);
        this.searchRows.clear();
        block0: for (Object element : ((TraceabilityViewerContentProvider)this.getContentProvider()).allElements) {
            for (XViewerColumn xCol : this.getCustomizeMgr().getCurrentTableColumns()) {
                String text;
                if (!xCol.isShow() || TraceabilityViewer.findText(text = ((TraceabilityViewerLabelProvider)this.getLabelProvider()).getColumnText(element, xCol, -1), this.searchText, this.searchregex) == null) continue;
                this.searchRows.add(element);
                continue block0;
            }
        }
        this.update(this.searchRows.toArray(), null);
        this.getTree().redraw();
    }

    public void refresh() {
        TreeColumn[] treeColumnArray = this.getTree().getColumns();
        int n = treeColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn col = treeColumnArray[n2];
            XViewerColumn xcol = (XViewerColumn)col.getData();
            if (this.getCustomizeMgr().getSortXCols().contains(xcol)) {
                String base = "platform:/plugin/" + TraceabilityEditorPlugin.getPlugin().getBundle().getSymbolicName() + "/icons/";
                col.setImage(TraceabilityImageCache.getImage(String.valueOf(base) + (xcol.isSortForward() ? "sort-descending-icon.png" : "sort-ascending-icon.png")));
            } else {
                col.setImage(null);
            }
            ++n2;
        }
        super.refresh();
    }

    public Object getRepresentativeElement(EObject eObject4) {
        TraceabilityViewerContentProvider cp = (TraceabilityViewerContentProvider)this.getContentProvider();
        EObject eObject = eObject4;
        while (eObject != null) {
            if (this.tracing.errorsRev.containsKey(eObject)) {
                eObject = this.tracing.errorsRev.get(eObject);
            }
            if (cp.groupOf.containsKey(eObject)) {
                return cp.groupOf.get(eObject);
            }
            if (cp.parents.contains(eObject) || cp.parentOf.containsKey(eObject)) {
                return eObject;
            }
            eObject = this.tracing.backward.get(eObject);
        }
        eObject = eObject4;
        return eObject4;
    }

    public void setSelection(ISelection selection, boolean reveal) {
        if (selection instanceof StructuredSelection) {
            StructuredSelection structuredSelection = (StructuredSelection)selection;
            ArrayList<Object> newList = new ArrayList<Object>();
            for (Object object : structuredSelection.toList()) {
                if (object instanceof EObject) {
                    EObject eObject = (EObject)object;
                    newList.add(this.getRepresentativeElement(eObject));
                    continue;
                }
                newList.add(object);
            }
            selection = new StructuredSelection(newList);
        }
        super.setSelection(selection, reveal);
    }

    public void updateStatusLabel() {
        if (this.getCustomizeMgr().isLoading()) {
            int index = 0;
            TreeColumn[] treeColumnArray = this.getTree().getColumns();
            int n = treeColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeColumn col = treeColumnArray[n2];
                TracebilityColumn tcol = (TracebilityColumn)((Object)col.getData());
                if (tcol.isAlwaysShow()) {
                    col.setMoveable(false);
                    final Integer iIndex = index;
                    Listener listener = new Listener(){

                        public void handleEvent(Event e) {
                            ArrayList<Integer> order = new ArrayList<Integer>(Ints.asList((int[])TraceabilityViewer.this.getTree().getColumnOrder()));
                            order.remove(iIndex);
                            order.add(0, iIndex);
                            TraceabilityViewer.this.getTree().setColumnOrder(Ints.toArray(order));
                        }
                    };
                    col.addListener(10, listener);
                    listener.handleEvent(null);
                }
                ++index;
                ++n2;
            }
        }
        super.updateStatusLabel();
    }

    protected void createSupportWidgets(Composite parent) {
        super.createSupportWidgets(parent);
        this.traceabilityMouseListener = new TraceabilityMouseListener(this);
        this.getTree().addMouseListener((MouseListener)this.traceabilityMouseListener);
    }

    public TreeColumn getClickedColumn() {
        MouseEvent event = this.traceabilityMouseListener.getLeftClickEvent();
        TreeColumn column = this.getColumnUnderMouseClick(new Point(event.x, event.y));
        return column;
    }

    public static Point findText(String s, String searchText, boolean searchregex) {
        int start;
        Point found = null;
        if (searchregex) {
            Pattern regex = null;
            try {
                regex = Pattern.compile(searchText, 2);
                Matcher m = regex.matcher(s);
                if (m.find()) {
                    found = new Point(m.start(), m.end());
                }
            }
            catch (PatternSyntaxException patternSyntaxException) {}
        } else if (!searchText.trim().equals("") && (start = s.indexOf(searchText)) != -1) {
            found = new Point(start, start + searchText.length());
        }
        return found;
    }

    private static String firstUpper(String s) {
        return String.valueOf(s.substring(0, 1).toUpperCase()) + s.substring(1);
    }
}

