/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.tests;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.mdht.uml.cda.AssignedAuthor;
import org.eclipse.mdht.uml.cda.Author;
import org.eclipse.mdht.uml.cda.CDAFactory;
import org.eclipse.mdht.uml.cda.ClinicalDocument;
import org.eclipse.mdht.uml.cda.Encounter;
import org.eclipse.mdht.uml.cda.LegalAuthenticator;
import org.eclipse.mdht.uml.cda.Observation;
import org.eclipse.mdht.uml.cda.Organizer;
import org.eclipse.mdht.uml.cda.Participant2;
import org.eclipse.mdht.uml.cda.Patient;
import org.eclipse.mdht.uml.cda.PatientRole;
import org.eclipse.mdht.uml.cda.Person;
import org.eclipse.mdht.uml.cda.RecordTarget;
import org.eclipse.mdht.uml.cda.RelatedSubject;
import org.eclipse.mdht.uml.cda.Section;
import org.eclipse.mdht.uml.cda.Subject;
import org.eclipse.mdht.uml.cda.SubjectPerson;
import org.eclipse.mdht.uml.cda.util.CDAUtil;
import org.eclipse.mdht.uml.hl7.datatypes.BL;
import org.eclipse.mdht.uml.hl7.datatypes.CE;
import org.eclipse.mdht.uml.hl7.datatypes.CS;
import org.eclipse.mdht.uml.hl7.datatypes.DatatypesFactory;
import org.eclipse.mdht.uml.hl7.datatypes.ED;
import org.eclipse.mdht.uml.hl7.datatypes.II;
import org.eclipse.mdht.uml.hl7.datatypes.TS;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SDTCExtensionTest {
    private static final String DDC_CODESYSTEM_VALUE = "2.16.840.1.113883.12.112";
    private static final String DDC_CODESYSTEMNAME_VALUE = "HL7 Discharge Disposition";
    private static final String DDC_CODE_VALUE = "42";
    private static final String ERROR_DDC_NO_DATA = "Error: No CE data was found in the external document for sdtc:dischargeDispositionCode. It is likley an empty element.";
    private static final String ERROR_DDC_NO_CODE = "Error: No code was found in the external document for sdtc:dischargeDispositionCode.";
    private static final String ERROR_DDC_NO_ELEMENT = "Error: No sdtc:dischargeDispositionCode element exists in the external document.";
    private static final String DECTIME_TS_VALUE = "1967";
    private static final boolean DECIND_BL_VALUE = true;
    private static final String ID_ROOT_VALUE = "root";
    private static final String ID_EXT_VALUE = "extension";
    private static final String ID_AAN_VALUE = "assigningAuthorityName";
    private static final boolean ID_DISP_VALUE = false;
    private static final String BT_TS_VALUE = "19880907";
    private static final String RACE_CODE_VALUE = "1002-5";
    private static final String RACE_CODESYSTEM_VALUE = "2.16.840.1.113883.6.238";
    private static final String RACE_CODESYSTEMNAME_VALUE = "RACE_CODESYSTEMNAME_VALUE";
    private static final String ERROR_RC_NO_DATA = "Error: No CE data was found in the external document for sdtc:raceCode.";
    private static final String ERROR_RC_NO_CODE = "Error: No code was found in the external document for sdtc:raceCode.";
    private static final String ERROR_RC_NO_ELEMENT = "Error: No sdtc:raceCode element exists in the external document. It is likley an empty element.";
    private static final String MU2_DOC_VALID = "resources/CCDA_CCD_b1_Amb_SDTC.xml";

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    private CE extractDischargeDispositionCECodes(ClinicalDocument doc) {
        CE ceToReturn = DatatypesFactory.eINSTANCE.createCE();
        ceToReturn.setCode(ERROR_DDC_NO_ELEMENT);
        block0: for (Section sec : doc.getSections()) {
            for (Encounter enc : sec.getEncounters()) {
                if (enc.getSDTCDischargeDispositionCodes().isEmpty()) continue;
                ceToReturn = (CE)enc.getSDTCDischargeDispositionCodes().get(0);
                if (ceToReturn.getCode() == null && ceToReturn.getCodeSystemName() == null && ceToReturn.getCodeSystem() == null) {
                    ceToReturn.setCode(ERROR_DDC_NO_DATA);
                    continue block0;
                }
                if (ceToReturn.getCode() != null || ceToReturn.getCodeSystemName() == null || ceToReturn.getCodeSystem() == null) continue block0;
                ceToReturn.setCode(ERROR_DDC_NO_CODE);
                continue block0;
            }
        }
        return ceToReturn;
    }

    private SubjectPerson findSubjectPerson(ClinicalDocument doc, String curSDTCname) {
        RelatedSubject relsub;
        SubjectPerson subper;
        Subject sub = null;
        ArrayList<Organizer> organizers = new ArrayList<Organizer>();
        for (Section sec : doc.getSections()) {
            for (Organizer org : sec.getOrganizers()) {
                organizers.add(org);
            }
        }
        for (Organizer organizer : organizers) {
            if (organizer.getSubject() == null) continue;
            sub = organizer.getSubject();
            break;
        }
        if (sub == null) {
            Assert.fail((String)"Unable to capture any non-null subject data. Ensure the document contains subject data and try again.");
        }
        if ((subper = (relsub = sub.getRelatedSubject()).getSubject()) == null) {
            Assert.fail((String)("Unable to find/capture any non-null data. Ensure " + curSDTCname + " data exists in the document."));
        }
        return subper;
    }

    private BL extractDeceasedIndBLData(ClinicalDocument doc) {
        SubjectPerson subper = this.findSubjectPerson(doc, "sdtc:deceasedInd");
        BL blToReturn = subper.getSDTCDeceasedInd();
        return blToReturn;
    }

    private TS extractDeceasedTimeTSData(ClinicalDocument doc) {
        SubjectPerson subper = this.findSubjectPerson(doc, "sdtc:deceasedTime");
        TS tsToReturn = subper.getSDTCDeceasedTime();
        return tsToReturn;
    }

    private EList<II> extractIdIIData(ClinicalDocument doc) {
        SubjectPerson subper = this.findSubjectPerson(doc, "sdtc:id");
        EList iiListToReturn = subper.getSDTCIds();
        Assert.assertFalse((String)"sdtc II data could not be collected. Ensure there is an sdtc:id element within the document and try the test again.", (boolean)iiListToReturn.isEmpty());
        return iiListToReturn;
    }

    private CE extractRaceCodeCECodes(ClinicalDocument doc) {
        CE ceToReturn = DatatypesFactory.eINSTANCE.createCE();
        ceToReturn.setCode(ERROR_RC_NO_ELEMENT);
        for (RecordTarget rectar : doc.getRecordTargets()) {
            Patient pat;
            PatientRole patrole;
            if (rectar.getPatientRole() == null || (patrole = rectar.getPatientRole()).getPatient() == null || (pat = patrole.getPatient()).getSDTCRaceCodes().isEmpty()) continue;
            ceToReturn = (CE)pat.getSDTCRaceCodes().get(0);
            if (ceToReturn.getCode() == null && ceToReturn.getCodeSystemName() == null && ceToReturn.getCodeSystem() == null) {
                ceToReturn.setCode(ERROR_RC_NO_DATA);
                break;
            }
            if (ceToReturn.getCode() != null || ceToReturn.getCodeSystemName() == null || ceToReturn.getCodeSystem() == null) break;
            ceToReturn.setCode(ERROR_RC_NO_CODE);
            break;
        }
        return ceToReturn;
    }

    private TS extractBirthTimeTSData(ClinicalDocument doc) {
        TS tsToReturn = null;
        for (Section section : doc.getSections()) {
            for (Observation obsevation : section.getObservations()) {
                for (Participant2 p2 : obsevation.getParticipants()) {
                    if (p2.getParticipantRole() == null || p2.getParticipantRole().getPlayingEntity() == null || p2.getParticipantRole().getPlayingEntity().getSDTCBirthTime() == null) continue;
                    return p2.getParticipantRole().getPlayingEntity().getSDTCBirthTime();
                }
            }
        }
        if (tsToReturn == null) {
            Assert.fail((String)"Unable to find/capture any non-null data. Ensure sdtc:birthTime data exists in the document.");
        }
        return tsToReturn;
    }

    private void populateEncounter(CE code, Encounter enc, String codeValue, String codeSystemValue, String codeSystemNameValue) {
        code.setCode(codeValue);
        code.setCodeSystem(codeSystemValue);
        code.setCodeSystemName(codeSystemNameValue);
        enc.getSDTCDischargeDispositionCodes().add((Object)code);
    }

    private boolean serializeDischargeDispositionCodeSnippet(Encounter enc, String msg) {
        try {
            System.out.println(msg);
            CDAUtil.saveSnippet((EObject)EcoreUtil.copy((EObject)enc), (OutputStream)System.out);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private boolean serializeDocument(ClinicalDocument doc, String msg) {
        try {
            System.out.println(msg);
            CDAUtil.save((ClinicalDocument)doc, (OutputStream)System.out);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private ClinicalDocument deserializeExternalDocument(ClinicalDocument doc, String curFile) {
        try {
            doc = CDAUtil.load((InputStream)new FileInputStream(curFile));
            System.out.println("\n\n...Running Deserialization");
        }
        catch (FileNotFoundException eFileNotFound) {
            eFileNotFound.printStackTrace();
            Assert.fail((String)"XML document not Found. Cannot complete test.");
        }
        catch (Exception eGeneral) {
            eGeneral.printStackTrace();
            Assert.fail((String)"Failed to load XML document. Cannot complete test.");
        }
        return doc;
    }

    @Test
    public void testDischargeDispositionCodeSerializationOfSnippet() {
        CE sdtcCode = DatatypesFactory.eINSTANCE.createCE();
        Encounter encounter = CDAFactory.eINSTANCE.createEncounter();
        this.populateEncounter(sdtcCode, encounter, DDC_CODE_VALUE, DDC_CODESYSTEM_VALUE, "HL7 Discharge Disposition Snippet Only");
        if (!this.serializeDischargeDispositionCodeSnippet(encounter, "\n\n---testDischargeDispositionCodeSerialization extension snippet serialization---")) {
            Assert.fail((String)"Unable to save/serialize sdtc:dischargeDispositionCode as a snippet.");
        }
        Assert.assertEquals((String)"The code has changed after serialization.", (Object)DDC_CODE_VALUE, (Object)sdtcCode.getCode());
        Assert.assertEquals((String)"The codeSystem has changed after serialization.", (Object)DDC_CODESYSTEM_VALUE, (Object)sdtcCode.getCodeSystem());
        Assert.assertEquals((String)"The codeSystemName has changed after serialization.", (Object)"HL7 Discharge Disposition Snippet Only", (Object)sdtcCode.getCodeSystemName());
    }

    @Test
    public void testDischargeDispositionCodeSerializationOfGeneratedDoc() {
        ClinicalDocument clinicalDocument = CDAFactory.eINSTANCE.createClinicalDocument();
        CE sdtcCode = DatatypesFactory.eINSTANCE.createCE();
        Encounter encounter = CDAFactory.eINSTANCE.createEncounter();
        Section section = CDAFactory.eINSTANCE.createSection();
        this.populateEncounter(sdtcCode, encounter, "18", DDC_CODESYSTEM_VALUE, "HL7 Discharge Disposition Generated Document");
        section.addEncounter(encounter);
        clinicalDocument.addSection(section);
        if (!this.serializeDocument(clinicalDocument, "\n\n---testDischargeDispositionCodeSerializationOfGeneratedDoc extension document serialization---")) {
            Assert.fail((String)"Unable to save/serialize sdtc:dischargeDispositionCode within a generated document.");
        }
        Assert.assertEquals((String)"The code has changed after serialization.", (Object)"18", (Object)((CE)encounter.getSDTCDischargeDispositionCodes().get(0)).getCode());
        Assert.assertEquals((String)"The codeSystem has changed after serialization.", (Object)DDC_CODESYSTEM_VALUE, (Object)((CE)encounter.getSDTCDischargeDispositionCodes().get(0)).getCodeSystem());
        Assert.assertEquals((String)"The codeSystemName has changed after serialization.", (Object)"HL7 Discharge Disposition Generated Document", (Object)((CE)encounter.getSDTCDischargeDispositionCodes().get(0)).getCodeSystemName());
    }

    @Test
    public void testDeceasedIndSerializationOfGeneratedDoc() {
        ClinicalDocument clinicalDocument = CDAFactory.eINSTANCE.createClinicalDocument();
        Section section = CDAFactory.eINSTANCE.createSection();
        Organizer organizer = CDAFactory.eINSTANCE.createOrganizer();
        Subject subject = CDAFactory.eINSTANCE.createSubject();
        RelatedSubject relsub = CDAFactory.eINSTANCE.createRelatedSubject();
        SubjectPerson subper = CDAFactory.eINSTANCE.createSubjectPerson();
        BL indBL = DatatypesFactory.eINSTANCE.createBL();
        indBL.setValue(Boolean.valueOf(false));
        subper.setSDTCDeceasedInd(indBL);
        relsub.setSubject(subper);
        subject.setRelatedSubject(relsub);
        organizer.setSubject(subject);
        section.addOrganizer(organizer);
        clinicalDocument.addSection(section);
        if (!this.serializeDocument(clinicalDocument, "\n\n---testDeceasedIndSerializationOfGeneratedDoc extension document serialization---")) {
            Assert.fail((String)"Unable to save/serialize sdtc:deceasedInd within a generated document.");
        }
        Assert.assertEquals((String)"The BL value has changed after serialization.", (Object)false, (Object)subper.getSDTCDeceasedInd().getValue());
    }

    @Test
    public void testPatientDeceasedIndSerializationOfGeneratedDoc() {
        ClinicalDocument clinicalDocument = CDAFactory.eINSTANCE.createClinicalDocument();
        Patient patient = CDAFactory.eINSTANCE.createPatient();
        clinicalDocument.addPatient(patient);
        BL indBL = DatatypesFactory.eINSTANCE.createBL();
        indBL.setValue(Boolean.valueOf(false));
        patient.setSDTCDeceasedInd(indBL);
        if (!this.serializeDocument(clinicalDocument, "\n\n---testDeceasedIndSerializationOfGeneratedDoc extension document serialization---")) {
            Assert.fail((String)"Unable to save/serialize sdtc:deceasedInd within a generated document.");
        }
        Assert.assertEquals((String)"The BL value has changed after serialization.", (Object)false, (Object)patient.getSDTCDeceasedInd().getValue());
    }

    @Test
    public void testPatientDeceaseTimeSerializationOfGeneratedDoc() {
        ClinicalDocument clinicalDocument = CDAFactory.eINSTANCE.createClinicalDocument();
        Patient patient = CDAFactory.eINSTANCE.createPatient();
        clinicalDocument.addPatient(patient);
        BL indBL = DatatypesFactory.eINSTANCE.createBL();
        indBL.setValue(Boolean.valueOf(false));
        patient.setSDTCDeceasedTime(DatatypesFactory.eINSTANCE.createTS("20210101"));
        if (!this.serializeDocument(clinicalDocument, "\n\n---testDeceasedIndSerializationOfGeneratedDoc extension document serialization---")) {
            Assert.fail((String)"Unable to save/serialize sdtc:deceasedTime within a generated document.");
        }
    }

    @Test
    public void testGeneratedDocStatusCodeSerialization() {
        ClinicalDocument clinicalDocument = CDAFactory.eINSTANCE.createClinicalDocument();
        clinicalDocument.setSDTCStatusCode(DatatypesFactory.eINSTANCE.createCS("STATUSCODE"));
        if (!this.serializeDocument(clinicalDocument, "\n\n---testDeceasedIndSerializationOfGeneratedDoc extension document serialization---")) {
            Assert.fail((String)"Unable to save/serialize sdtc:deceasedTime within a generated document.");
        }
    }

    @Test
    public void testPatientDescSerializationOfGeneratedDoc() {
        ClinicalDocument clinicalDocument = CDAFactory.eINSTANCE.createClinicalDocument();
        Patient patient = CDAFactory.eINSTANCE.createPatient();
        clinicalDocument.addPatient(patient);
        BL indBL = DatatypesFactory.eINSTANCE.createBL();
        indBL.setValue(Boolean.valueOf(false));
        patient.setSDTCDesc(DatatypesFactory.eINSTANCE.createED("Description"));
        if (!this.serializeDocument(clinicalDocument, "\n\n---testDeceasedIndSerializationOfGeneratedDoc extension document serialization---")) {
            Assert.fail((String)"Unable to save/serialize sdtc:deceasedTime within a generated document.");
        }
    }

    @Test
    public void testDeceasedTimeSerializationOfGeneratedDoc() {
        ClinicalDocument clinicalDocument = CDAFactory.eINSTANCE.createClinicalDocument();
        Section section = CDAFactory.eINSTANCE.createSection();
        Organizer organizer = CDAFactory.eINSTANCE.createOrganizer();
        Subject subject = CDAFactory.eINSTANCE.createSubject();
        RelatedSubject relsub = CDAFactory.eINSTANCE.createRelatedSubject();
        SubjectPerson subper = CDAFactory.eINSTANCE.createSubjectPerson();
        TS timeTS = DatatypesFactory.eINSTANCE.createTS();
        timeTS.setValue("2013");
        subper.setSDTCDeceasedTime(timeTS);
        relsub.setSubject(subper);
        subject.setRelatedSubject(relsub);
        organizer.setSubject(subject);
        section.addOrganizer(organizer);
        clinicalDocument.addSection(section);
        if (!this.serializeDocument(clinicalDocument, "\n\n---testDeceasedTimeSerializationOfGeneratedDoc extension document serialization---")) {
            Assert.fail((String)"Unable to save/serialize sdtc:deceasedTime within a generated document.");
        }
        Assert.assertEquals((String)"The TS value has changed after serialization.", (Object)"2013", (Object)subper.getSDTCDeceasedTime().getValue());
    }

    @Test
    public void testIdSerializationOfGeneratedDoc() {
        ClinicalDocument clinicalDocument = CDAFactory.eINSTANCE.createClinicalDocument();
        Section section = CDAFactory.eINSTANCE.createSection();
        Organizer organizer = CDAFactory.eINSTANCE.createOrganizer();
        Subject subject = CDAFactory.eINSTANCE.createSubject();
        RelatedSubject relsub = CDAFactory.eINSTANCE.createRelatedSubject();
        SubjectPerson subper = CDAFactory.eINSTANCE.createSubjectPerson();
        II idII = DatatypesFactory.eINSTANCE.createII();
        idII.setAssigningAuthorityName("assigningAuthorityName Generated Document");
        idII.setDisplayable(Boolean.valueOf(true));
        idII.setExtension(ID_EXT_VALUE);
        idII.setRoot(ID_ROOT_VALUE);
        subper.getSDTCIds().add((Object)idII);
        relsub.setSubject(subper);
        subject.setRelatedSubject(relsub);
        organizer.setSubject(subject);
        section.addOrganizer(organizer);
        clinicalDocument.addSection(section);
        if (!this.serializeDocument(clinicalDocument, "\n\n---testIdSerializationOfGeneratedDoc extension document serialization---")) {
            Assert.fail((String)"Unable to save/serialize sdtc:id within a generated document.");
        }
        Assert.assertEquals((String)"The root has changed after serialization.", (Object)ID_ROOT_VALUE, (Object)((II)subper.getSDTCIds().get(0)).getRoot());
        Assert.assertEquals((String)"The extension has changed after serialization.", (Object)ID_EXT_VALUE, (Object)((II)subper.getSDTCIds().get(0)).getExtension());
        Assert.assertEquals((String)"The assigningAuthorityName has changed after serialization.", (Object)"assigningAuthorityName Generated Document", (Object)((II)subper.getSDTCIds().get(0)).getAssigningAuthorityName());
        Assert.assertEquals((String)"The displayable attribute has changed after serialization.", (Object)true, (Object)((II)subper.getSDTCIds().get(0)).getDisplayable());
    }

    @Test
    public void testPersonAsPatientRelationshipSerializationOfGeneratedDoc() {
        ClinicalDocument clinicalDocument = CDAFactory.eINSTANCE.createClinicalDocument();
        Section section = CDAFactory.eINSTANCE.createSection();
        Observation obs = CDAFactory.eINSTANCE.createObservation();
        Author auth = CDAFactory.eINSTANCE.createAuthor();
        AssignedAuthor asAuth = CDAFactory.eINSTANCE.createAssignedAuthor();
        Person asPerson = CDAFactory.eINSTANCE.createPerson();
        asPerson.setSDTCAsPatientRelationship(DatatypesFactory.eINSTANCE.createED("RELATIONSHOP"));
        asAuth.setAssignedPerson(asPerson);
        auth.setAssignedAuthor(asAuth);
        obs.getAuthors().add((Object)auth);
        section.addObservation(obs);
        clinicalDocument.addSection(section);
        if (!this.serializeDocument(clinicalDocument, "\n\n---testBirthTimeSerializationOfGeneratedDoc extension document serialization---")) {
            Assert.fail((String)"Unable to save/serialize sdtc:birthTime within a generated document.");
        }
        System.out.println(asPerson.getSDTCAsPatientRelationship().getText());
        Assert.assertEquals((String)"The TS value has changed after serialization.", (Object)"RELATIONSHOP", (Object)asPerson.getSDTCAsPatientRelationship().getText());
    }

    @Test
    public void testPersonDescSerializationOfGeneratedDoc() {
        ClinicalDocument clinicalDocument = CDAFactory.eINSTANCE.createClinicalDocument();
        Section section = CDAFactory.eINSTANCE.createSection();
        Observation obs = CDAFactory.eINSTANCE.createObservation();
        Author auth = CDAFactory.eINSTANCE.createAuthor();
        AssignedAuthor asAuth = CDAFactory.eINSTANCE.createAssignedAuthor();
        Person asPerson = CDAFactory.eINSTANCE.createPerson();
        asPerson.setSDTCDesc(DatatypesFactory.eINSTANCE.createED("DESCRIPTION"));
        asAuth.setAssignedPerson(asPerson);
        auth.setAssignedAuthor(asAuth);
        obs.getAuthors().add((Object)auth);
        section.addObservation(obs);
        clinicalDocument.addSection(section);
        if (!this.serializeDocument(clinicalDocument, "\n\n---testBirthTimeSerializationOfGeneratedDoc extension document serialization---")) {
            Assert.fail((String)"Unable to save/serialize sdtc:birthTime within a generated document.");
        }
        Assert.assertEquals((String)"The TS value has changed after serialization.", (Object)"DESCRIPTION", (Object)asPerson.getSDTCDesc().getText());
    }

    @Test
    public void testRaceCodeSerializationOfGeneratedDoc() {
        ClinicalDocument clinicalDocument = CDAFactory.eINSTANCE.createClinicalDocument();
        CE raceCE = DatatypesFactory.eINSTANCE.createCE();
        Patient patient = CDAFactory.eINSTANCE.createPatient();
        raceCE.setCode("sdtc:raceCode code");
        raceCE.setCodeSystem("5.4.3.2.1");
        raceCE.setCodeSystemName("sdtc:raceCode codeSystemName");
        patient.getSDTCRaceCodes().add((Object)raceCE);
        clinicalDocument.addPatient(patient);
        if (!this.serializeDocument(clinicalDocument, "\n\n---testRaceCodeSerializationOfGeneratedDoc extension document serialization---")) {
            Assert.fail((String)"Unable to save/serialize sdtc:raceCode within a generated document.");
        }
        Assert.assertEquals((String)"The code has changed after serialization.", (Object)"sdtc:raceCode code", (Object)((CE)patient.getSDTCRaceCodes().get(0)).getCode());
        Assert.assertEquals((String)"The codeSystem has changed after serialization.", (Object)"5.4.3.2.1", (Object)((CE)patient.getSDTCRaceCodes().get(0)).getCodeSystem());
        Assert.assertEquals((String)"The codeSystemName has changed after serialization.", (Object)"sdtc:raceCode codeSystemName", (Object)((CE)patient.getSDTCRaceCodes().get(0)).getCodeSystemName());
    }

    @Test
    public void testSignatureTextSerializationOfGeneratedDoc() {
        String sigTextText = "omSJUEdmde9j44zmMiromSJUEdmde9j44zmMirdMDSsWdIJdksIJR3373jeu83";
        ClinicalDocument doc = CDAFactory.eINSTANCE.createClinicalDocument();
        ED sigText = DatatypesFactory.eINSTANCE.createED("omSJUEdmde9j44zmMiromSJUEdmde9j44zmMirdMDSsWdIJdksIJR3373jeu83");
        LegalAuthenticator la = CDAFactory.eINSTANCE.createLegalAuthenticator();
        la.setSDTCSignatureText(sigText);
        doc.setLegalAuthenticator(la);
        if (!this.serializeDocument(doc, "\n\n---testSignatureTestSerializationOfGeneratedDoc extension document serialization---")) {
            Assert.fail((String)"Unable to save/serialize sdtc:signatureText within a generated document.");
        }
        Assert.assertEquals((String)"The text has changed after serialization.", (Object)"omSJUEdmde9j44zmMiromSJUEdmde9j44zmMirdMDSsWdIJdksIJR3373jeu83", (Object)la.getSDTCSignatureText().getText());
    }

    @Test
    public void testDischargeDispositionCodeDeserialization() {
        ClinicalDocument clinicalDocument = null;
        ClinicalDocument clinicalDocumentUnchanged = null;
        clinicalDocumentUnchanged = clinicalDocument = this.deserializeExternalDocument(clinicalDocument, MU2_DOC_VALID);
        CE sdtcCode = this.extractDischargeDispositionCECodes(clinicalDocument);
        Assert.assertFalse((String)ERROR_DDC_NO_DATA, (boolean)sdtcCode.getCode().equals(ERROR_DDC_NO_DATA));
        Assert.assertFalse((String)ERROR_DDC_NO_CODE, (boolean)sdtcCode.getCode().equals(ERROR_DDC_NO_CODE));
        Assert.assertFalse((String)ERROR_DDC_NO_ELEMENT, (boolean)sdtcCode.getCode().equals(ERROR_DDC_NO_ELEMENT));
        Assert.assertNotNull((Object)sdtcCode);
        Assert.assertEquals((String)"The code in the deserialized document is not the same as the code in the original external document (or is null/did not exist in the external document).", (Object)DDC_CODE_VALUE, (Object)sdtcCode.getCode());
        Assert.assertEquals((String)"The codeSystem in the deserialized document is not the same as the codeSystem in the original external document (or is null/did not exist in the external document).", (Object)DDC_CODESYSTEM_VALUE, (Object)sdtcCode.getCodeSystem());
        Assert.assertEquals((String)"The codeSystemName in the deserialized document is not the same as the codeSystemName in the original external document (or is null/did not exist in the external document).", (Object)DDC_CODESYSTEMNAME_VALUE, (Object)sdtcCode.getCodeSystemName());
        if (!this.serializeDocument(clinicalDocument, "\n\n---testDischargeDispositionCodeDeserialization Reserialized Document---")) {
            Assert.fail((String)"Unable to reserialize sdtc:dischargeDispositionCode within a document.");
        }
        Assert.assertNotNull((Object)clinicalDocument);
        Assert.assertNotNull((Object)clinicalDocumentUnchanged);
        Assert.assertEquals((Object)clinicalDocument, (Object)clinicalDocumentUnchanged);
        CE sdtcCodeUnchanged = this.extractDischargeDispositionCECodes(clinicalDocumentUnchanged);
        Assert.assertNotNull((Object)sdtcCodeUnchanged);
        Assert.assertEquals((String)"The code has changed after de/reserialization.", (Object)sdtcCode.getCode(), (Object)sdtcCodeUnchanged.getCode());
        Assert.assertEquals((String)"The codeSystem has changed after de/rerialization.", (Object)sdtcCode.getCodeSystem(), (Object)sdtcCodeUnchanged.getCodeSystem());
        Assert.assertEquals((String)"The codeSystemName has changed after de/reserialization.", (Object)sdtcCode.getCodeSystemName(), (Object)sdtcCodeUnchanged.getCodeSystemName());
    }

    @Test
    public void testDeceasedIndDeserialization() {
        ClinicalDocument clinicalDocument = null;
        ClinicalDocument clinicalDocumentUnchanged = null;
        clinicalDocumentUnchanged = clinicalDocument = this.deserializeExternalDocument(clinicalDocument, MU2_DOC_VALID);
        BL indBL = this.extractDeceasedIndBLData(clinicalDocument);
        Assert.assertNotNull((Object)indBL);
        Assert.assertEquals((String)"The boolean value in the deserialized document is not the same as the boolean value in the original external document (or is null/did not exist in the external document).", (Object)true, (Object)indBL.getValue());
        if (!this.serializeDocument(clinicalDocument, "\n\n---testDeceasedIndDeserialization Reserialized Document---")) {
            Assert.fail((String)"Unable to reserialize sdtc:deceasedInd within a document.");
        }
        Assert.assertNotNull((Object)clinicalDocument);
        Assert.assertNotNull((Object)clinicalDocumentUnchanged);
        Assert.assertEquals((Object)clinicalDocument, (Object)clinicalDocumentUnchanged);
        BL indBLUnchanged = this.extractDeceasedIndBLData(clinicalDocumentUnchanged);
        Assert.assertNotNull((Object)indBLUnchanged);
        Assert.assertEquals((String)"The BL value has changed after de/reserialization.", (Object)indBL.getValue(), (Object)indBLUnchanged.getValue());
    }

    @Test
    public void testPatientIndDeserialization() {
        ClinicalDocument clinicalDocument = null;
        ClinicalDocument clinicalDocumentUnchanged = null;
        clinicalDocumentUnchanged = clinicalDocument = this.deserializeExternalDocument(clinicalDocument, MU2_DOC_VALID);
        BL indBL = ((Patient)clinicalDocument.getPatients().get(0)).getSDTCDeceasedInd();
        Assert.assertNotNull((Object)indBL);
        Assert.assertEquals((String)"The boolean value in the deserialized document is not the same as the boolean value in the original external document (or is null/did not exist in the external document).", (Object)true, (Object)indBL.getValue());
        if (!this.serializeDocument(clinicalDocument, "\n\n---testDeceasedIndDeserialization Reserialized Document---")) {
            Assert.fail((String)"Unable to reserialize sdtc:deceasedInd within a document.");
        }
        Assert.assertNotNull((Object)clinicalDocument);
        Assert.assertNotNull((Object)clinicalDocumentUnchanged);
        Assert.assertEquals((Object)clinicalDocument, (Object)clinicalDocumentUnchanged);
        BL indBLUnchanged = ((Patient)clinicalDocumentUnchanged.getPatients().get(0)).getSDTCDeceasedInd();
        Assert.assertNotNull((Object)indBLUnchanged);
        Assert.assertEquals((String)"The BL value has changed after de/reserialization.", (Object)indBL.getValue(), (Object)indBLUnchanged.getValue());
    }

    @Test
    public void testPatientDesceasedTimeDeserialization() {
        ClinicalDocument clinicalDocument = null;
        ClinicalDocument clinicalDocumentUnchanged = null;
        clinicalDocumentUnchanged = clinicalDocument = this.deserializeExternalDocument(clinicalDocument, MU2_DOC_VALID);
        TS ts = ((Patient)clinicalDocument.getPatients().get(0)).getSDTCDeceasedTime();
        Assert.assertNotNull((Object)ts);
        Assert.assertEquals((String)"The boolean value in the deserialized document is not the same as the boolean value in the original external document (or is null/did not exist in the external document).", (Object)DECTIME_TS_VALUE, (Object)ts.getValue());
        if (!this.serializeDocument(clinicalDocument, "\n\n---testDeceasedIndDeserialization Reserialized Document---")) {
            Assert.fail((String)"Unable to reserialize sdtc:deceasedInd within a document.");
        }
        Assert.assertNotNull((Object)clinicalDocument);
        Assert.assertNotNull((Object)clinicalDocumentUnchanged);
        Assert.assertEquals((Object)clinicalDocument, (Object)clinicalDocumentUnchanged);
    }

    @Test
    public void testPatientDescDeserialization() {
        ClinicalDocument clinicalDocument = null;
        ClinicalDocument clinicalDocumentUnchanged = null;
        clinicalDocumentUnchanged = clinicalDocument = this.deserializeExternalDocument(clinicalDocument, MU2_DOC_VALID);
        ED ed = ((Patient)clinicalDocument.getPatients().get(0)).getSDTCDesc();
        Assert.assertNotNull((Object)ed);
        Assert.assertEquals((String)"The value in the deserialized document is not the same as the value in the original external document (or is null/did not exist in the external document).", (Object)"Description", (Object)ed.getText());
        if (!this.serializeDocument(clinicalDocument, "\n\n---testDeceasedIndDeserialization Reserialized Document---")) {
            Assert.fail((String)"Unable to reserialize sdtc:deceasedInd within a document.");
        }
        Assert.assertNotNull((Object)clinicalDocument);
        Assert.assertNotNull((Object)clinicalDocumentUnchanged);
        Assert.assertEquals((Object)clinicalDocument, (Object)clinicalDocumentUnchanged);
    }

    @Test
    public void testGeneratedCodeDeserialization() {
        ClinicalDocument clinicalDocument = null;
        ClinicalDocument clinicalDocumentUnchanged = null;
        clinicalDocumentUnchanged = clinicalDocument = this.deserializeExternalDocument(clinicalDocument, MU2_DOC_VALID);
        CS cs = clinicalDocument.getSDTCStatusCode();
        Assert.assertNotNull((Object)cs);
        Assert.assertEquals((String)"The value in the deserialized document is not the same as the value in the original external document (or is null/did not exist in the external document).", (Object)"STATUSCODE", (Object)cs.getCode());
        if (!this.serializeDocument(clinicalDocument, "\n\n---testDeceasedIndDeserialization Reserialized Document---")) {
            Assert.fail((String)"Unable to reserialize sdtc:deceasedInd within a document.");
        }
        Assert.assertNotNull((Object)clinicalDocument);
        Assert.assertNotNull((Object)clinicalDocumentUnchanged);
        Assert.assertEquals((Object)clinicalDocument, (Object)clinicalDocumentUnchanged);
    }

    @Test
    public void testDeceasedTimeDeserialization() {
        ClinicalDocument clinicalDocument = null;
        ClinicalDocument clinicalDocumentUnchanged = null;
        clinicalDocumentUnchanged = clinicalDocument = this.deserializeExternalDocument(clinicalDocument, MU2_DOC_VALID);
        TS timeTS = this.extractDeceasedTimeTSData(clinicalDocument);
        Assert.assertNotNull((Object)timeTS);
        Assert.assertEquals((String)"The TS value in the deserialized document is not the same as the TS value in the original external document (or is null/did not exist in the external document).", (Object)DECTIME_TS_VALUE, (Object)timeTS.getValue());
        if (!this.serializeDocument(clinicalDocument, "\n\n---testDeceasedTimeDeserialization Reserialized Document---")) {
            Assert.fail((String)"Unable to reserialize sdtc:deceasedTime within a document.");
        }
        Assert.assertNotNull((Object)clinicalDocument);
        Assert.assertNotNull((Object)clinicalDocumentUnchanged);
        Assert.assertEquals((Object)clinicalDocument, (Object)clinicalDocumentUnchanged);
        TS timeTSUnchanged = this.extractDeceasedTimeTSData(clinicalDocumentUnchanged);
        Assert.assertNotNull((Object)timeTSUnchanged);
        Assert.assertEquals((String)"The TS value has changed after de/reserialization.", (Object)timeTS.getValue(), (Object)timeTSUnchanged.getValue());
    }

    @Test
    public void testIdDeserialization() {
        ClinicalDocument clinicalDocument = null;
        ClinicalDocument clinicalDocumentUnchanged = null;
        clinicalDocumentUnchanged = clinicalDocument = this.deserializeExternalDocument(clinicalDocument, MU2_DOC_VALID);
        EList<II> idII = this.extractIdIIData(clinicalDocument);
        Assert.assertNotNull(idII);
        Assert.assertEquals((String)"The root in the deserialized document is not the same as the root in the original external document (or is null/did not exist in the external document).", (Object)ID_ROOT_VALUE, (Object)((II)idII.get(0)).getRoot());
        Assert.assertEquals((String)"The extension in the deserialized document is not the same as the extension in the original external document (or is null/did not exist in the external document).", (Object)ID_EXT_VALUE, (Object)((II)idII.get(0)).getExtension());
        Assert.assertEquals((String)"The assigningAuthorityName in the deserialized document is not the same as the assigningAuthorityName in the original external document (or is null/did not exist in the external document).", (Object)ID_AAN_VALUE, (Object)((II)idII.get(0)).getAssigningAuthorityName());
        Assert.assertEquals((String)"The displayable attribute in the deserialized document is not the same as the displayable attribute in the original external document (or is null/did not exist in the external document).", (Object)false, (Object)((II)idII.get(0)).getDisplayable());
        if (!this.serializeDocument(clinicalDocument, "\n\n---testIdDeserialization Reserialized Document---")) {
            Assert.fail((String)"Unable to reserialize sdtc:id within a document.");
        }
        Assert.assertNotNull((Object)clinicalDocument);
        Assert.assertNotNull((Object)clinicalDocumentUnchanged);
        Assert.assertEquals((Object)clinicalDocument, (Object)clinicalDocumentUnchanged);
        EList<II> idIIUnchanged = this.extractIdIIData(clinicalDocumentUnchanged);
        Assert.assertNotNull(idIIUnchanged);
        Assert.assertEquals((String)"The root has changed after de/reserialization.", (Object)((II)idII.get(0)).getRoot(), (Object)((II)idIIUnchanged.get(0)).getRoot());
        Assert.assertEquals((String)"The extension has changed after de/rerialization.", (Object)((II)idII.get(0)).getExtension(), (Object)((II)idIIUnchanged.get(0)).getExtension());
        Assert.assertEquals((String)"The assigningAuthorityName has changed after de/reserialization.", (Object)((II)idII.get(0)).getAssigningAuthorityName(), (Object)((II)idIIUnchanged.get(0)).getAssigningAuthorityName());
        Assert.assertEquals((String)"The displayable attribute has changed after de/reserialization.", (Object)((II)idII.get(0)).getDisplayable(), (Object)((II)idIIUnchanged.get(0)).getDisplayable());
    }

    @Test
    public void testBirthTimeDeserialization() {
        ClinicalDocument clinicalDocument = null;
        ClinicalDocument clinicalDocumentUnchanged = null;
        clinicalDocumentUnchanged = clinicalDocument = this.deserializeExternalDocument(clinicalDocument, MU2_DOC_VALID);
        TS birthTS = this.extractBirthTimeTSData(clinicalDocument);
        Assert.assertNotNull((Object)birthTS);
        Assert.assertEquals((String)"The TS value in the deserialized document is not the same as the TS value in the original external document (or is null/did not exist in the external document).", (Object)BT_TS_VALUE, (Object)birthTS.getValue());
        if (!this.serializeDocument(clinicalDocument, "\n\n---testBirthTimeDeserialization Reserialized Document---")) {
            Assert.fail((String)"Unable to reserialize sdtc:birthTime within a document.");
        }
        Assert.assertNotNull((Object)clinicalDocument);
        Assert.assertNotNull((Object)clinicalDocumentUnchanged);
        Assert.assertEquals((Object)clinicalDocument, (Object)clinicalDocumentUnchanged);
        TS birthTSUnchanged = this.extractBirthTimeTSData(clinicalDocumentUnchanged);
        Assert.assertNotNull((Object)birthTSUnchanged);
        Assert.assertEquals((String)"The TS value has changed after de/reserialization.", (Object)birthTS.getValue(), (Object)birthTSUnchanged.getValue());
    }

    @Test
    public void testAsPatientRelationshipDeserialization() {
        ClinicalDocument clinicalDocument = null;
        ClinicalDocument clinicalDocumentUnchanged = null;
        clinicalDocumentUnchanged = clinicalDocument = this.deserializeExternalDocument(clinicalDocument, MU2_DOC_VALID);
        TS birthTS = this.extractBirthTimeTSData(clinicalDocument);
        Assert.assertNotNull((Object)birthTS);
        Assert.assertEquals((String)"The TS value in the deserialized document is not the same as the TS value in the original external document (or is null/did not exist in the external document).", (Object)BT_TS_VALUE, (Object)birthTS.getValue());
        if (!this.serializeDocument(clinicalDocument, "\n\n---testBirthTimeDeserialization Reserialized Document---")) {
            Assert.fail((String)"Unable to reserialize sdtc:birthTime within a document.");
        }
        Assert.assertNotNull((Object)clinicalDocument);
        Assert.assertNotNull((Object)clinicalDocumentUnchanged);
        Assert.assertEquals((Object)clinicalDocument, (Object)clinicalDocumentUnchanged);
        TS birthTSUnchanged = this.extractBirthTimeTSData(clinicalDocumentUnchanged);
        Assert.assertNotNull((Object)birthTSUnchanged);
        Assert.assertEquals((String)"The TS value has changed after de/reserialization.", (Object)birthTS.getValue(), (Object)birthTSUnchanged.getValue());
    }

    @Test
    public void testRaceCodeDeserialization() {
        ClinicalDocument clinicalDocument = null;
        ClinicalDocument clinicalDocumentUnchanged = null;
        clinicalDocumentUnchanged = clinicalDocument = this.deserializeExternalDocument(clinicalDocument, MU2_DOC_VALID);
        CE raceCE = this.extractRaceCodeCECodes(clinicalDocument);
        Assert.assertFalse((String)ERROR_RC_NO_DATA, (boolean)raceCE.getCode().equals(ERROR_RC_NO_DATA));
        Assert.assertFalse((String)ERROR_RC_NO_CODE, (boolean)raceCE.getCode().equals(ERROR_RC_NO_CODE));
        Assert.assertFalse((String)ERROR_RC_NO_ELEMENT, (boolean)raceCE.getCode().equals(ERROR_RC_NO_ELEMENT));
        Assert.assertNotNull((Object)raceCE);
        Assert.assertEquals((String)"The code in the deserialized document is not the same as the code in the original external document (or is null/did not exist in the external document).", (Object)RACE_CODE_VALUE, (Object)raceCE.getCode());
        Assert.assertEquals((String)"The codeSystem in the deserialized document is not the same as the codeSystem in the original external document (or is null/did not exist in the external document).", (Object)RACE_CODESYSTEM_VALUE, (Object)raceCE.getCodeSystem());
        Assert.assertEquals((String)"The codeSystemName in the deserialized document is not the same as the codeSystemName in the original external document (or is null/did not exist in the external document).", (Object)RACE_CODESYSTEMNAME_VALUE, (Object)raceCE.getCodeSystemName());
        if (!this.serializeDocument(clinicalDocument, "\n\n---testDischargeDispositionCodeDeserialization Reserialized Document---")) {
            Assert.fail((String)"Unable to reserialize sdtc:dischargeDispositionCode within a document.");
        }
        Assert.assertNotNull((Object)clinicalDocument);
        Assert.assertNotNull((Object)clinicalDocumentUnchanged);
        Assert.assertEquals((Object)clinicalDocument, (Object)clinicalDocumentUnchanged);
        CE raceCEUnchanged = this.extractRaceCodeCECodes(clinicalDocumentUnchanged);
        Assert.assertNotNull((Object)raceCEUnchanged);
        Assert.assertEquals((String)"The code has changed after de/reserialization.", (Object)raceCE.getCode(), (Object)raceCEUnchanged.getCode());
        Assert.assertEquals((String)"The codeSystem has changed after de/rerialization.", (Object)raceCE.getCodeSystem(), (Object)raceCEUnchanged.getCodeSystem());
        Assert.assertEquals((String)"The codeSystemName has changed after de/reserialization.", (Object)raceCE.getCodeSystemName(), (Object)raceCEUnchanged.getCodeSystemName());
    }
}

