/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.transform.ui.atl;

import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.m2m.atl.core.ATLCoreException;
import org.eclipse.m2m.atl.core.IExtractor;
import org.eclipse.m2m.atl.core.IInjector;
import org.eclipse.m2m.atl.core.IModel;
import org.eclipse.m2m.atl.core.IReferenceModel;
import org.eclipse.m2m.atl.core.ModelFactory;
import org.eclipse.m2m.atl.core.launch.ILauncher;
import org.eclipse.m2m.atl.core.service.CoreService;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.osgi.framework.Bundle;

public abstract class LaunchATLforUML
implements IObjectActionDelegate {
    private static IInjector injector;
    private static IExtractor extractor;
    private static IReferenceModel umlMetamodel;
    private static IReferenceModel refiningTraceMetamodel;
    private static URL asmURL;
    private ISelection currentSelection;

    protected IReferenceModel getUMLMetamodel() {
        return umlMetamodel;
    }

    protected IReferenceModel getRefiningTraceMetamodel() {
        return refiningTraceMetamodel;
    }

    protected IInjector getInjector() {
        return injector;
    }

    protected IExtractor getExtractor() {
        return extractor;
    }

    protected abstract String getATLSourceBundleId();

    protected abstract String getATLSourceFilePath();

    private void initializeMetamodels() {
        Bundle bundle = Platform.getBundle((String)this.getATLSourceBundleId());
        asmURL = bundle.getEntry(this.getATLSourceFilePath());
        try {
            injector = CoreService.getInjector((String)"EMF");
            extractor = CoreService.getExtractor((String)"EMF");
            ModelFactory modelFactory = CoreService.getModelFactory((String)"EMF");
            refiningTraceMetamodel = modelFactory.getBuiltInResource("RefiningTrace.ecore");
            umlMetamodel = modelFactory.newReferenceModel();
            injector.inject((IModel)umlMetamodel, "http://www.eclipse.org/uml2/3.0.0/UML");
            this.doInitializeMetamodels(modelFactory);
        }
        catch (ATLCoreException e) {
            e.printStackTrace();
        }
    }

    protected void doInitializeMetamodels(ModelFactory modelFactory) throws ATLCoreException {
    }

    protected void configureLauncher(ILauncher launcher, ModelFactory modelFactory) throws ATLCoreException {
        IModel refiningTraceModel = modelFactory.newModel(refiningTraceMetamodel);
        IModel umlModel = modelFactory.newModel(umlMetamodel);
        launcher.addOutModel(refiningTraceModel, "refiningTrace", "RefiningTrace");
        launcher.addInModel(umlModel, "IN", "UML");
        launcher.addOutModel(umlModel, "OUT", "UML");
        this.doConfigureLauncher(launcher, modelFactory);
    }

    protected void doConfigureLauncher(ILauncher launcher, ModelFactory modelFactory) throws ATLCoreException {
    }

    protected String getOutputFileSuffix() {
        return "-output";
    }

    protected String getOutputFilePath(IFile sourceFile) {
        IPath sourceModelPath = sourceFile.getFullPath();
        String outputFileName = String.valueOf(sourceModelPath.removeFileExtension().lastSegment()) + this.getOutputFileSuffix();
        IPath outputModelPath = sourceModelPath.removeLastSegments(1).append(outputFileName).addFileExtension(sourceModelPath.getFileExtension());
        return outputModelPath.toString();
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        if (injector == null) {
            this.initializeMetamodels();
        }
        IStructuredSelection iss = (IStructuredSelection)this.currentSelection;
        Iterator iterator = iss.iterator();
        while (iterator.hasNext()) {
            try {
                this.transform((IFile)iterator.next());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected void transform(IFile file) throws Exception {
        ILauncher launcher = CoreService.getLauncher((String)"EMF-specific VM");
        launcher.initialize(Collections.emptyMap());
        ModelFactory modelFactory = CoreService.getModelFactory((String)"EMF");
        this.configureLauncher(launcher, modelFactory);
        String modelPath = file.getFullPath().toString();
        URI inModelURI = URI.createPlatformResourceURI((String)modelPath, (boolean)true);
        injector.inject(launcher.getModel("IN"), inModelURI.toString());
        HashMap<String, Boolean> launcherOptions = new HashMap<String, Boolean>();
        launcherOptions.put("allowInterModelReferences", Boolean.TRUE);
        launcherOptions.put("supportUML2Stereotypes", Boolean.TRUE);
        launcher.launch("run", (IProgressMonitor)new NullProgressMonitor(), launcherOptions, new Object[]{asmURL.openStream()});
        String outputFilePath = this.getOutputFilePath(file);
        extractor.extract(launcher.getModel("OUT"), outputFilePath);
        file.getParent().refreshLocal(2, null);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.currentSelection = selection;
    }
}

