/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.api.schematron.action;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.mdht.api.GenerateAPIAction;
import org.eclipse.mdht.api.schematron.CDAOCL2XPathHandler;
import org.eclipse.mdht.api.schematron.action.EntityResources;
import org.eclipse.mdht.transformation.ocl.OCLTransformation;
import org.eclipse.mdht.transformation.ocl2xpath.OCL2XPathTransformationForUML;
import org.eclipse.mdht.uml.cda.core.util.CDACommonUtils;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;

public class GenerateSchematronAction
extends GenerateAPIAction {
    private File xpathResources;
    protected File templates;
    String errorMessageTemplate;
    String xpathResourceRowTemplate;
    String summaryRowTemplate;
    String fileNameTemplate;
    String entIdTemplate;
    String patternIdTemplate;
    Map<String, EntityResources> resourcesOfEntity = new HashMap<String, EntityResources>();
    List<String> summaryRows = new ArrayList<String>();
    Collection<String> patternIDs = new ArrayList<String>();
    StringBuilder contextasserts = new StringBuilder();
    StringBuilder schematronPreludium = new StringBuilder();
    StringBuilder schematron = new StringBuilder();
    private IProgressMonitor monitor;

    protected String getTargetLanguage() {
        return "Schematron";
    }

    protected String getEntityMimeType() {
        return "text/xml";
    }

    protected File genfolder(File modelFolder) {
        return new File(modelFolder, "genschematron");
    }

    protected String getRootFileExtension() {
        return ".sch";
    }

    protected String getPlugin() {
        return "org.eclipse.mdht.api.schematron";
    }

    protected void genAPICode(Package pack, IProgressMonitor monitor) throws Exception {
        monitor = new SubProgressMonitor(monitor, 80);
        monitor.beginTask("", this.classes.size());
        this.monitor = monitor;
        this.resolvePathmapsInResourceURIs();
        this.xpathResources = new File(this.genfolder, "xpath");
        if (this.xpathResources.exists() && this.xpathResources.listFiles() != null) {
            File[] fileArray = this.xpathResources.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                file.delete();
                ++n2;
            }
        }
        this.schematronPreludium.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n");
        this.schematronPreludium.append("<!DOCTYPE schema [\n");
        this.schematron.append("<schema xmlns=\"http://www.ascc.net/xml/schematron\" xmlns:cda=\"urn:hl7-org:v3\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n");
        this.schematron.append("<title>Schematron schema for validating conformance to " + pack.getName().toUpperCase() + " documents</title>\n");
        this.schematron.append("<ns prefix=\"cda\" uri=\"urn:hl7-org:v3\"/>\n");
        this.schematron.append("<ns prefix=\"xsi\" uri=\"http://www.w3.org/2001/XMLSchema-instance\"/>\n\n");
        this.schematron.append("<ns prefix=\"ext\" uri=\"http://ns.electronichealth.net.au/Ci/Cda/Extensions/3.0\"/>\n\n");
        this.errorMessageTemplate = this.getStereotype((NamedElement)pack, "errorMessageTemplate");
        this.xpathResourceRowTemplate = this.getStereotype((NamedElement)pack, "xpathResourceRowTemplate");
        this.summaryRowTemplate = this.getStereotype((NamedElement)pack, "summaryRowTemplate");
        this.fileNameTemplate = this.getStereotype((NamedElement)pack, "fileNameTemplate");
        this.entIdTemplate = this.getStereotype((NamedElement)pack, "entIdTemplate");
        this.patternIdTemplate = this.getStereotype((NamedElement)pack, "patternIdTemplate");
        StringBuilder summary = new StringBuilder("<table border=\"1\">\n" + this.summaryRowTemplate.replace("{", "").replace("}", ""));
        this.recurseModel();
        this.writeAllEntities();
        monitor.subTask("Write " + this.summaryFile.getName());
        Collections.sort(this.summaryRows);
        summary.append(StringUtils.join(this.summaryRows, (String)""));
        summary.append("</table>\n");
        this.printMetaData(pack, "", "<br>", "<br>", summary);
        CDACommonUtils.stringToFile((String)summary.toString(), (File)this.summaryFile);
        String allContextsId = "allcontexts_mdht";
        StringBuilder pattern = new StringBuilder();
        pattern.append("<pattern id=\"" + allContextsId + "\" see=\"#" + allContextsId + "\" name=\"" + allContextsId + "\">\n");
        pattern.append("\t\t<!--tests all rules-->\n");
        pattern.append("\t<rule context=\"/cda:ClinicalDocument\">\n");
        pattern.append((CharSequence)this.contextasserts);
        pattern.append("\t</rule>\n");
        pattern.append("</pattern>\n");
        pattern.append("\n");
        this.writeEntity(this.schematronPreludium, this.schematron, pattern.toString(), "allcontexts", "allcontexts");
        this.schematron.append("<phase id = \"errors\">\n\n");
        for (String id : this.patternIDs) {
            this.schematron.append("\t<active pattern = \"" + id + "\"/>\n");
        }
        this.schematron.append("\n</phase>\n\n\n");
        this.schematron.append("<phase id = \"rules\">\n\n");
        this.schematron.append("\t<active pattern = \"" + allContextsId + "\"/>\n");
        this.schematron.append("\n</phase>\n\n\n");
        this.schematron.append("</schema>\n");
        this.schematronPreludium.append("]>\n\n");
        File schFile = new File(this.genfolder, String.valueOf(this.umlFile.getName().substring(0, this.umlFile.getName().indexOf("."))) + this.getRootFileExtension());
        CDACommonUtils.stringToFile((String)(String.valueOf(this.schematronPreludium.toString()) + this.schematron.toString()), (File)schFile);
        monitor.done();
    }

    protected void recursePropertyPaths(Class clazz) throws IOException {
        boolean firstProcessed = this.processedClasses.add(clazz);
        if (!firstProcessed && CDACommonUtils.getMainSection((Class)clazz) != -1 && this.umlClinicalDocuments.size() >= 2) {
            return;
        }
        super.recursePropertyPaths(clazz);
        if (firstProcessed) {
            this.monitor.worked(1);
            this.monitor.subTask(CDACommonUtils.getUmlContext((Class)clazz));
        } else {
            this.monitor.subTask(String.valueOf(CDACommonUtils.getUmlContext((Class)clazz)) + " (duplicate)");
        }
        if (this.monitor.isCanceled()) {
            throw new RuntimeException("Canceled by user");
        }
        if (clazz.getName() == null || "".equals(clazz.getName().trim())) {
            return;
        }
        for (Constraint constraint : CDACommonUtils.getAllRules((Class)clazz)) {
            NamedElement element = this.getConstrainedElement(constraint);
            if (element == null) continue;
            try {
                StringBuilder asserts;
                if (GenerateSchematronAction.getPDFSection((Class)clazz, (Element)element).contains("ii.ii") && GenerateSchematronAction.getPDFSection((Class)clazz, (Element)element).contains("?") && GenerateSchematronAction.getPDFSection((Class)clazz, (Element)element).contains("?") || GenerateSchematronAction.getPDFSection((Class)clazz, (Element)element).contains("null")) continue;
                String analysis = CDACommonUtils.withoutTags((String)this.resolve(this.errorMessageTemplate, clazz, element, constraint).replace("\n", "\n\t\t"));
                String xPathTest = this.resolve("{xpath-test}", clazz, element, constraint);
                String fileName = this.toValidFileName(this.resolve(this.fileNameTemplate, clazz, element, constraint));
                EntityResources entity = this.resourcesOfEntity.get(fileName);
                if (entity == null) {
                    String entId = this.toValidFileName(this.resolve(this.entIdTemplate, clazz, element, constraint));
                    String patternId = this.toValidPatternName(this.resolve(this.patternIdTemplate, clazz, element, constraint));
                    entity = new EntityResources(fileName, entId, patternId, this.xpathResourceRowTemplate);
                    this.resourcesOfEntity.put(fileName, entity);
                    entity.context = clazz;
                }
                StringBuilder rule = new StringBuilder();
                rule.append("\t\t<!--\n");
                rule.append("\t\t\tUML path: " + CDACommonUtils.getUmlContext((Class)clazz) + "\n");
                rule.append("\t\t\tUML root path: " + CDACommonUtils.getUmlContext((Class)clazz, (boolean)false) + "\n");
                rule.append("\t\t\tUML qualified name: " + clazz.getQualifiedName() + "\n");
                rule.append("\t\t-->\n");
                rule.append("\t<rule context=\"" + this.escapeAttributeValue(this.getCdaContext(clazz, true)) + "\">\n");
                int index = entity.rules.indexOf(rule.toString());
                if (index == -1) {
                    entity.rules.add(rule.toString());
                    asserts = new StringBuilder();
                    entity.asserts.add(asserts);
                } else {
                    asserts = entity.asserts.get(index);
                }
                asserts.append("\t\t<!--\n");
                asserts.append("\t\t\tOCL: " + this.resolve("{ocl-constraint}", clazz, element, constraint) + "\n");
                asserts.append("\t\t\tConstraint name: " + this.getConstraintName(constraint) + "\n");
                asserts.append("\t\t-->\n");
                asserts.append("\t<assert test=\"" + this.escapeAttributeValue(xPathTest) + "\">" + StringEscapeUtils.escapeHtml((String)analysis) + "\t</assert>\n");
                this.removeTabAndNewline = true;
                entity.xpathResource.append(this.resolve(this.xpathResourceRowTemplate, clazz, element, constraint, entity));
                this.removeTabAndNewline = false;
                this.summaryRows.add(this.resolve(this.summaryRowTemplate, clazz, element, constraint, entity));
                this.contextasserts.append("\t<assert test=\"" + this.escapeAttributeValue(this.getCdaContext(clazz, true)) + "\">Cannot find context " + this.getCdaContext(clazz, true) + "</assert>\n");
            }
            catch (Exception e) {
                CDACommonUtils.addStatus((Collection)this.statuses, (int)4, (String)this.getPlugin(), (int)17, (String)this.mentionSection("Could not transform OCL constraint \"" + constraint.getName() + "\": " + e.getMessage(), clazz, element), (Exception)e, (EObject[])new EObject[]{constraint});
            }
        }
    }

    private void writeAllEntities() throws IOException {
        for (EntityResources entity : this.resourcesOfEntity.values()) {
            Class clazz = entity.context;
            boolean alreadyContained = this.patternIDs.contains(entity.patternId);
            if (this.patternIDs.contains(entity.patternId)) continue;
            this.patternIDs.add(entity.patternId);
            StringBuilder pattern = new StringBuilder();
            pattern.append("<!-- " + clazz.getName() + (CDACommonUtils.getTemplateId((Class)clazz) != null ? ": " + CDACommonUtils.getTemplateId((Class)clazz) : "") + " -->\n\n");
            pattern.append("<pattern id=\"" + entity.patternId + "\" see=\"#" + entity.patternId + "\" name=\"" + entity.patternId + "\">\n");
            for (String rule : entity.rules) {
                pattern.append(rule);
                pattern.append((CharSequence)entity.asserts.get(entity.rules.indexOf(rule)));
                pattern.append("\t</rule>\n");
            }
            pattern.append("</pattern>\n");
            pattern.append("\n");
            this.writeEntity(this.schematronPreludium, this.schematron, pattern.toString(), entity.entId, String.valueOf(entity.fileName) + (alreadyContained ? "ALREADYTCONTAINRD" : ""));
            CDACommonUtils.stringToFile((String)entity.xpathResource.toString(), (File)this.getCSVFile(entity.fileName));
        }
    }

    protected void writeEntity(StringBuilder schematronPreludium, StringBuilder schematron, String content, String entId, String fileName) throws IOException {
        boolean useEntities;
        boolean bl = useEntities = !Boolean.getBoolean("SCHEMATRON_INLINE_ENTITIES");
        if (useEntities) {
            this.creator.writeFile(content, this.getEntityFile(fileName));
            schematronPreludium.append("<!ENTITY " + entId + " SYSTEM 'templates/" + fileName + ".ent'>\n");
            schematron.append("\t&" + entId + ";\n");
        } else {
            schematron.append(content);
        }
    }

    protected File getEntityFile(String filename) {
        return new File(new File(this.genfolder, "templates"), String.valueOf(filename) + ".ent");
    }

    protected String toValidFileName(String filename) {
        filename = filename.replace(".", "_").replace(" ", "");
        filename = filename.replaceAll("[:\\\\/*\"?|<>']", "");
        return filename;
    }

    protected String toValidPatternName(String patternname) {
        patternname = patternname.replace(".", "_").replace(" ", "");
        patternname = patternname.replaceAll("[:\\\\/*\"?|<>'\\(\\)]", "");
        return patternname;
    }

    protected OCLTransformation<Package, Classifier, ?, Property, ?, ?, ?, ?, ?, ?, ?, ?> createTrafo(ResourceSet resourceSet) {
        return new OCL2XPathTransformationForUML(resourceSet, new CDAOCL2XPathHandler());
    }

    protected String removeRedundancy(String fullXPath, String templateId, String root) {
        String predicateStart = "[" + templateId + "/" + root + " = ";
        String endsWith = "]/" + templateId;
        int i = fullXPath.lastIndexOf(predicateStart);
        if (i != -1 && fullXPath.endsWith(endsWith) && fullXPath.lastIndexOf("[") == i) {
            fullXPath = String.valueOf(fullXPath.substring(0, i)) + "/" + templateId + "[" + root + " = " + fullXPath.substring(i + predicateStart.length(), fullXPath.length() - endsWith.length()) + "]";
        }
        return fullXPath;
    }

    protected String getFullXPath(Class clazz, NamedElement element) {
        String fullXPath = super.getFullXPath(clazz, element);
        fullXPath = this.removeRedundancy(fullXPath, "cda:templateId", "@root");
        if ("/cda:ClinicalDocument/cda:templateId".equals(fullXPath = this.removeRedundancy(fullXPath, "cda:code", "@code")) && CDACommonUtils.getTemplateId((Class)clazz) != null) {
            fullXPath = String.valueOf(fullXPath) + "[@root = \"" + CDACommonUtils.getTemplateId((Class)clazz) + "\"]";
        }
        return fullXPath;
    }

    protected String resolve(String template, Class clazz, NamedElement element, Constraint constraint, EntityResources entity) {
        this.template = template;
        if (this.needResolve(new Object[]{"{entity-file-anchor}", entity})) {
            this.resolve(this.getAnchor(this.getEntityFile(entity.fileName), entity.fileName, this.getEntityMimeType()));
        }
        if (this.needResolve(new Object[]{"{csv-file-anchor}", entity})) {
            this.resolve(this.getAnchor(this.getCSVFile(entity.fileName), "csv", "text/tab-separated-values"));
        }
        return this.resolve(this.template, clazz, element, constraint);
    }

    private File getCSVFile(String filename) {
        return new File(this.xpathResources, String.valueOf(filename) + ".csv");
    }
}

