/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.ui.util;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.mdht.uml.cda.core.util.CDAProfileUtil;
import org.eclipse.mdht.uml.cda.ui.internal.Activator;
import org.eclipse.mdht.uml.cda.ui.util.CDAAssociationNotation;
import org.eclipse.mdht.uml.cda.ui.util.CDAClassNotation;
import org.eclipse.mdht.uml.cda.ui.util.CDAPropertyNotation;
import org.eclipse.mdht.uml.common.notation.INotationProvider;
import org.eclipse.mdht.uml.term.ui.notation.TermPropertyNotation;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;

public class CDAAnnotationProvider
implements INotationProvider,
IExecutableExtension {
    public static final int CDA_CLASS_ANNOTATION = 8192;
    public static final int CDA_ASSOCIATION_ANNOTATION = 640;
    public static final int CDA_PROPERTY_ANNOTATION = 640;
    public static final String SEVERITY_ERROR = "ERROR";
    public static final String SEVERITY_WARNING = "WARNING";
    public static final String SEVERITY_INFO = "INFO";

    public String getAnnotation(Element element) {
        String annotation = null;
        if (element instanceof Class) {
            annotation = CDAClassNotation.getCustomLabel((Class)element, 8192);
        } else if (element instanceof Association) {
            annotation = CDAAssociationNotation.getCustomLabel((Association)element, 640);
        } else if (element instanceof Property) {
            annotation = CDAPropertyNotation.getCustomLabel((Property)element, 640);
        }
        return annotation;
    }

    public Object getAnnotationImage(Element element) {
        Stereotype validationSupport = CDAProfileUtil.getAppliedCDAStereotype((Element)element, (String)"Validation");
        if (validationSupport != null) {
            Object literal = element.getValue(validationSupport, "severity");
            String severity = null;
            if (literal instanceof EnumerationLiteral) {
                severity = ((EnumerationLiteral)literal).getName();
            } else if (literal instanceof Enumerator) {
                severity = ((Enumerator)literal).getName();
            }
            if (severity != null) {
                if (SEVERITY_INFO.equals(severity)) {
                    return Activator.getDefault().getBundledImage("/icons/full/obj16/information.gif");
                }
                if (SEVERITY_WARNING.equals(severity)) {
                    return Activator.getDefault().getBundledImage("/icons/full/obj16/warning.gif");
                }
                if (SEVERITY_ERROR.equals(severity)) {
                    return Activator.getDefault().getBundledImage("/icons/full/obj16/error.gif");
                }
            }
        }
        return null;
    }

    public Object getElementImage(Element element) {
        return null;
    }

    public String getPrintString(Element element) {
        String printString = null;
        if (element instanceof Class) {
            printString = CDAClassNotation.getCustomLabel((Class)element, 8);
        } else if (element instanceof Association) {
            printString = CDAAssociationNotation.getCustomLabel((Association)element, 8);
        } else if (element instanceof Property) {
            printString = TermPropertyNotation.getCustomLabel((Property)((Property)element), (int)2680);
        }
        return printString;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
    }
}

