/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.term.core.util;

import org.eclipse.mdht.uml.term.core.profile.CodeSystemConstraint;
import org.eclipse.mdht.uml.term.core.profile.ValueSetCode;
import org.eclipse.mdht.uml.term.core.util.TermProfileUtil;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.Property;

public class CodeSystemConstraintUtil {
    public static String getOCL(Property property) {
        String result = property.getType() instanceof Enumeration ? CodeSystemConstraintUtil.getOCLForEnumeration(property) : CodeSystemConstraintUtil.getOCLForCD(property);
        return result;
    }

    private static String getOCLForCD(Property property) {
        StringBuffer body = new StringBuffer();
        boolean needsAnd = false;
        CodeSystemConstraint codeSystemConstraint = TermProfileUtil.getCodeSystemConstraint(property);
        if (codeSystemConstraint == null) {
            return null;
        }
        String id = codeSystemConstraint.getIdentifier();
        String name = codeSystemConstraint.getName();
        String code = codeSystemConstraint.getCode();
        if (codeSystemConstraint.getReference() != null) {
            id = codeSystemConstraint.getReference().getIdentifier();
            name = codeSystemConstraint.getReference().getEnumerationName();
        }
        if (code != null && code.length() > 0) {
            body.append("value.code = '");
            body.append(code);
            body.append("'");
            needsAnd = true;
        }
        if (id != null && id.length() > 0 && !TermProfileUtil.isCSType(property)) {
            if (needsAnd) {
                body.append(" and ");
            }
            body.append("value.codeSystem = '");
            body.append(id);
            body.append("'");
            needsAnd = true;
        }
        if (!(id != null && id.length() != 0 || name == null || name.length() <= 0 || TermProfileUtil.isCSType(property))) {
            if (needsAnd) {
                body.append(" and ");
            }
            body.append("value.codeSystemName = '");
            body.append(name);
            body.append("'");
            needsAnd = true;
        }
        return body.toString();
    }

    private static String getOCLForEnumeration(Property property) {
        StringBuilder result = null;
        CodeSystemConstraint codeSystemConstraint = TermProfileUtil.getCodeSystemConstraint(property);
        if (codeSystemConstraint == null) {
            return null;
        }
        if (codeSystemConstraint != null && codeSystemConstraint.getReference() != null) {
            Iterable<EnumerationLiteral> literals;
            result = new StringBuilder();
            String enumTypeName = property.getType().getQualifiedName();
            Enumeration base = codeSystemConstraint.getReference().getBase_Enumeration();
            if (base != null && (literals = TermProfileUtil.getSmallEnumeration(base)) != null) {
                boolean needsOr = false;
                for (EnumerationLiteral next : base.getOwnedLiterals()) {
                    ValueSetCode code = TermProfileUtil.getValueSetCode(next);
                    if (code == null) continue;
                    if (needsOr) {
                        result.append(" or ");
                    }
                    result.append("value = ");
                    result.append(enumTypeName).append("::").append(next.getName());
                    needsOr = true;
                }
            }
            if (result.length() == 0) {
                String code = codeSystemConstraint.getCode();
                if (code != null && code.length() > 0) {
                    result.append("value = ");
                    result.append(enumTypeName).append("::").append(code);
                } else {
                    result.append("not value.oclIsUndefined()");
                }
            }
        }
        return result == null ? null : result.toString();
    }
}

