/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.program.linking;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mita.base.expressions.ArgumentExpression;
import org.eclipse.mita.base.expressions.Expression;
import org.eclipse.mita.base.expressions.FeatureCall;
import org.eclipse.mita.base.expressions.util.ArgumentSorter;
import org.eclipse.mita.base.types.Operation;
import org.eclipse.mita.base.types.Type;
import org.eclipse.mita.base.types.TypesPackage;
import org.eclipse.mita.base.types.inferrer.ITypeSystemInferrer;
import org.eclipse.mita.base.types.typesystem.ITypeSystem;
import org.eclipse.mita.base.types.validation.IValidationIssueAcceptor;
import org.eclipse.mita.base.types.validation.TypeValidator;
import org.eclipse.mita.program.scoping.ExtensionMethodHelper;
import org.eclipse.mita.program.scoping.OperationUserDataHelper;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

public class OperationsLinker {
    @Inject
    protected ITypeSystemInferrer inferrer;
    @Inject
    protected TypeValidator validator;
    @Inject
    protected ITypeSystem typeSystem;
    @Inject
    protected ExtensionMethodHelper extensionMethodHelper;
    @Inject
    protected OperationUserDataHelper operationUserDataHelper;

    public Optional<Operation> linkOperation(List<IEObjectDescription> candidates, ArgumentExpression call) {
        if (candidates.size() == 1 && candidates.get(0).getEClass().isSuperTypeOf(TypesPackage.Literals.OPERATION)) {
            return Optional.of((Operation)candidates.get(0).getEObjectOrProxy());
        }
        Collections.sort(candidates, new PolymorphicComparator());
        for (IEObjectDescription operation : candidates) {
            if (!this.isCallable(operation, call)) continue;
            return Optional.of((Operation)operation.getEObjectOrProxy());
        }
        return Optional.empty();
    }

    protected List<ITypeSystemInferrer.InferenceResult> getArgumentTypes(Operation operation, ArgumentExpression expression) {
        Expression owner;
        ITypeSystemInferrer.InferenceResult ownerType;
        Object orderedExpressions = ArgumentSorter.getOrderedExpressions((List)expression.getArguments(), (Operation)operation);
        if (expression instanceof FeatureCall && this.extensionMethodHelper.isExtensionMethodOn(operation, (ownerType = this.inferrer.infer((EObject)(owner = ((FeatureCall)expression).getOwner()))).getType())) {
            orderedExpressions = this.extensionMethodHelper.combine(((FeatureCall)expression).getOwner(), (List<Expression>)orderedExpressions);
        }
        return Lists.newArrayList((Iterable)Lists.transform((List)orderedExpressions, e -> this.inferrer.infer((EObject)e)));
    }

    protected boolean isCallable(IEObjectDescription operation, ArgumentExpression expression) {
        Operation op = (Operation)operation.getEObjectOrProxy();
        if (!op.eIsProxy()) {
            return this.isCallableByType(operation, this.getArgumentTypes(op, expression));
        }
        return this.isCallableByName(operation, this.getArgumentTypes(op, expression));
    }

    protected boolean isCallableByName(IEObjectDescription operation, List<ITypeSystemInferrer.InferenceResult> argumentTypes) {
        List<String> parameterTypes = Arrays.asList(this.operationUserDataHelper.getParameterTypeNames(operation));
        if (argumentTypes.size() != parameterTypes.size()) {
            return false;
        }
        int i = 0;
        while (i < argumentTypes.size()) {
            String parameterTypeName = parameterTypes.get(i);
            if (!this.isSubtype(argumentTypes.get(i).getType(), parameterTypeName)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected boolean isSubtype(Type subType, String superTypeName) {
        if (subType.getName().equals(superTypeName)) {
            return true;
        }
        return IteratorExtensions.exists(this.typeSystem.getSuperTypes(subType).iterator(), t -> t.getName().equals(superTypeName));
    }

    protected boolean isCallableByType(IEObjectDescription operation, List<ITypeSystemInferrer.InferenceResult> argumentTypes) {
        List<ITypeSystemInferrer.InferenceResult> parameterTypes = this.operationUserDataHelper.getParameterInferenceResults(operation);
        if (argumentTypes.size() != parameterTypes.size()) {
            return false;
        }
        int i = 0;
        while (i < argumentTypes.size()) {
            ITypeSystemInferrer.InferenceResult argumentType = argumentTypes.get(i);
            ITypeSystemInferrer.InferenceResult parameterType = parameterTypes.get(i);
            IValidationIssueAcceptor.ListBasedValidationIssueAcceptor acceptor = new IValidationIssueAcceptor.ListBasedValidationIssueAcceptor();
            this.validator.assertAssignable(parameterType, argumentType, String.format("Types are incompatible", argumentType, parameterType), (IValidationIssueAcceptor)acceptor);
            if (!acceptor.getTraces(IValidationIssueAcceptor.ValidationIssue.Severity.ERROR).isEmpty()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected class PolymorphicComparator
    implements Comparator<IEObjectDescription> {
        protected PolymorphicComparator() {
        }

        @Override
        public int compare(IEObjectDescription operation1, IEObjectDescription operation2) {
            List<Type> parameters1 = OperationsLinker.this.operationUserDataHelper.getParameterTypes(operation1);
            List<Type> parameters2 = OperationsLinker.this.operationUserDataHelper.getParameterTypes(operation2);
            if (parameters1.size() > parameters2.size()) {
                return -1;
            }
            if (parameters1.size() < parameters2.size()) {
                return 1;
            }
            int i = 0;
            while (i < parameters1.size()) {
                Type type2;
                Type type1 = parameters1.get(i);
                if (!OperationsLinker.this.typeSystem.isSame(type1, type2 = parameters2.get(i))) {
                    if (OperationsLinker.this.typeSystem.isSuperType(type1, type2)) {
                        return 1;
                    }
                    if (OperationsLinker.this.typeSystem.isSuperType(type2, type1)) {
                        return -1;
                    }
                }
                ++i;
            }
            return 0;
        }
    }
}

