/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.program.validation;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.mita.base.types.Operation;
import org.eclipse.mita.base.types.Parameter;
import org.eclipse.mita.base.types.Type;
import org.eclipse.mita.base.types.TypeSpecifier;
import org.eclipse.mita.base.types.TypesPackage;
import org.eclipse.mita.program.Program;
import org.eclipse.mita.program.VariableDeclaration;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.validation.AbstractDeclarativeValidator;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.CheckType;
import org.eclipse.xtext.validation.EValidatorRegistrar;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class ProgramNamesAreUniqueValidator
extends AbstractDeclarativeValidator {
    private final String DUPLICATE_ELEMENT = "Duplicate element '%s'";
    private final String DUPLICATE_FUNCTION = "Duplicate function '%s'";
    private final String DUPLICATE_TYPE = "Duplicate type '%s'";

    @Check(value=CheckType.FAST)
    public void checkGlobalVariableNamesAreUnique(Program program) {
        final ArrayList names = CollectionLiterals.newArrayList();
        Consumer<VariableDeclaration> _function = new Consumer<VariableDeclaration>(){

            @Override
            public void accept(VariableDeclaration it) {
                boolean _contains = names.contains(it.getName());
                if (_contains) {
                    ProgramNamesAreUniqueValidator.this.error(String.format("Duplicate element '%s'", it.getName()), it, (EStructuralFeature)TypesPackage.eINSTANCE.getNamedElement_Name());
                }
                names.add(it.getName());
            }
        };
        program.getGlobalVariables().forEach((Consumer)_function);
    }

    @Check(value=CheckType.FAST)
    public void checkFunctionsAreUnique(Program program) {
        final ArrayList names = CollectionLiterals.newArrayList();
        Consumer<Operation> _function = new Consumer<Operation>(){

            @Override
            public void accept(Operation it) {
                boolean _contains = names.contains(ProgramNamesAreUniqueValidator.this.overridingName(it));
                if (_contains) {
                    ProgramNamesAreUniqueValidator.this.error(String.format("Duplicate function '%s'", it.getName()), (EObject)it, (EStructuralFeature)TypesPackage.eINSTANCE.getNamedElement_Name());
                }
                names.add(ProgramNamesAreUniqueValidator.this.overridingName(it));
            }
        };
        program.getFunctionDefinitions().forEach((Consumer)_function);
    }

    protected String overridingName(Operation op) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = op.getName();
        _builder.append(_name);
        _builder.append("_");
        Functions.Function1<Parameter, Boolean> _function = new Functions.Function1<Parameter, Boolean>(){

            public Boolean apply(Parameter it) {
                boolean _isOptional = it.isOptional();
                return !_isOptional;
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)op.getParameters(), (Functions.Function1)_function);
        boolean _hasElements = false;
        for (Parameter param : _filter) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)"_", "");
            }
            TypeSpecifier _typeSpecifier = param.getTypeSpecifier();
            String _string = null;
            if (_typeSpecifier != null) {
                _string = _typeSpecifier.toString();
            }
            _builder.append(_string);
        }
        return _builder.toString();
    }

    @Check(value=CheckType.FAST)
    public void checkTypesAreUnique(Program program) {
        final ArrayList names = CollectionLiterals.newArrayList();
        Consumer<Type> _function = new Consumer<Type>(){

            @Override
            public void accept(Type it) {
                boolean _contains = names.contains(it.getName());
                if (_contains) {
                    ProgramNamesAreUniqueValidator.this.error(String.format("Duplicate type '%s'", it.getName()), (EObject)it, (EStructuralFeature)TypesPackage.eINSTANCE.getNamedElement_Name());
                }
                names.add(it.getName());
            }
        };
        program.getTypes().forEach((Consumer)_function);
    }

    @Inject
    public void register(EValidatorRegistrar registrar) {
    }
}

