/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.base.scoping;

import com.google.common.base.Predicate;
import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.mita.base.scoping.LibraryScopeProvider;
import org.eclipse.mita.base.scoping.TypeSystemAwareScope;
import org.eclipse.mita.base.types.TypesPackage;
import org.eclipse.mita.base.types.typesystem.ITypeSystem;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.impl.DefaultGlobalScopeProvider;
import org.eclipse.xtext.scoping.impl.FilteringScope;
import org.eclipse.xtext.scoping.impl.SimpleScope;

public class TypesGlobalScopeProvider
extends DefaultGlobalScopeProvider {
    @Inject
    private ITypeSystem typeSystem;
    @Inject
    private LibraryScopeProvider libraryScopeProvider;
    @Inject
    private IQualifiedNameProvider qualifiedNameProvider;

    public IScope getScope(Resource context, EReference reference, Predicate<IEObjectDescription> filter) {
        IScope superScope = super.getScope(context, reference, filter);
        superScope = this.addLibraryScope(context, reference, superScope);
        superScope = this.addTypeSystemScope(context, reference, superScope);
        superScope = TypesGlobalScopeProvider.filterExportable(context, reference, superScope);
        return superScope;
    }

    public static IScope filterExportable(Resource context, EReference reference, IScope superScope) {
        Object resourcePackageObj;
        EObject root;
        EStructuralFeature nameFeature;
        String resourcePackage = null;
        if (!context.getContents().isEmpty() && (nameFeature = (root = (EObject)context.getContents().get(0)).eClass().getEStructuralFeature("name")) != null && (resourcePackageObj = root.eGet(nameFeature)) != null) {
            resourcePackage = resourcePackageObj.toString();
        }
        final String resourcePackageName = resourcePackage;
        return new FilteringScope(superScope, (Predicate)new Predicate<IEObjectDescription>(){

            public boolean apply(IEObjectDescription input) {
                boolean inSamePackage = resourcePackageName != null && input.getQualifiedName().toString().startsWith(resourcePackageName);
                String isExported = input.getUserData("EXPORTED");
                boolean includeInScope = inSamePackage || isExported == null || "true".equals(isExported);
                return includeInScope;
            }
        });
    }

    private SimpleScope addLibraryScope(Resource context, EReference reference, IScope superScope) {
        return new SimpleScope(superScope, this.getLibraryScope(context, reference).getAllElements());
    }

    protected IScope getLibraryScope(Resource context, EReference reference) {
        return this.libraryScopeProvider.getScope(context, reference);
    }

    protected IScope addTypeSystemScope(Resource context, EReference reference, IScope superScope) {
        superScope = new TypeSystemAwareScope((IScope)superScope, this.typeSystem, this.qualifiedNameProvider, reference.getEReferenceType(), reference == TypesPackage.Literals.TYPE__SUPER_TYPES);
        return superScope;
    }
}

