/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.platform.scoping;

import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mita.base.scoping.TypeDSLResourceDescriptionStrategy;
import org.eclipse.mita.base.types.SumAlternative;
import org.eclipse.mita.base.types.Type;
import org.eclipse.mita.base.types.TypeSpecifier;
import org.eclipse.mita.platform.AbstractSystemResource;
import org.eclipse.mita.platform.Platform;
import org.eclipse.mita.platform.PlatformPackage;
import org.eclipse.mita.platform.SystemResourceAlias;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.util.IAcceptor;

public class PlatformDslResourceDescriptionStrategy
extends TypeDSLResourceDescriptionStrategy {
    private ImmutableList<EClass> SUPPRESSED_OBJECTS = ImmutableList.of((Object)PlatformPackage.Literals.ABSTRACT_SYSTEM_RESOURCE, (Object)PlatformPackage.Literals.BUS, (Object)PlatformPackage.Literals.CONNECTIVITY, (Object)PlatformPackage.Literals.INPUT_OUTPUT, (Object)PlatformPackage.Literals.SENSOR, (Object)PlatformPackage.Literals.SYSTEM_RESOURCE_ALIAS);

    void export(EObject obj, IAcceptor<IEObjectDescription> acceptor) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("EXPORTED", String.valueOf(true));
        acceptor.accept((Object)EObjectDescription.create((QualifiedName)this.getQualifiedNameProvider().getFullyQualifiedName(obj), (EObject)obj, map));
    }

    public boolean createEObjectDescriptions(EObject eObject, IAcceptor<IEObjectDescription> acceptor) {
        if (this.getQualifiedNameProvider() == null) {
            return false;
        }
        if (this.SUPPRESSED_OBJECTS.contains((Object)eObject.eClass())) {
            return false;
        }
        if (eObject instanceof Platform) {
            return this.createPlatformDescription((Platform)eObject, acceptor);
        }
        if (eObject instanceof Type || eObject.eContainer() instanceof SumAlternative && !(eObject instanceof TypeSpecifier)) {
            this.export(eObject, acceptor);
            return true;
        }
        return super.createEObjectDescriptions(eObject, acceptor);
    }

    private boolean createPlatformDescription(Platform platform, IAcceptor<IEObjectDescription> acceptor) {
        super.createEObjectDescriptions((EObject)platform, acceptor);
        for (AbstractSystemResource systemResource : platform.getResources()) {
            if (systemResource == null || systemResource instanceof SystemResourceAlias && ((SystemResourceAlias)systemResource).getDelegate() == null) continue;
            super.createEObjectDescriptions((EObject)systemResource, acceptor);
        }
        return true;
    }
}

