/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.platform.arduino.buses;

import com.google.inject.Inject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mita.base.expressions.Argument;
import org.eclipse.mita.base.expressions.ElementReferenceExpression;
import org.eclipse.mita.base.expressions.Expression;
import org.eclipse.mita.base.types.Enumerator;
import org.eclipse.mita.program.SignalInstance;
import org.eclipse.mita.program.generator.AbstractSystemResourceGenerator;
import org.eclipse.mita.program.generator.CodeFragment;
import org.eclipse.mita.program.generator.CodeFragmentProvider;
import org.eclipse.mita.program.inferrer.StaticValueInferrer;
import org.eclipse.mita.program.model.ModelUtils;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.xbase.lib.Procedures;

public class GPIOGenerator
extends AbstractSystemResourceGenerator {
    @Inject
    protected CodeFragmentProvider codeFragmentProvider;

    public CodeFragment generateSetup() {
        return CodeFragment.EMPTY;
    }

    public CodeFragment generateEnable() {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                EList _signalInstances = GPIOGenerator.this.setup.getSignalInstances();
                for (SignalInstance signaleInstace : _signalInstances) {
                    _builder.append((Object)"GPIO_Connect(");
                    CodeFragment _pinName = GPIOGenerator.this.getPinName(signaleInstace);
                    _builder.append((Object)_pinName);
                    _builder.append((Object)", ");
                    CharSequence _pinMode = GPIOGenerator.this.getPinMode(signaleInstace);
                    _builder.append((Object)_pinMode);
                    _builder.append((Object)");");
                    _builder.newLineIfNotEmpty();
                }
            }
        };
        return this.codeFragmentProvider.create(_client).addHeader("GPIO.h", false);
    }

    public CharSequence getPinMode(SignalInstance signaleInstance) {
        Expression _initialization = signaleInstance.getInitialization();
        ElementReferenceExpression init = (ElementReferenceExpression)_initialization;
        Expression value = ((Argument)init.getArguments().get(1)).getValue();
        if (value instanceof ElementReferenceExpression) {
            boolean _contains = ((ElementReferenceExpression)value).getReference().toString().contains("INPUT");
            if (_contains) {
                return "INPUT";
            }
            return "OUTPUT";
        }
        return null;
    }

    public CodeFragment getPinName(SignalInstance sigInst) {
        Procedures.Procedure1<EObject> _function = new Procedures.Procedure1<EObject>(){

            public void apply(EObject it) {
            }
        };
        final Object enumValue = StaticValueInferrer.infer((EObject)ModelUtils.getArgumentValue((SignalInstance)sigInst, (String)"pin"), (Procedures.Procedure1)_function);
        if (enumValue instanceof Enumerator) {
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    String _name = ((Enumerator)enumValue).getName();
                    _builder.append((Object)_name);
                }
            };
            return this.codeFragmentProvider.create(_client);
        }
        return CodeFragment.EMPTY;
    }

    public CodeFragment generateSignalInstanceSetter(final SignalInstance signalInstance, final String valueVariableName) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"if(*");
                _builder.append((Object)valueVariableName);
                _builder.append((Object)") {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"return setGPIO(");
                CodeFragment _pinName = GPIOGenerator.this.getPinName(signalInstance);
                _builder.append((Object)_pinName, "\t");
                _builder.append((Object)");");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"} else {");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"return unsetGPIO(");
                CodeFragment _pinName_1 = GPIOGenerator.this.getPinName(signalInstance);
                _builder.append((Object)_pinName_1, "\t");
                _builder.append((Object)");");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"}");
                _builder.newLine();
            }
        };
        return this.codeFragmentProvider.create(_client);
    }

    public CodeFragment generateSignalInstanceGetter(final SignalInstance signalInstance, final String resultName) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"return readGPIO(");
                CodeFragment _pinName = GPIOGenerator.this.getPinName(signalInstance);
                _builder.append((Object)_pinName);
                _builder.append((Object)", ");
                _builder.append((Object)resultName);
                _builder.append((Object)");");
            }
        };
        return this.codeFragmentProvider.create(_client);
    }
}

