/*******************************************************************************
 * Copyright (c) 2005 - 2006 Joel Cheuoua & others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Joel Cheuoua - initial API and implementation
 *******************************************************************************/
package org.eclipse.emf.codegen.jet.editor.codeassist;

import java.util.ArrayList;
import java.util.Stack;

import org.eclipse.emf.codegen.jet.editor.util.JETDocumentReader;
import org.eclipse.emf.codegen.jet.editor.util.keywords.JETTemplateDirectiveKeywords;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;

/**
 * @author jcheuoua
 * 
 * To change the template for this generated type comment go to Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code
 * and Comments
 * @version $Revision: 1.2 $
 */
public class JETTemplateDirectiveCompletionProcessor implements IContentAssistProcessor {

  /**
   * Method getAllWords.
   * @param c
   *          char
   * @param reader
   *          JETDocumentReader
   * @return String[]
   */
  private String[] getAllWords(char c, JETDocumentReader reader) {
    ArrayList all = new ArrayList(20);
    char currChar = c;
    currChar = trimBlanksBackward(reader, currChar);
    boolean done = false;
    while (!done) {
      Stack stack = new Stack();
      while (currChar != '\uFFFF' && !Character.isWhitespace(currChar)) {
        stack.push(new Character(currChar));
        currChar = reader.readBackward();
      }        
      String s = new String();
      while (!stack.empty())
        s = s + ((Character) stack.pop()).toString();      
      int jspPt = s.indexOf("<%@");
      if (jspPt >= 0) {
        s = s.substring(jspPt + 3);
        done = true;
      }
      all.add(s);
      currChar = trimBlanksBackward(reader, currChar);
      if (currChar == '\uFFFF' || currChar == '@')
        done = true;
    }
    return (String[]) all.toArray(new String[all.size()]);
  }

  /**
   * Method trimBlanksBackward.
   * 
   * @param reader
   *          JETDocumentReader
   * @param currChar
   *          char
   * @return char
   */
  private char trimBlanksBackward(JETDocumentReader reader, char currChar) {
    while (currChar != '\uFFFF' && Character.isWhitespace(currChar))
      currChar = reader.readBackward();
    return currChar;
  }

  /**
   * Method computeCompletionProposals.
   * 
   * @param viewer
   *          ITextViewer
   * @param documentOffset
   *          int
   * @return ICompletionProposal[]
   * @see org.eclipse.jface.text.contentassist.IContentAssistProcessor#computeCompletionProposals(ITextViewer, int)
   */
  public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentOffset) {
    org.eclipse.jface.text.IDocument doc = viewer.getDocument();
    JETDocumentReader reader = new JETDocumentReader(doc, documentOffset);
    char c = reader.readBackward();
    ICompletionProposal result[] = (ICompletionProposal[]) null;
    String allWords[] = getAllWords(c, reader);
    if (Character.isSpaceChar(c)) {
      String nonTagWords[] = JETTemplateDirectiveKeywords.getInnerKeywordsFor(allWords[allWords.length - 1]);
      result = new ICompletionProposal[nonTagWords.length];
      for (int i = 0; i < nonTagWords.length; i++)
        result[i] = new CompletionProposal(nonTagWords[i], documentOffset, 0, nonTagWords[i].length());
    } else if (c == '@') {
      String words[] = JETTemplateDirectiveKeywords.getTags();
      result = new ICompletionProposal[words.length];
      for (int i = 0; i < words.length; i++)
        result[i] = new CompletionProposal(words[i].substring(allWords[0].length()), documentOffset, 0, words[i]
            .length()
            - allWords[0].length(), null, words[i], null, null);

    } else if (Character.isLetter(c)) {
      String words[];
      if (allWords.length > 1)
        words = JETTemplateDirectiveKeywords.getNonTagsKeywordsWithPrefix(allWords[allWords.length - 1], allWords[0]);
      else
        words = JETTemplateDirectiveKeywords.getTagsWithPrefix(allWords[0]);
      result = new ICompletionProposal[words.length];
      for (int i = 0; i < words.length; i++)
        result[i] = new CompletionProposal(words[i].substring(allWords[0].length()), documentOffset, 0, words[i]
            .length()
            - allWords[0].length(), null, words[i], null, null);

    }
    return result;
  }

  /**
   * Method computeContextInformation.
   * 
   * @param viewer
   *          ITextViewer
   * @param documentOffset
   *          int
   * @return IContextInformation[]
   * @see org.eclipse.jface.text.contentassist.IContentAssistProcessor#computeContextInformation(ITextViewer, int)
   */
  public IContextInformation[] computeContextInformation(ITextViewer viewer, int documentOffset) {
    return null;
  }

  /**
   * Method getCompletionProposalAutoActivationCharacters.
   * 
   * @return char[]
   * @see org.eclipse.jface.text.contentassist.IContentAssistProcessor#getCompletionProposalAutoActivationCharacters()
   */
  public char[] getCompletionProposalAutoActivationCharacters() {
    return null;
  }

  /**
   * Method getContextInformationAutoActivationCharacters.
   * 
   * @return char[]
   * @see org.eclipse.jface.text.contentassist.IContentAssistProcessor#getContextInformationAutoActivationCharacters()
   */
  public char[] getContextInformationAutoActivationCharacters() {
    return null;
  }

  /**
   * Method getContextInformationValidator.
   * 
   * @return IContextInformationValidator
   * @see org.eclipse.jface.text.contentassist.IContentAssistProcessor#getContextInformationValidator()
   */
  public IContextInformationValidator getContextInformationValidator() {
    return null;
  }

  /**
   * Method getErrorMessage.
   * 
   * @return String
   * @see org.eclipse.jface.text.contentassist.IContentAssistProcessor#getErrorMessage()
   */
  public String getErrorMessage() {
    return null;
  }
}
