/*******************************************************************************
 * Copyright (c) 2005 - 2006 Joel Cheuoua & others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Joel Cheuoua - initial API and implementation
 *******************************************************************************/
package org.eclipse.emf.codegen.jet.editor.dyncheck;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.ui.javaeditor.JavaMarkerAnnotation;
import org.eclipse.jface.text.source.Annotation;

/**
 * A type of annotation for the errors in the JET editor.
 * @author Joel
 * @version $Revision: 1.2 $
 */
public class JETProblemAnnotation extends Annotation {

  
  private ICompilationUnit fCompilationUnit;
  private IProblem fProblem;
  
  
  /**
   * Constructor for JETProblemAnnotation.
   * @param problem IProblem
   * @param cu ICompilationUnit
   */
  public JETProblemAnnotation(IProblem problem, ICompilationUnit cu) {
    
    fProblem= problem;
    fCompilationUnit= cu;
    
    if (IProblem.Task == fProblem.getID()) {
      setType(JavaMarkerAnnotation.TASK_ANNOTATION_TYPE);
    } else if (fProblem.isWarning()) {
      setType(JavaMarkerAnnotation.WARNING_ANNOTATION_TYPE);
    } else if (fProblem.isError()) {
      setType(JavaMarkerAnnotation.ERROR_ANNOTATION_TYPE);
    } else {
      setType(JavaMarkerAnnotation.INFO_ANNOTATION_TYPE);
    }
  }
  
  /*
   * @see Annotation#getText()
   */
  public String getText() {
    return fProblem.getMessage();
  }
        
  /*
   * @see org.eclipse.jdt.internal.ui.javaeditor.IJavaAnnotation#getCompilationUnit()
   */
  public ICompilationUnit getCompilationUnit() {
    return fCompilationUnit;
  }
}