/*******************************************************************************
 * Copyright (c) 2005 - 2006 Joel Cheuoua & others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Joel Cheuoua - initial API and implementation
 *******************************************************************************/
package org.eclipse.emf.codegen.jet.editor.presentation;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.codegen.jet.editor.JETEditorPlugin;
import org.eclipse.emf.common.ui.ViewerPane;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.MultiPageSelectionProvider;
import org.eclipse.ui.texteditor.IStatusField;
import org.eclipse.ui.texteditor.ITextEditorExtension;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.PropertySheetPage;

/**
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class JETEditor extends FormEditor implements ITextEditorExtension, IMenuListener, IGotoMarker {
	
	public static final String ID = "org.eclipse.emf.codegen.jet.editor";
	
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final String copyright = "(c) 2005 Joel Cheuoua & Contributors";
	
	/**
	 * This is the content outline page.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IContentOutlinePage contentOutlinePage;
	
	/**
	 * This is a kludge... 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IStatusLineManager contentOutlineStatusLineManager;
	
	/**
	 * This is the content outline page's viewer.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TreeViewer contentOutlineViewer;
	
	/**
	 * This is the property sheet page.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PropertySheetPage propertySheetPage;
	
	/**
	 * This keeps track of the active viewer pane, in the book. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ViewerPane currentViewerPane;
	
	/**
	 * This keeps track of the active content viewer, which may be either one of the viewers in the pages or the content
	 * outline viewer.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Viewer currentViewer;
	
	/**
	 * This listens to which ever viewer is active.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ISelectionChangedListener selectionChangedListener;
	
	protected JETTextEditor jetTextEditor = new JETTextEditor();  
	
	/**
	 * This creates a JET editor. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public JETEditor() {
		super();
	}
	
	
	/**
	 * This returns the JET Text editor. 
	 */
	public JETTextEditor getJetTextEditor() {
		return jetTextEditor;
	}
	
	
	/**
	 * This is the method used by the framework to install 
	 * your own controls. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public void addPages() {
		// Create a page for the JET Text Editor
		try {
			int pageIndex = addPage(jetTextEditor, getEditorInput());
			setPageText(pageIndex, JETEditorPlugin.getDefault().getString("_UI_JETTemplateEdition_title"));
		} catch (PartInitException e) {
			e.printStackTrace();
		}
		
		// Create a page for the preview.
		ViewerPane viewerPane = new ViewerPane(getSite().getPage(), JETEditor.this) {
			public Viewer createViewer(Composite composite) {
				Viewer viewer = null;
				IFileEditorInput fileEditorInput = (IFileEditorInput) getEditorInput();
				IFile file = fileEditorInput.getFile();
				if (file.getFileExtension().equals("javajet")) {
					viewer = new JETJavaPreviewViewer(composite);
				} else {
					viewer = new JETTextPreviewViewer(composite);
				}
				return viewer;
			}
		};
		viewerPane.createControl(getContainer());
		viewerPane.getViewer().setInput(getEditorInput());
		
		int pageIndex = addPage(viewerPane.getControl());
		setPageText(pageIndex, JETEditorPlugin.getDefault().getString("_UI_JETTemplatePreview_title"));
		
		getContainer().addControlListener(new ControlAdapter() {
			boolean guard = false;
			
			public void controlResized(ControlEvent event) {
				if (!guard) {
					guard = true;
					hideTabs();
					guard = false;
				}
			}
		});
	}
	
	/**
	 * If there is just one page in the multi-page editor part, this hides the single tab at the bottom. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected void hideTabs() {
		if (getPageCount() <= 1) {
			setPageText(0, "");
			if (getContainer() instanceof CTabFolder) {
				((CTabFolder) getContainer()).setTabHeight(1);
				Point point = getContainer().getSize();
				getContainer().setSize(point.x, point.y + 6);
			}
		}
	}
	
	/**
	 * This is how the framework determines which interfaces we implement. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public Object getAdapter(Class key) {
		if (key.equals(IContentOutlinePage.class)) {
			return getContentOutlinePage();
		} else if (key.equals(IPropertySheetPage.class)) {
			return getPropertySheetPage();
		} else if (key.equals(IGotoMarker.class)) {
			return this;
		} else {
			return super.getAdapter(key);
		}
	}
	
	/**
	 * This accesses a cached version of the content outliner. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public IContentOutlinePage getContentOutlinePage() {
		return contentOutlinePage;
	}
	
	/**
	 * This accesses a cached version of the property sheet. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public IPropertySheetPage getPropertySheetPage() {
		return propertySheetPage;
	}
	
	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public boolean isDirty() {
		return (jetTextEditor != null) && jetTextEditor.isDirty();
	}
	
	/**
	 * <!-- begin-user-doc --> 
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void doSave(IProgressMonitor progressMonitor) {
		if (jetTextEditor != null)
			jetTextEditor.doSave(progressMonitor);
	}
	
	/**
	 * This always returns true because it is not currently supported. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public boolean isSaveAsAllowed() {
		if (jetTextEditor != null)
			return jetTextEditor.isSaveAsAllowed();
		return true;
	}
	
	/**
	 * This also changes the editor's input. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void doSaveAs() {
		if (jetTextEditor != null)
			jetTextEditor.doSaveAs();
	}
	
	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void gotoMarker(IMarker marker) {
		if (jetTextEditor != null) {
			IGotoMarker gotoMarker = (IGotoMarker) jetTextEditor.getAdapter(IGotoMarker.class);
			if (gotoMarker != null)
				gotoMarker.gotoMarker(marker);
		}
	}
	
	/**
	 * This is called during startup. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @throws PartInitException 
	 * 
	 * @generated
	 */
	public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
		setSite(site);
		setInput(editorInput);
		jetTextEditor.init(site, editorInput);
		setPartName(editorInput.getName());
		site.setSelectionProvider(new MultiPageSelectionProvider(this));    
	}
	
	/**
	 * This implements {@link org.eclipse.jface.action.IMenuListener} to help fill the context menus with contributions
	 * from the Edit menu. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void menuAboutToShow(IMenuManager menuManager) {
		((IMenuListener) getEditorSite().getActionBarContributor()).menuAboutToShow(menuManager);
	}
	
	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void dispose() {
		if (propertySheetPage != null) {
			propertySheetPage.dispose();
		}
		if (contentOutlinePage != null) {
			contentOutlinePage.dispose();
		}
		super.dispose();
	}
	
	public void setStatusField(IStatusField field, String category) {
		if (jetTextEditor != null)
			jetTextEditor.setStatusField(field, category);
	}
	
	public boolean isEditorInputReadOnly() {
		if (jetTextEditor != null)
			jetTextEditor.isEditorInputReadOnly();
		return false;
	}
	
	public void addRulerContextMenuListener(IMenuListener listener) {
		if (jetTextEditor != null)
			jetTextEditor.addRulerContextMenuListener(listener);
	}
	
	public void removeRulerContextMenuListener(IMenuListener listener) {
		if (jetTextEditor != null)
			jetTextEditor.removeRulerContextMenuListener(listener);
	}
	
}
