/*******************************************************************************
 * Copyright (c) 2005 - 2006 Joel Cheuoua & others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Joel Cheuoua - initial API and implementation
 *******************************************************************************/
package org.eclipse.emf.codegen.jet.editor.scanners;

import org.eclipse.jdt.internal.ui.text.AbstractJavaScanner;
import org.eclipse.jdt.ui.text.IColorManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Color;

/**
 * This class factorize some behaviours between the JET code scanners
 * @author jcheuoua
 * @version $Revision: 1.2 $
 */
public abstract class AbstractJETTemplateScanner extends AbstractJavaScanner {
	
	private IColorManager colorManager;
	protected IPreferenceStore preferenceStore;
	
	/**
	 * Constructor for AbstractJETTemplateScanner.
	 * @param colorManager IColorManager
	 * @param preferenceStore IPreferenceStore
	 */
	public AbstractJETTemplateScanner(IColorManager colorManager, IPreferenceStore preferenceStore) {
		super(colorManager, preferenceStore);
		this.colorManager = colorManager;
		this.preferenceStore = preferenceStore;
	}

	/**
	 * Method getColor.
	 * @param colorType String
	 * @return Color
	 */
	public Color getColor(String colorType) {
		return colorManager.getColor(colorType);
	}
}
