/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.cdo.CDOElement;
import org.eclipse.emf.cdo.common.CDOCommonRepository;
import org.eclipse.emf.cdo.edit.CDOItemProviderAdapter;
import org.eclipse.emf.cdo.internal.common.RepositoryProperties;
import org.eclipse.emf.cdo.internal.ui.bundle.OM;
import org.eclipse.emf.cdo.internal.ui.editor.CDOEditor;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.EMFEditPlugin;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.internal.cdo.object.ObjectProperties;
import org.eclipse.emf.internal.cdo.session.SessionProperties;
import org.eclipse.emf.internal.cdo.view.ViewProperties;
import org.eclipse.emf.spi.cdo.InternalCDOObject;
import org.eclipse.emf.spi.cdo.InternalCDOView;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.net4j.util.lifecycle.LifecycleException;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.properties.IPropertyProvider;
import org.eclipse.net4j.util.ui.AbstractPropertyAdapterFactory;
import org.eclipse.net4j.util.ui.DefaultActionFilter;
import org.eclipse.net4j.util.ui.DefaultPropertySource;
import org.eclipse.ui.IActionFilter;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class CDOPropertyAdapterFactory
extends AbstractPropertyAdapterFactory {
    private static final IActionFilter REPOSITORY_ACTION_FILTER = new DefaultActionFilter((IPropertyProvider)RepositoryProperties.INSTANCE);
    private static final IActionFilter SESSION_ACTION_FILTER = new DefaultActionFilter((IPropertyProvider)SessionProperties.INSTANCE);
    private static final IActionFilter VIEW_ACTION_FILTER = new DefaultActionFilter((IPropertyProvider)ViewProperties.INSTANCE);
    private static final IActionFilter OBJECT_ACTION_FILTER = new DefaultActionFilter((IPropertyProvider)ObjectProperties.INSTANCE);

    protected IPropertySource createPropertySource(Object object) {
        block16: {
            try {
                InternalCDOView view;
                EObject eObject;
                InternalCDOObject cdoObject;
                if (object instanceof CDOCommonRepository) {
                    return new DefaultPropertySource((Object)((CDOCommonRepository)object), (IPropertyProvider)RepositoryProperties.INSTANCE);
                }
                if (object instanceof CDOSession) {
                    return new DefaultPropertySource((Object)((CDOSession)object), (IPropertyProvider)SessionProperties.INSTANCE);
                }
                if (object instanceof CDOView) {
                    return new DefaultPropertySource((Object)((CDOView)object), (IPropertyProvider)ViewProperties.INSTANCE);
                }
                if (object instanceof CDOElement) {
                    object = ((CDOElement)object).getDelegate();
                }
                if (!(object instanceof EObject) || (cdoObject = (InternalCDOObject)CDOUtil.getCDOObject((EObject)(eObject = (EObject)object), (boolean)false)) == null || cdoObject.cdoInvalid() || (view = cdoObject.cdoView()) == null || !view.isActive()) break block16;
                final HashMap<String, Object> emfProperties = new HashMap<String, Object>();
                DefaultPropertySource<EObject> result = new DefaultPropertySource<EObject>((EObject)cdoObject, (IPropertyProvider)ObjectProperties.INSTANCE){

                    public Object getPropertyValue(Object id) {
                        try {
                            Object value = emfProperties.get(id);
                            if (value != null) {
                                return value;
                            }
                            return super.getPropertyValue(id);
                        }
                        catch (Throwable ex) {
                            return null;
                        }
                    }
                };
                ComposedAdapterFactory adapterFactory = null;
                AdapterFactoryLabelProvider labelProvider = null;
                try {
                    List propertyDescriptors;
                    adapterFactory = CDOEditor.createAdapterFactory(false);
                    IItemPropertySource propertySource = null;
                    try {
                        propertySource = (IItemPropertySource)adapterFactory.adapt((Notifier)cdoObject.cdoInternalInstance(), IItemPropertySource.class);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (propertySource != null && (propertyDescriptors = propertySource.getPropertyDescriptors((Object)cdoObject)) != null) {
                        labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)adapterFactory);
                        for (IItemPropertyDescriptor propertyDescriptor : propertyDescriptors) {
                            if (propertyDescriptor instanceof CDOItemProviderAdapter.CDOPropertyDescriptor) continue;
                            String category = CDOPropertyAdapterFactory.getTypeText(adapterFactory, (EObject)cdoObject);
                            String id = "___EMF___" + propertyDescriptor.getId((Object)cdoObject);
                            String displayName = propertyDescriptor.getDisplayName((Object)cdoObject);
                            String description = propertyDescriptor.getDescription((Object)cdoObject);
                            PropertyDescriptor descriptor = result.addDescriptor(category, (Object)id, displayName, description);
                            Object value = propertyDescriptor.getPropertyValue((Object)cdoObject);
                            emfProperties.put(id, value);
                            final String text = labelProvider.getText(value);
                            descriptor.setLabelProvider((ILabelProvider)new LabelProvider(){

                                public String getText(Object element) {
                                    return text;
                                }
                            });
                        }
                    }
                }
                finally {
                    if (labelProvider != null) {
                        labelProvider.dispose();
                    }
                    if (adapterFactory != null) {
                        adapterFactory.dispose();
                    }
                }
                return result;
            }
            catch (LifecycleException eObject) {
            }
            catch (Throwable ex) {
                if (!LifecycleUtil.isActive((Object)object)) break block16;
                OM.LOG.error(ex);
            }
        }
        return null;
    }

    protected IActionFilter createActionFilter(Object object) {
        EObject eObject;
        if (object instanceof CDOCommonRepository) {
            return REPOSITORY_ACTION_FILTER;
        }
        if (object instanceof CDOSession) {
            return SESSION_ACTION_FILTER;
        }
        if (object instanceof CDOView) {
            return VIEW_ACTION_FILTER;
        }
        if (object instanceof EObject && CDOUtil.isCDOObject((EObject)(eObject = (EObject)object))) {
            return OBJECT_ACTION_FILTER;
        }
        return super.createActionFilter(object);
    }

    public static String getTypeText(ComposedAdapterFactory adapterFactory, EObject eObject) {
        String typeKey = eObject.eClass().getName();
        ArrayList originalAdapters = new ArrayList(eObject.eAdapters());
        try {
            String string = CDOPropertyAdapterFactory.getResourceLocator(adapterFactory, eObject).getString("_UI_" + typeKey + "_type");
            return string;
        }
        catch (Exception exception) {
        }
        finally {
            eObject.eAdapters().retainAll(originalAdapters);
        }
        return typeKey;
    }

    private static ResourceLocator getResourceLocator(ComposedAdapterFactory adapterFactory, EObject eObject) {
        Adapter adapter = adapterFactory.getRootAdapterFactory().adapt((Notifier)eObject, IItemLabelProvider.class);
        if (adapter instanceof ResourceLocator) {
            return (ResourceLocator)adapter;
        }
        return EMFEditPlugin.INSTANCE;
    }
}

