/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.command;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.sequence.util.SequenceUtil;

public class ReconnectToGateCommand
extends AbstractTransactionalCommand {
    public static final String REDIRECT_GATE_FAILED = "Reconnect to gate failed.";
    private EditPartViewer editPartViewer;
    private IAdaptable newEndAdapter;
    private ReconnectRequest reconnectRequest;
    private Command command;

    public ReconnectToGateCommand(TransactionalEditingDomain domain, EditPartViewer editPartViewer, IAdaptable newEndAdapter, ReconnectRequest reconnectRequest) {
        super(domain, "Reconnect Relationship", null);
        this.editPartViewer = editPartViewer;
        this.newEndAdapter = newEndAdapter;
        this.reconnectRequest = reconnectRequest;
    }

    public boolean canExecute() {
        return this.editPartViewer != null && this.newEndAdapter != null && this.reconnectRequest != null;
    }

    public List getAffectedFiles() {
        View view;
        if (this.newEndAdapter != null && (view = (View)this.newEndAdapter.getAdapter(View.class)) != null) {
            ArrayList<IFile> result = new ArrayList<IFile>();
            IFile file = WorkspaceSynchronizer.getFile((Resource)view.eResource());
            if (file != null) {
                result.add(file);
            }
            return result;
        }
        return super.getAffectedFiles();
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        View view = (View)this.newEndAdapter.getAdapter(View.class);
        EditPart target = (EditPart)this.editPartViewer.getEditPartRegistry().get(view);
        boolean redirected = false;
        EditPart oldTarget = this.reconnectRequest.getTarget();
        Point location = this.reconnectRequest.getLocation();
        if (target != null) {
            this.reconnectRequest.setTargetEditPart(target);
            this.reconnectRequest.setLocation(SequenceUtil.getAbsoluteBounds((IGraphicalEditPart)target).getCenter());
            this.command = target.getCommand((Request)this.reconnectRequest);
            if (this.command != null && this.command.canExecute()) {
                this.command.execute();
                redirected = true;
            }
        }
        if (!redirected) {
            this.reconnectRequest.setTargetEditPart(oldTarget);
            this.reconnectRequest.setLocation(location);
            this.reconnectRequest.getExtendedData().put(REDIRECT_GATE_FAILED, Boolean.TRUE);
            this.command = oldTarget.getCommand((Request)this.reconnectRequest);
            if (this.command != null && this.command.canExecute()) {
                this.command.execute();
            }
        }
        return CommandResult.newOKCommandResult();
    }
}

