/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.policies;

import java.lang.reflect.Field;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.Tool;
import org.eclipse.gef.tools.SelectionTool;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.ConnectionHandleEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class SequenceConnectionHandleEditPolicy
extends ConnectionHandleEditPolicy {
    protected boolean shouldShowDiagramAssistant() {
        if (!(this.getHost().isActive() && this.isPreferenceOn() && this.isHostEditable() && this.isHostResolvable() && this.isDiagramPartActive())) {
            return false;
        }
        return !this.hasHandles() && this.isSelectionToolActive();
    }

    private boolean hasHandles() {
        try {
            Field f = ConnectionHandleEditPolicy.class.getDeclaredField("handles");
            f.setAccessible(true);
            Object handles = f.get((Object)this);
            return handles != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isSelectionToolActive() {
        Tool theTool;
        return this.getHost().getParent() != null && (theTool = this.getHost().getViewer().getEditDomain().getActiveTool()) != null && theTool instanceof SelectionTool;
    }

    private boolean isDiagramPartActive() {
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            IWorkbenchPart activePart = page.getActivePart();
            IDiagramWorkbenchPart editorPart = null;
            if (activePart instanceof IDiagramWorkbenchPart) {
                editorPart = (IDiagramWorkbenchPart)activePart;
            } else if (activePart instanceof IAdaptable) {
                editorPart = (IDiagramWorkbenchPart)activePart.getAdapter(IDiagramWorkbenchPart.class);
            }
            if (editorPart == null) {
                return false;
            }
            return editorPart.getDiagramEditPart().getRoot().equals(((IGraphicalEditPart)this.getHost()).getRoot());
        }
        return false;
    }

    private boolean isHostEditable() {
        if (this.getHost() instanceof GraphicalEditPart) {
            return ((GraphicalEditPart)this.getHost()).isEditModeEnabled();
        }
        return true;
    }

    private boolean isHostResolvable() {
        View view = (View)this.getHost().getModel();
        EObject element = view.getElement();
        if (element != null) {
            return !element.eIsProxy();
        }
        return true;
    }
}

