/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.server.folding;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.Position;
import org.eclipse.xtext.ide.editor.folding.FoldingRange;
import org.eclipse.xtext.ide.editor.folding.IFoldingRangeProvider;
import org.eclipse.xtext.ide.server.Document;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.CancelIndicator;

@Singleton
public class FoldingRangeService {
    @Inject
    private IFoldingRangeProvider foldingRangeProvider;

    public List<org.eclipse.lsp4j.FoldingRange> createFoldingRanges(Document document, XtextResource resource, CancelIndicator cancelIndicator) {
        if (resource == null || document == null) {
            return Collections.emptyList();
        }
        return this.foldingRangeProvider.getFoldingRanges(resource, cancelIndicator).stream().map(range -> this.toFoldingRange(document, (FoldingRange)range)).filter(range -> this.isValidRange((org.eclipse.lsp4j.FoldingRange)range)).collect(Collectors.toList());
    }

    protected org.eclipse.lsp4j.FoldingRange toFoldingRange(Document document, FoldingRange range) {
        int offset = range.getOffset();
        int length = range.getLength();
        int endOffset = offset + length;
        Position start = document.getPosition(offset);
        Position end = document.getPosition(endOffset);
        org.eclipse.lsp4j.FoldingRange result = new org.eclipse.lsp4j.FoldingRange(start.getLine(), end.getLine());
        if (range.getKind() != null) {
            result.setKind(range.getKind().toString());
        }
        return result;
    }

    protected boolean isValidRange(org.eclipse.lsp4j.FoldingRange range) {
        return range.getStartLine() < range.getEndLine();
    }
}

